/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.Administrator;
import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.MethodsPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class MethodDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField methodName;
    private JTextField methodDescription;
    private final MethodsPane parent;

    public MethodDialog(MethodsPane parent, String title, boolean modal) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Add Method", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.setTitle(title);
        this.setModal(modal);
        this.setSize(300, 200);
        this.render();
        this.setVisible(true);
    }

    public MethodDialog(MethodsPane parent, String title, boolean modal, String txt_methodName, String txt_methodDesc) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Edit Method", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.setTitle(title);
        this.setModal(modal);
        this.setSize(300, 200);
        this.render();
        this.methodName.setText(txt_methodName);
        this.methodDescription.setText(txt_methodDesc);
        this.setVisible(true);
    }

    private void render() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridLayout(3, 2));
        textPanel.add(new JLabel("Method Name: "));
        this.methodName = new JTextField();
        textPanel.add(this.methodName);
        textPanel.add(new JLabel("Method Description: "));
        this.methodDescription = new JTextField();
        textPanel.add(this.methodDescription);
        textPanel.setName("text");
        JButton done = new JButton("OK");
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodDialog.this.saveMethodFields();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodDialog.this.cancel();
            }
        });
        JPanel mainButtonPanel = new JPanel();
        mainButtonPanel.add(done);
        mainButtonPanel.add(cancel);
        this.getContentPane().add((Component)textPanel, "Center");
        this.getContentPane().add((Component)mainButtonPanel, "South");
        JRootPane root = this.getRootPane();
        root.setDefaultButton(done);
    }

    private void saveMethodFields() {
        if (this.validMethod()) {
            try {
                this.parent.setSDepMethod(this.methodName.getText().trim(), this.methodDescription.getText().trim());
                this.setVisible(false);
                this.dispose();
            }
            catch (DeploymentBuilderException e) {
                this.parent.assertMethodExistsMsg("The method name already exists.");
            }
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean validMethod() {
        if (this.methodName.getText() == null || this.methodName.getText().trim().equals("")) {
            this.parent.assertNoMethodMsg("You must enter a method name");
            return false;
        }
        if (this.methodDescription.getText() == null || this.methodDescription.getText().trim().equals("")) {
            this.parent.assertNoMethodMsg("You must enter a method description");
            return false;
        }
        return true;
    }
}

