/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.Administrator;
import fedora.client.deployment.ComboBoxRenderer;
import fedora.client.deployment.ComboBoxTableCellEditor;
import fedora.client.deployment.MethodsPane;
import fedora.client.deployment.ServiceDeploymentBuilder;
import fedora.client.deployment.data.MethodParm;
import fedora.client.deployment.data.MethodProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class MethodPropertiesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final MethodsPane parent;
    private final String builderClassName;
    private final String methodName;
    private String baseURL;
    private JTable parmTable;
    private JRadioButton rb_httpRelative;
    private JRadioButton rb_httpFull;
    private JRadioButton rb_httpDS;
    private JRadioButton rb_soap;
    private JTextField URL_textRelative;
    private JTextField URL_textFull;
    private JTextField URL_textDS;
    private JTextField returnMIMES;
    private JButton helpURL;
    private MethodProperties mp;
    private final HashMap<String, String> parmTypeTbl = new HashMap();
    private final HashMap<String, String> parmTypeToDisplayTbl = new HashMap();
    private final HashMap<String, String> passByTbl = new HashMap();
    private final HashMap<String, String> passByToDisplayTbl = new HashMap();
    private final HashMap<String, String> parmReqTbl = new HashMap();
    private final HashMap<String, String> parmReqToDisplayTbl = new HashMap();

    private void loadParmTypeTbl() {
        this.parmTypeTbl.put("USER", "fedora:userInputType");
        this.parmTypeTbl.put("DATASTREAM", "fedora:datastreamInputType");
        this.parmTypeTbl.put("DEFAULT", "fedora:defaultInputType");
    }

    private void loadParmTypeToDisplayTbl() {
        this.parmTypeToDisplayTbl.put("fedora:userInputType", "USER");
        this.parmTypeToDisplayTbl.put("fedora:datastreamInputType", "DATASTREAM");
        this.parmTypeToDisplayTbl.put("fedora:defaultInputType", "DEFAULT");
    }

    private void loadPassByTbl() {
        this.passByTbl.put("URL_REF", "URL_REF");
        this.passByTbl.put("VALUE", "VALUE");
    }

    private void loadPassByToDisplayTbl() {
        this.passByToDisplayTbl.put("URL_REF", "URL_REF");
        this.passByToDisplayTbl.put("VALUE", "VALUE");
    }

    private void loadParmReqTbl() {
        this.parmReqTbl.put("YES", "true");
        this.parmReqTbl.put("NO", "false");
    }

    private void loadParmReqToDisplayTbl() {
        this.parmReqToDisplayTbl.put("true", "YES");
        this.parmReqToDisplayTbl.put("false", "NO");
    }

    public MethodPropertiesDialog(MethodsPane parent, String methodName, MethodProperties methodProperties) {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Add Method Properties", true);
        this.setLocation(100, 100);
        this.loadParmTypeTbl();
        this.loadParmTypeToDisplayTbl();
        this.loadPassByTbl();
        this.loadPassByToDisplayTbl();
        this.loadParmReqTbl();
        this.loadParmReqToDisplayTbl();
        this.parent = parent;
        this.builderClassName = parent.parent.getClass().getName();
        this.methodName = methodName;
        this.setTitle("Method Properties for: " + methodName);
        this.setSize(850, 400);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel bindingPanel = null;
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            if (parent.hasBaseURL()) {
                this.baseURL = parent.getBaseURL().endsWith("/") ? parent.getBaseURL() : parent.getBaseURL() + "/";
            }
            bindingPanel = this.setBindingPanel();
        }
        JPanel parmsPanel = this.setParmsPanel();
        JPanel returnPanel = this.setMethodReturnPanel();
        JButton done = new JButton("OK");
        done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialog.this.saveProperties();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialog.this.cancelProperties();
            }
        });
        JPanel mainButtonPanel = new JPanel();
        mainButtonPanel.add(done);
        mainButtonPanel.add(cancel);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout());
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            lowerPanel.add((Component)returnPanel, "North");
        }
        lowerPanel.add((Component)mainButtonPanel, "South");
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            this.getContentPane().add((Component)bindingPanel, "North");
        }
        this.getContentPane().add((Component)parmsPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.renderCurrentProperties(methodProperties);
        JRootPane root = this.getRootPane();
        root.setDefaultButton(done);
        this.setVisible(true);
    }

    private JPanel setBindingPanel() {
        this.helpURL = new JButton("Help");
        this.helpURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialog.this.showURLHelp();
            }
        });
        this.rb_httpDS = new JRadioButton("Fedora LOCAL HTTP Resolver: (enter datastream parm name)", false);
        this.rb_httpDS.setActionCommand("http");
        this.URL_textDS = new JTextField(30);
        this.URL_textDS.setToolTipText("Enter the datastream parameter name in parentheses.  See Help button for more details on syntax.");
        this.rb_httpFull = new JRadioButton("Multi-Server Service: (enter full URL for method)", false);
        this.rb_httpFull.setActionCommand("httpFull");
        this.URL_textFull = new JTextField(30);
        this.URL_textFull.setToolTipText("Enter the full URL for the service method. The URL should use the replacement syntax described in the Help button.");
        String rLabel = "HTTP URL (relative):       " + this.baseURL;
        this.rb_httpRelative = new JRadioButton(rLabel, false);
        this.rb_httpRelative.setActionCommand("httprel");
        this.URL_textRelative = new JTextField(30);
        this.URL_textRelative.setMinimumSize(new Dimension(200, this.URL_textRelative.getMinimumSize().height));
        this.URL_textRelative.setToolTipText("Enter relative URL for the service method  See Help button for more details on syntax.");
        this.rb_soap = new JRadioButton("SOAP Binding (auto-generated)", false);
        this.rb_soap.setActionCommand("soap");
        this.rb_soap.setEnabled(false);
        ButtonGroup rb_buttonGroup = new ButtonGroup();
        if (this.parent.hasBaseURL()) {
            this.rb_httpRelative.setSelected(true);
            rb_buttonGroup.add(this.rb_httpRelative);
        } else if (this.parent.isMultiServer()) {
            this.rb_httpFull.setSelected(true);
            rb_buttonGroup.add(this.rb_httpFull);
        } else if (this.parent.isLocalHTTP()) {
            this.rb_httpDS.setSelected(true);
            rb_buttonGroup.add(this.rb_httpDS);
        }
        rb_buttonGroup.add(this.rb_soap);
        JPanel bindingPanel = new JPanel();
        bindingPanel.setBorder(new TitledBorder("Method Binding:"));
        bindingPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(15, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        if (this.parent.hasBaseURL()) {
            bindingPanel.add((Component)this.rb_httpRelative, gbc);
        } else if (this.parent.isMultiServer()) {
            bindingPanel.add((Component)this.rb_httpFull, gbc);
        } else if (this.parent.isLocalHTTP()) {
            bindingPanel.add((Component)this.rb_httpDS, gbc);
        }
        gbc.gridx = 1;
        if (this.parent.hasBaseURL()) {
            bindingPanel.add((Component)this.URL_textRelative, gbc);
        } else if (this.parent.isMultiServer()) {
            bindingPanel.add((Component)this.URL_textFull, gbc);
        } else if (this.parent.isLocalHTTP()) {
            bindingPanel.add((Component)this.URL_textDS, gbc);
        }
        gbc.gridx = 2;
        bindingPanel.add((Component)this.helpURL, gbc);
        gbc.insets = new Insets(2, 2, 15, 2);
        gbc.gridy = 1;
        gbc.gridx = 0;
        bindingPanel.add((Component)this.rb_soap, gbc);
        return bindingPanel;
    }

    private JPanel setParmsPanel() {
        this.parmTable = new JTable(20, 7);
        this.parmTable.setColumnSelectionAllowed(false);
        this.parmTable.setRowSelectionAllowed(true);
        this.parmTable.setRowHeight(18);
        TableColumn tc0 = this.parmTable.getColumnModel().getColumn(0);
        tc0.setHeaderValue("Parm Name");
        TableColumn tc1 = this.parmTable.getColumnModel().getColumn(1);
        tc1.setHeaderValue("Parm Type");
        tc1.sizeWidthToFit();
        String[] parmTypes = this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName()) ? this.parmTypeTbl.keySet().toArray(new String[0]) : new String[]{this.parmTypeToDisplayTbl.get("fedora:userInputType")};
        tc1.setCellRenderer(new ComboBoxRenderer(parmTypes));
        tc1.setCellEditor(new ComboBoxTableCellEditor(parmTypes));
        TableColumn tc2 = this.parmTable.getColumnModel().getColumn(2);
        tc2.setHeaderValue("Required?");
        String[] parmReq = this.parmReqTbl.keySet().toArray(new String[0]);
        tc2.setCellRenderer(new ComboBoxRenderer(parmReq));
        tc2.setCellEditor(new ComboBoxTableCellEditor(parmReq));
        TableColumn tc3 = this.parmTable.getColumnModel().getColumn(3);
        tc3.setHeaderValue("Pass By");
        String[] parmPassBy = this.passByTbl.keySet().toArray(new String[0]);
        tc3.setCellRenderer(new ComboBoxRenderer(parmPassBy));
        tc3.setCellEditor(new ComboBoxTableCellEditor(parmPassBy));
        TableColumn tc4 = this.parmTable.getColumnModel().getColumn(4);
        tc4.setHeaderValue("Default Value");
        TableColumn tc5 = this.parmTable.getColumnModel().getColumn(5);
        tc5.setHeaderValue("Description");
        TableColumn tc6 = this.parmTable.getColumnModel().getColumn(6);
        tc6.setHeaderValue("Valid Values (a,b)");
        JScrollPane scrollpane = new JScrollPane(this.parmTable);
        scrollpane.setColumnHeaderView(this.parmTable.getTableHeader());
        scrollpane.getViewport().setBackground(Color.white);
        JButton jb1 = new JButton("AddRow");
        jb1.setMinimumSize(new Dimension(100, 30));
        jb1.setMaximumSize(new Dimension(100, 30));
        jb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialog.this.addTableRow();
            }
        });
        JButton jb2 = new JButton("Delete");
        jb2.setMinimumSize(new Dimension(100, 30));
        jb2.setMaximumSize(new Dimension(100, 30));
        jb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialog.this.deleteTableRow();
            }
        });
        JButton jb3 = new JButton("Help");
        jb3.setMinimumSize(new Dimension(100, 30));
        jb3.setMaximumSize(new Dimension(100, 30));
        jb3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialog.this.helpTable();
            }
        });
        JPanel t_buttonPanel = new JPanel();
        t_buttonPanel.setLayout(new BoxLayout(t_buttonPanel, 1));
        t_buttonPanel.add(jb1);
        t_buttonPanel.add(jb2);
        t_buttonPanel.add(jb3);
        JPanel parmsPanel = new JPanel(new BorderLayout());
        parmsPanel.setBorder(new TitledBorder("Method Parameter Definitions:"));
        parmsPanel.add((Component)scrollpane, "Center");
        parmsPanel.add((Component)t_buttonPanel, "East");
        return parmsPanel;
    }

    private JPanel setMethodReturnPanel() {
        this.returnMIMES = new JTextField(30);
        JPanel returnPanel = new JPanel();
        returnPanel.setBorder(new TitledBorder("Method Return Types:"));
        returnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 17;
        gbc2.insets = new Insets(15, 2, 15, 2);
        gbc2.gridy = 0;
        gbc2.gridx = 0;
        returnPanel.add((Component)new JLabel("MIME types (comma delimit):"), gbc2);
        gbc2.gridx = 1;
        returnPanel.add((Component)this.returnMIMES, gbc2);
        return returnPanel;
    }

    private void addTableRow() {
        ((DefaultTableModel)this.parmTable.getModel()).addRow(new Object[]{"", "", "", "", ""});
    }

    private void deleteTableRow() {
        ((DefaultTableModel)this.parmTable.getModel()).removeRow(this.parmTable.getSelectedRow());
    }

    private void helpTable() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("The Method Properties Pane is used to define method parameters for the selected method. Each parameter has the following properties:\n\n Name - the name of the parameter (required)\n\n Type - the type of the parameter. (required) For Service Definition objects, the only valid type is USER. For Service Deployment objects, valid types include USER (user parms), DATASTREAM (datastream parms), and DEFAULT (deployment default parms)\n\n Required - boolean flag that specifies whether the parameter is required. (required)\n\n PassBy - determines whether the parameter value is passed by-reference or by-value (required)\n\n DefaultValue - value indicating the default value for the parameter if one is not provided. (optional)\n\n Description - label describing the parameter. (optional)\n\n ValidValues - comma delimited list of valid values for the parameter. (optional)\n\n");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Abstract Methods Tab", 0);
    }

    private void showURLHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.append("The Method Binding entry pane must specify an appropriate URL syntax necessary to run a particular service method being defined for this  Service Deployment object.\n\n Fedora uses the URL replacement syntax defined in the WSDL 1.1 specification (see http://www.w3.org/TR/wsdl) to encode  placeholders in a URL for parameter values.");
        helptxt.append("  A parameter placeholder is created by putting a Fedora-specific parameter name inside parentheses, and inserting this within the URL at the spot in the URL where the parameter value should be. Each parameter value name must then be listed in the Parameter Definition table which further specifies the nature of the parameter value. At runtime, Fedora will insert the actual parameter value in the URL exactly where the parameter placeholders exists.  At runtime, the values for parameters will either be obtained from the user or resolved by the Fedora repository system.  In the case of 'DATASTREAM' parameters you are specifying that the method takes input that is the content of a Datastream in the Fedora data object that is being disseminated. In this dialog, you will define a Fedora-specific binding key name to be used as a handle by which the appropriate Datastream(s) can be identified by Fedora at runtime (i.e., when the URL replacement is being resolved).\n\n Here is how Fedora will resolve the placeholders at run time:\n Within the service method URL, Fedora will insert a value for 'DATASTREAM' parameters that consists of the callback URL(s) of the Datastream(s) that must act as input on the service method URL being defined here. In the case of 'USER INPUT' parameters, Fedora will acquire user input and put the user-supplied data into the parameter value on the service method URL. In the case of 'SYSTEM' parameters, Fedora will use the Default Value defined in the Method Parameter Definition table of this dialog.\n\n Generally, there are three types of service method bindings that can be specified here:\n\n");
        helptxt.append("CASE 1: A relative URL representing a service method.\n\n The service method's base URL will have been carried over from the Service Methods Tab.\n Use the following syntax to complete the relative URL and encode your method parameters for the method binding:\n\n");
        helptxt.append("/mymethod?myparm1=(parmname1)&myparm2=(parmname2)\n");
        helptxt.append("For example:\n");
        helptxt.append("/resize_image?image=(IMGDATASTREAM)&size=(USERSIZE)\n\n");
        helptxt.append("CASE 2: A fully qualified URL representing a service method.\n this option is enabled if you entered 'Multi-Server Service' on the 'Service Methods' panel. Use the following syntax to encode your parameters within a fully qualified URL for the method binding:\n\n");
        helptxt.append("http://myserver.com/myservice/mymethod?myparm1=(parmname1)&myparm2=(parmname2)\n");
        helptxt.append("For example:\n");
        helptxt.append("http://localhost:8080/imgsizer/resize_image?image=(IMGDATASTREAM)&size=(USERSIZE)\n\n");
        helptxt.append("CASE 3:  No URL - just a 'DATASTREAM' replacement parameter.  This is enabled if you entered 'Fedora Built-in Datastream Resolver' on the 'Service Methods' panel.\n In this case you do not need a URL to run a service method since there is no independent service being called to run the behavor method. Instead, Fedora we want to signal Fedora to just return a particular Datastream  that is bound to the Service method definition.  In this case, all that is required is that you enter a Datastream binding key name in parentheses. The same binding key name should be entered in the Method Parameter Definitions table. In the table, these types of parameters should be set to a Parm Type value of 'DATASTREAM' and a Pass By value of 'URL REF.'  At runtime, the Fedora repository will look for Datastream(s) n the target data object are tagged with the binding key name specified here.  Fedora will just return the content of the Datastream(s) in in response to running the method defined here.\n\n");
        helptxt.append("Use the following syntax to encode your parameter within the method binding URL box:\n\n");
        helptxt.append("(parmname1)\n");
        helptxt.append("For example:\n");
        helptxt.append("(HIGHRESIMAGE)\n");
        JScrollPane js = new JScrollPane(helptxt);
        js.setPreferredSize(new Dimension(400, 500));
        JOptionPane.showMessageDialog(this, js, "Help for Method Binding URL", 0);
    }

    private void saveProperties() {
        this.setMethodProperties();
        MethodProperties properties = this.getMethodProperties();
        if (this.validMethodProperties(properties)) {
            this.mp.wasValidated = true;
            if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
                this.mp.dsBindingKeys = this.filterDSBindingKeys(properties.methodParms);
            }
            this.parent.setMethodProperties(this.methodName, this.mp);
            this.setVisible(false);
            this.dispose();
        }
    }

    private void cancelProperties() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean parmsInURL(String http_URL, MethodParm[] parms) {
        for (MethodParm element : parms) {
            String pattern = "\\(" + element.parmName + "\\)";
            if (this.foundInString(http_URL, pattern) || element.parmName.equalsIgnoreCase("NULLBIND")) continue;
            System.out.println("The parm named " + element.parmName + " is not found in the HTTP method binding URL: " + http_URL);
            return false;
        }
        return true;
    }

    private boolean parmsFromURLMissing(String http_URL, MethodParm[] parms) {
        Vector<String> firstPassTokens = new Vector<String>();
        Vector<String> parmsInURL = new Vector<String>();
        Vector<String> tableParms = new Vector<String>();
        for (MethodParm element : parms) {
            tableParms.add(element.parmName);
        }
        StringTokenizer st1 = new StringTokenizer(http_URL, "(");
        while (st1.hasMoreTokens()) {
            String fpt = st1.nextToken();
            firstPassTokens.add(fpt);
        }
        for (String token : firstPassTokens) {
            StringTokenizer st2;
            Pattern pattern = Pattern.compile("\\)");
            Matcher m = pattern.matcher(token);
            if (!m.find() || !(st2 = new StringTokenizer(token, ")")).hasMoreTokens()) continue;
            String s = st2.nextToken();
            parmsInURL.add(s);
        }
        for (String parmInURL : parmsInURL) {
            if (tableParms.contains(parmInURL)) continue;
            return false;
        }
        return true;
    }

    private boolean foundInString(String inputString, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher m = pattern.matcher(inputString);
        return m.find();
    }

    private boolean validMethodProperties(MethodProperties mp) {
        return this.validBinding(mp) && this.validMethodParms(mp.methodParms) && this.validReturnTypes(mp.returnMIMETypes);
    }

    private boolean validReturnTypes(String[] mimeTypes) {
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName()) && mimeTypes.length <= 0) {
            this.assertMethodPropertiesMsg("You must enter an at least one return MIME type for method!");
            return false;
        }
        return true;
    }

    private boolean validBinding(MethodProperties mp) {
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            if (mp.methodFullURL == null || mp.methodFullURL.trim().equalsIgnoreCase("")) {
                this.assertMethodPropertiesMsg("You must enter an HTTP binding URL for method!");
                return false;
            }
            if (mp.methodRelativeURL.startsWith("http://") || mp.methodRelativeURL.startsWith("https://")) {
                this.assertMethodPropertiesMsg("A relative URL cannot begin with http:// or https://");
                return false;
            }
            if (!this.parmsInURL(mp.methodFullURL, mp.methodParms)) {
                this.assertMethodPropertiesMsg("A parm from the parm table is not encoded in the HTTP URL. See Help for URL replacement syntax.");
                return false;
            }
            if (!this.parmsFromURLMissing(mp.methodFullURL, mp.methodParms)) {
                this.assertMethodPropertiesMsg("The HTTP method binding URL has a parm encoded within it that is not listed in the method parm table. See Help for URL replacement syntax.");
                return false;
            }
        }
        return true;
    }

    private boolean validMethodParms(MethodParm[] parms) {
        for (int i = 0; i < parms.length; ++i) {
            if (this.validMethodParm(parms[i])) continue;
            return false;
        }
        System.out.println("Method parms are valid.");
        return true;
    }

    private boolean validMethodParm(MethodParm parm) {
        if (parm.parmType == null || parm.parmType.trim().equalsIgnoreCase("")) {
            this.assertMethodPropertiesMsg("A value for 'Parm Type' must be selected for parm " + parm.parmName);
            return false;
        }
        if (parm.parmRequired == null || parm.parmRequired.trim().equalsIgnoreCase("")) {
            this.assertMethodPropertiesMsg("A value for 'Required?' must be selected for parm " + parm.parmName);
            return false;
        }
        if (parm.parmPassBy == null || parm.parmPassBy.trim().equalsIgnoreCase("")) {
            this.assertMethodPropertiesMsg("A value for 'Pass By' must be selected for parm " + parm.parmName);
            return false;
        }
        if (parm.parmType.equalsIgnoreCase("fedora:datastreamInputType") && parm.parmPassBy.equalsIgnoreCase("VALUE")) {
            this.assertMethodPropertiesMsg("'Pass By' must be URL_REF when 'Parm Type' is fedora:datastreamInputType.");
            return false;
        }
        return true;
    }

    private MethodProperties getMethodProperties() {
        return this.mp;
    }

    private void setMethodProperties() {
        this.mp = new MethodProperties();
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            if (this.rb_httpDS.isSelected()) {
                this.mp.methodRelativeURL = this.mp.methodFullURL = this.URL_textDS.getText();
                this.mp.protocolType = "HTTP";
            } else if (this.rb_httpFull.isSelected()) {
                this.mp.methodFullURL = this.URL_textFull.getText();
                this.mp.methodRelativeURL = " ";
                this.mp.protocolType = "HTTP";
            } else if (this.rb_httpRelative.isSelected()) {
                this.mp.methodRelativeURL = this.URL_textRelative.getText();
                if (this.mp.methodRelativeURL.startsWith("/")) {
                    this.mp.methodRelativeURL = this.mp.methodRelativeURL.substring(1);
                }
                this.mp.methodFullURL = this.baseURL + this.mp.methodRelativeURL;
                this.mp.protocolType = "HTTP";
            }
        }
        this.mp.returnMIMETypes = this.unloadReturnTypes();
        this.mp.methodParms = this.unloadMethodParms();
    }

    private String[] filterDSBindingKeys(MethodParm[] parms) {
        Vector<String> dsbindkeys = new Vector<String>();
        for (MethodParm element : parms) {
            if (!element.parmType.equalsIgnoreCase("fedora:datastreamInputType")) continue;
            dsbindkeys.add(element.parmName);
        }
        return dsbindkeys.toArray(new String[0]);
    }

    private MethodParm[] unloadMethodParms() {
        if (this.parmTable.isEditing()) {
            this.parmTable.getCellEditor().stopCellEditing();
        }
        HashMap<String, MethodParm> parmMap = new HashMap<String, MethodParm>();
        int rowcount = this.parmTable.getModel().getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            String parmName = (String)this.parmTable.getValueAt(i, 0);
            if (parmName != null) {
                parmName = parmName.trim();
            }
            if (parmName == null || parmName.equalsIgnoreCase("") || parmName.equalsIgnoreCase(" ")) continue;
            MethodParm parm = new MethodParm();
            parm.parmName = parmName;
            parm.parmType = this.parmTypeTbl.get(this.parmTable.getValueAt(i, 1));
            parm.parmRequired = this.parmReqTbl.get(this.parmTable.getValueAt(i, 2));
            parm.parmPassBy = this.passByTbl.get(this.parmTable.getValueAt(i, 3));
            parm.parmDefaultValue = (String)this.parmTable.getValueAt(i, 4);
            parm.parmLabel = (String)this.parmTable.getValueAt(i, 5);
            Vector<String> domainValues = new Vector<String>();
            String values = (String)this.parmTable.getValueAt(i, 6);
            if (values != null) {
                String normalizedString = this.normalizeString(values);
                StringTokenizer st = new StringTokenizer(normalizedString, ",");
                while (st.hasMoreElements()) {
                    domainValues.add(((String)st.nextElement()).trim());
                }
                parm.parmDomainValues = domainValues.toArray(new String[0]);
            }
            parmMap.put(parm.parmName, parm);
        }
        return parmMap.values().toArray(new MethodParm[0]);
    }

    private String[] unloadReturnTypes() {
        Vector<String> mimeTypes = new Vector<String>();
        String normalizedString = this.normalizeString(this.returnMIMES.getText());
        StringTokenizer st = new StringTokenizer(normalizedString, ",");
        while (st.hasMoreElements()) {
            mimeTypes.add(((String)st.nextElement()).trim());
        }
        return mimeTypes.toArray(new String[0]);
    }

    private String normalizeString(String values) {
        String original = values.trim();
        Pattern spaces = Pattern.compile(" ++");
        Matcher m = spaces.matcher(original);
        String interim = m.replaceAll(",");
        Pattern multcommas = Pattern.compile(",++");
        Matcher m2 = multcommas.matcher(interim);
        String normal = m2.replaceAll(",");
        if (normal.endsWith(",")) {
            int endcomma = normal.lastIndexOf(",");
            normal = normal.substring(0, endcomma);
        }
        return normal;
    }

    private void renderCurrentProperties(MethodProperties properties) {
        if (properties == null) {
            return;
        }
        if (this.builderClassName.equalsIgnoreCase(ServiceDeploymentBuilder.class.getName())) {
            this.renderBindingProperties(properties);
            this.renderReturnProperties(properties);
            this.renderParmProperties(properties);
        } else {
            this.renderParmProperties(properties);
        }
    }

    private void renderParmProperties(MethodProperties properties) {
        MethodParm[] parms = properties.methodParms;
        for (int i = 0; i < parms.length; ++i) {
            int freeRows = this.parmTable.getRowCount();
            if (parms.length > freeRows) {
                int newRows = parms.length - freeRows;
                for (int j = 0; j < newRows; ++j) {
                    ((DefaultTableModel)this.parmTable.getModel()).addRow(new Object[]{"", "", "", "", ""});
                }
            }
            this.parmTable.setValueAt(parms[i].parmName, i, 0);
            TableCellEditor ce = this.parmTable.getCellEditor(i, 1);
            ce.getTableCellEditorComponent(this.parmTable, this.parmTypeToDisplayTbl.get(parms[i].parmType), true, i, 1);
            this.parmTable.setValueAt(ce.getCellEditorValue(), i, 1);
            ce = this.parmTable.getCellEditor(i, 2);
            ce.getTableCellEditorComponent(this.parmTable, this.parmReqToDisplayTbl.get(parms[i].parmRequired), true, i, 2);
            this.parmTable.setValueAt(ce.getCellEditorValue(), i, 2);
            ce = this.parmTable.getCellEditor(i, 3);
            ce.getTableCellEditorComponent(this.parmTable, this.passByToDisplayTbl.get(parms[i].parmPassBy), true, i, 3);
            this.parmTable.setValueAt(ce.getCellEditorValue(), i, 3);
            this.parmTable.setValueAt(parms[i].parmDefaultValue, i, 4);
            this.parmTable.setValueAt(parms[i].parmLabel, i, 5);
            StringBuffer sb2 = new StringBuffer();
            for (int i2 = 0; i2 < parms[i].parmDomainValues.length; ++i2) {
                sb2.append(parms[i].parmDomainValues[i2]);
                int j = i2 + 1;
                if (j == parms[i].parmDomainValues.length) continue;
                sb2.append(",");
            }
            this.parmTable.setValueAt(sb2.toString(), i, 6);
        }
    }

    private void renderReturnProperties(MethodProperties properties) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < properties.returnMIMETypes.length; ++i) {
            sb.append(properties.returnMIMETypes[i]);
            int j = i + 1;
            if (j == properties.returnMIMETypes.length) continue;
            sb.append(",");
        }
        this.returnMIMES.setText(sb.toString());
    }

    private void renderBindingProperties(MethodProperties properties) {
        if (this.parent.hasBaseURL()) {
            this.rb_httpRelative.setSelected(true);
            if (properties.methodRelativeURL != null) {
                this.URL_textRelative.setText(properties.methodRelativeURL);
            }
            this.rb_httpDS.setSelected(false);
            this.rb_httpFull.setSelected(false);
            this.URL_textDS.setEnabled(false);
            this.URL_textFull.setEnabled(false);
        } else if (this.parent.isMultiServer()) {
            this.rb_httpFull.setSelected(true);
            if (properties.methodFullURL != null) {
                this.URL_textFull.setText(properties.methodFullURL);
            }
            this.rb_httpDS.setSelected(false);
            this.rb_httpRelative.setSelected(false);
            this.URL_textDS.setEnabled(false);
            this.URL_textRelative.setEnabled(false);
        } else if (this.parent.isLocalHTTP()) {
            this.rb_httpDS.setSelected(true);
            if (properties.methodFullURL != null) {
                this.URL_textDS.setText(properties.methodFullURL);
            }
            this.rb_httpFull.setSelected(false);
            this.rb_httpRelative.setSelected(false);
            this.URL_textFull.setEnabled(false);
            this.URL_textRelative.setEnabled(false);
        }
        this.rb_soap.setSelected(false);
    }

    private void assertMethodPropertiesMsg(String msg) {
        JOptionPane.showMessageDialog(this, new String(msg), "Method Properties Message", 1);
    }
}

