/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.BObjTemplate;
import fedora.client.deployment.data.Datastream;
import fedora.client.deployment.xml.XMLWriter;
import fedora.common.Constants;
import fedora.server.utilities.DateUtility;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BObjMETSSerializer
implements Constants {
    protected PrintWriter out;
    protected Document document;
    protected Element root;
    protected Element bObjFileSec;
    protected Vector<String> docDSIDs = new Vector();
    protected BObjTemplate bObjData;
    protected String now;

    public BObjMETSSerializer(BObjTemplate bObjData) throws DeploymentBuilderException {
        this.bObjData = bObjData;
        this.now = DateUtility.convertDateToString(new Date());
    }

    protected abstract Element[] getInlineMD() throws DeploymentBuilderException;

    protected abstract Attr[] getVariableRootAttrs() throws DeploymentBuilderException;

    protected void serialize() throws DeploymentBuilderException {
        this.initializeTree();
        this.genBaseMETS(this.bObjData);
        this.finalizeTree();
    }

    protected void initializeTree() throws DeploymentBuilderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new DeploymentBuilderException("BObjMETSSerializer:  Parser configuration exception initializing document builder.");
        }
        this.root = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:mets");
        this.bObjFileSec = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:fileSec");
    }

    protected void finalizeTree() throws DeploymentBuilderException {
        Element[] mdSecs;
        this.document.appendChild(this.root);
        for (Element element : mdSecs = this.getInlineMD()) {
            this.root.appendChild(element);
        }
        this.root.appendChild(this.bObjFileSec);
    }

    protected void genBaseMETS(BObjTemplate bObjData) throws DeploymentBuilderException {
        this.setMETSRoot(bObjData);
        this.setBObjFileSec(bObjData);
    }

    protected void setMETSRoot(BObjTemplate bObjData) throws DeploymentBuilderException {
        Attr[] attrSet;
        String pid;
        this.root.setAttributeNS(BObjMETSSerializer.XMLNS.uri, "xmlns:METS", BObjMETSSerializer.METS.uri);
        this.root.setAttributeNS(BObjMETSSerializer.XMLNS.uri, "xmlns:xlink", BObjMETSSerializer.XLINK.uri);
        this.root.setAttributeNS(BObjMETSSerializer.XSI.uri, "xsi:schemaLocation", BObjMETSSerializer.METS.uri + " " + BObjMETSSerializer.METS_EXT1_1.xsdLocation);
        String string = pid = bObjData.getbObjPID() == null ? "" : bObjData.getbObjPID();
        if (!pid.equals("")) {
            this.root.setAttribute("OBJID", pid);
        }
        String label = bObjData.getbObjLabel() == null ? "" : bObjData.getbObjLabel();
        this.root.setAttribute("LABEL", label);
        for (Attr element : attrSet = this.getVariableRootAttrs()) {
            this.root.setAttributeNodeNS(element);
        }
    }

    protected void setBObjFileSec(BObjTemplate bObjData) {
        Element datastreamsFileGrp = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:fileGrp");
        datastreamsFileGrp.setAttribute("ID", "DATASTREAMS");
        Datastream[] docs = bObjData.getDocDatastreams();
        for (int i = 0; i < docs.length; ++i) {
            Element dsFileGrp = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:fileGrp");
            String dsid = "DS" + (i + 1);
            dsFileGrp.setAttribute("ID", dsid);
            dsFileGrp.setAttribute("STATUS", "A");
            Element dsFile = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:file");
            dsFile.setAttribute("ID", dsid + ".0");
            dsFile.setAttribute("CREATED", this.now);
            dsFile.setAttribute("SEQ", "0");
            dsFile.setAttribute("MIMETYPE", docs[i].dsMIMEType);
            dsFile.setAttribute("OWNERID", docs[i].dsControlGrpType);
            dsFile.setAttribute("STATUS", "A");
            Element dsFileLoc = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:FLocat");
            dsFileLoc.setAttribute("LOCTYPE", "URL");
            dsFileLoc.setAttributeNS(BObjMETSSerializer.XLINK.uri, "xlink:href", docs[i].dsURL);
            dsFileLoc.setAttributeNS(BObjMETSSerializer.XLINK.uri, "xlink:title", docs[i].dsLabel);
            dsFile.appendChild(dsFileLoc);
            dsFileGrp.appendChild(dsFile);
            datastreamsFileGrp.appendChild(dsFileGrp);
            this.docDSIDs.add(dsid);
        }
        this.bObjFileSec.appendChild(datastreamsFileGrp);
    }

    protected Element setDC(Element dc) throws DeploymentBuilderException {
        Element dcNode = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:dmdSecFedora");
        dcNode.setAttribute("ID", "DC");
        Element descMD = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:descMD");
        descMD.setAttribute("ID", "DC1.0");
        descMD.setAttribute("CREATED", this.now);
        descMD.setAttribute("STATUS", "A");
        Element mdWrap = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:mdWrap");
        mdWrap.setAttribute("MIMETYPE", "text/xml");
        mdWrap.setAttribute("MDTYPE", "OTHER");
        mdWrap.setAttribute("LABEL", "Dublin Core Metadata for Service");
        Element xmlData = this.document.createElementNS(BObjMETSSerializer.METS.uri, "METS:xmlData");
        Node importDC = this.document.importNode(dc, true);
        xmlData.appendChild(importDC);
        mdWrap.appendChild(xmlData);
        descMD.appendChild(mdWrap);
        dcNode.appendChild(descMD);
        return dcNode;
    }

    public void printMETS() {
        try {
            String str = new XMLWriter(new DOMResult(this.document)).getXMLAsString();
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeMETSFile(File file) throws DeploymentBuilderException {
        try {
            XMLWriter w = new XMLWriter(this.document);
            w.writeXMLToFile(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentBuilderException("BObjMETSSerializer:  IO or parser exception writing METS file. Underlying exception was: " + e.getMessage());
        }
    }

    public InputStream writeMETSStream() throws DeploymentBuilderException {
        InputStream in = null;
        try {
            XMLWriter w = new XMLWriter(this.document);
            in = w.writeXMLToStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentBuilderException("BObjMETSSerializer:  IO or parser exception writing METS to stream. Underlying exception was: " + e.getMessage());
        }
        return in;
    }
}

