/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.BObjTemplate;
import fedora.client.deployment.data.Method;
import fedora.client.deployment.data.MethodParm;
import fedora.client.deployment.data.ServiceDeploymentTemplate;
import fedora.client.deployment.xml.XMLWriter;
import fedora.common.Constants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MethodMapGenerator
implements Constants {
    private Document document;

    public MethodMapGenerator(ServiceDeploymentTemplate newSDep) throws DeploymentBuilderException {
        this.createDOM();
        this.genMethodMap(newSDep);
    }

    public MethodMapGenerator(BObjTemplate newSDef) throws DeploymentBuilderException {
        this.createDOM();
        this.genMethodMap(newSDef);
    }

    private void createDOM() throws DeploymentBuilderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new DeploymentBuilderException("MethodMapGenerator: error configuring parser.Underlying exception: " + pce.getMessage());
        }
    }

    private void genMethodMap(BObjTemplate newSDef) {
        Method[] methods = newSDef.getMethods();
        Element root = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:MethodMap");
        root.setAttributeNS(MethodMapGenerator.XMLNS.uri, "xmlns:fmm", MethodMapGenerator.METHOD_MAP.uri);
        String sdeflabel = newSDef.getbObjLabel() == null ? "fix me" : newSDef.getbObjLabel();
        root.setAttribute("name", "MethodMap - " + sdeflabel);
        this.document.appendChild(root);
        for (Method element : methods) {
            MethodParm[] parms;
            Element method = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:Method");
            String mname = element.methodName;
            String mlabel = element.methodLabel == null ? "fix me" : element.methodLabel;
            method.setAttribute("operationName", mname.trim());
            method.setAttribute("label", mlabel.trim());
            root.appendChild(method);
            for (MethodParm element2 : parms = element.methodProperties.methodParms) {
                Element parm = null;
                if (element2.parmType.equalsIgnoreCase("fedora:userInputType")) {
                    parm = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:UserInputParm");
                }
                String name = element2.parmName == null ? "" : element2.parmName;
                parm.setAttribute("parmName", name);
                String passby = element2.parmPassBy == null ? "" : element2.parmPassBy;
                parm.setAttribute("passBy", passby);
                String req = element2.parmRequired == null ? "" : element2.parmRequired;
                parm.setAttribute("required", req);
                String def = element2.parmDefaultValue == null ? "" : element2.parmDefaultValue;
                parm.setAttribute("defaultValue", def);
                String label = element2.parmLabel == null ? "" : element2.parmLabel;
                parm.setAttribute("label", label);
                if (element2.parmDomainValues.length > 0) {
                    Element parmDomain = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:ValidParmValues");
                    for (String element3 : element2.parmDomainValues) {
                        Element parmDomainVal = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:ValidParm");
                        String value = element3 == null ? "" : element3;
                        parmDomainVal.setAttribute("value", value);
                        parmDomain.appendChild(parmDomainVal);
                    }
                    parm.appendChild(parmDomain);
                }
                method.appendChild(parm);
            }
        }
    }

    private void genMethodMap(ServiceDeploymentTemplate newSDep) {
        Method[] methods = newSDep.getMethods();
        Element root = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:MethodMap");
        String bmlabel = newSDep.getbObjLabel() == null ? "fix me" : newSDep.getbObjLabel();
        root.setAttribute("name", "MethodMap - " + bmlabel);
        root.setAttribute("bDefPID", newSDep.getSDefContractPID());
        this.document.appendChild(root);
        for (Method element : methods) {
            MethodParm[] parms;
            Element method = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:Method");
            String mname = element.methodName;
            String mlabel = element.methodLabel == null ? "fix me" : element.methodLabel;
            method.setAttribute("operationName", mname.trim());
            method.setAttribute("operationLabel", mlabel.trim());
            method.setAttribute("wsdlMsgName", mname.trim() + "Request");
            method.setAttribute("wsdlMsgOutput", "dissemResponse");
            root.appendChild(method);
            for (MethodParm element2 : parms = element.methodProperties.methodParms) {
                Element parm = null;
                if (element2.parmType.equalsIgnoreCase("fedora:datastreamInputType")) {
                    parm = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:DatastreamInputParm");
                } else if (element2.parmType.equalsIgnoreCase("fedora:userInputType")) {
                    parm = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:UserInputParm");
                } else if (element2.parmType.equalsIgnoreCase("fedora:defaultInputType")) {
                    parm = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:DefaultInputParm");
                }
                String name = element2.parmName == null ? "" : element2.parmName;
                parm.setAttribute("parmName", name);
                String passby = element2.parmPassBy == null ? "" : element2.parmPassBy;
                parm.setAttribute("passBy", passby);
                String req = element2.parmRequired == null ? "" : element2.parmRequired;
                parm.setAttribute("required", req);
                String def = element2.parmDefaultValue == null ? "" : element2.parmDefaultValue;
                parm.setAttribute("defaultValue", def);
                String label = element2.parmLabel == null ? "" : element2.parmLabel;
                parm.setAttribute("label", label);
                if (element2.parmDomainValues.length > 0) {
                    Element parmDomain = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:ValidParmValues");
                    for (String element3 : element2.parmDomainValues) {
                        Element parmDomainVal = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:ValidParm");
                        String value = element3 == null ? "" : element3;
                        parmDomainVal.setAttribute("value", value);
                        parmDomain.appendChild(parmDomainVal);
                    }
                    parm.appendChild(parmDomain);
                }
                method.appendChild(parm);
            }
            String[] mimeTypes = element.methodProperties.returnMIMETypes;
            StringBuffer sb = new StringBuffer();
            for (String element2 : mimeTypes) {
                sb.append(element2.toString() + " ");
            }
            Element methodReturn = this.document.createElementNS(MethodMapGenerator.METHOD_MAP.uri, "fmm:MethodReturnType");
            methodReturn.setAttribute("wsdlMsgName", "dissemResponse");
            methodReturn.setAttribute("wsdlMsgTOMIME", sb.toString().trim());
            method.appendChild(methodReturn);
        }
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public Document getDocument() {
        return this.document;
    }

    public void printMethodMap() {
        try {
            String str = new XMLWriter(new DOMResult(this.document)).getXMLAsString();
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

