/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.ServiceDeploymentTemplate;
import fedora.client.deployment.xml.BObjMETSSerializer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceDeploymentMETSSerializer
extends BObjMETSSerializer {
    private final Element in_dc;
    private final Element in_profile;
    private final Element in_dsInputSpec;
    private final Element in_methodMap;
    private final Element in_wsdl;

    public ServiceDeploymentMETSSerializer(ServiceDeploymentTemplate sDepData, Element dc, Element serviceProfile, Element dsInputSpec, Element methodMap, Element wsdl) throws DeploymentBuilderException {
        super(sDepData);
        this.in_dc = dc;
        this.in_profile = serviceProfile;
        this.in_dsInputSpec = dsInputSpec;
        this.in_methodMap = methodMap;
        this.in_wsdl = wsdl;
        this.serialize();
    }

    protected Attr[] getVariableRootAttrs() {
        Vector<Attr> v_attrs = new Vector<Attr>();
        Attr extVersion = this.document.createAttribute("EXT_VERSION");
        extVersion.setValue("1.1");
        v_attrs.add(extVersion);
        return v_attrs.toArray(new Attr[0]);
    }

    protected Element[] getInlineMD() throws DeploymentBuilderException {
        Vector<Element> v_elements = new Vector<Element>();
        v_elements.add(this.setDC(this.in_dc));
        v_elements.add(this.setServiceProfile(this.in_profile));
        v_elements.add(this.setDSInputSpec(this.in_dsInputSpec));
        v_elements.add(this.setMethodMap(this.in_methodMap));
        v_elements.add(this.setWSDL(this.in_wsdl));
        return v_elements.toArray(new Element[0]);
    }

    private Element setDSInputSpec(Element dsInputSpec) throws DeploymentBuilderException {
        Element dsInputNode = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:amdSec");
        dsInputNode.setAttribute("ID", "DSINPUTSPEC");
        Element techMD = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:techMD");
        techMD.setAttribute("ID", "DSINPUTSPEC1.0");
        techMD.setAttribute("CREATED", this.now);
        techMD.setAttribute("STATUS", "A");
        Element mdWrap = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:mdWrap");
        mdWrap.setAttribute("MIMETYPE", "text/xml");
        mdWrap.setAttribute("MDTYPE", "OTHER");
        mdWrap.setAttribute("LABEL", "Datastream Input Specification for Service");
        Element xmlData = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:xmlData");
        Node importDSInput = this.document.importNode(dsInputSpec, true);
        xmlData.appendChild(importDSInput);
        mdWrap.appendChild(xmlData);
        techMD.appendChild(mdWrap);
        dsInputNode.appendChild(techMD);
        return dsInputNode;
    }

    private Element setMethodMap(Element methodMap) throws DeploymentBuilderException {
        Element mmapNode = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:amdSec");
        mmapNode.setAttribute("ID", "METHODMAP");
        Element techMD = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:techMD");
        techMD.setAttribute("ID", "METHODMAP1.0");
        techMD.setAttribute("CREATED", this.now);
        techMD.setAttribute("STATUS", "A");
        Element mdWrap = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:mdWrap");
        mdWrap.setAttribute("MIMETYPE", "text/xml");
        mdWrap.setAttribute("MDTYPE", "OTHER");
        mdWrap.setAttribute("LABEL", "Mapping of WSDL to Fedora notion of Method Definitions");
        Element xmlData = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:xmlData");
        Node importMethodMap = this.document.importNode(methodMap, true);
        xmlData.appendChild(importMethodMap);
        mdWrap.appendChild(xmlData);
        techMD.appendChild(mdWrap);
        mmapNode.appendChild(techMD);
        return mmapNode;
    }

    private Element setWSDL(Element wsdl) throws DeploymentBuilderException {
        Element wsdlNode = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:amdSec");
        wsdlNode.setAttribute("ID", "WSDL");
        Element techMD = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:techMD");
        techMD.setAttribute("ID", "WSDL1.0");
        techMD.setAttribute("CREATED", this.now);
        techMD.setAttribute("STATUS", "A");
        Element mdWrap = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:mdWrap");
        mdWrap.setAttribute("MIMETYPE", "text/xml");
        mdWrap.setAttribute("MDTYPE", "OTHER");
        mdWrap.setAttribute("LABEL", "WSDL definition of service");
        Element xmlData = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:xmlData");
        Node importWSDL = this.document.importNode(wsdl, true);
        xmlData.appendChild(importWSDL);
        mdWrap.appendChild(xmlData);
        techMD.appendChild(mdWrap);
        wsdlNode.appendChild(techMD);
        return wsdlNode;
    }

    private Element setServiceProfile(Element serviceProfile) {
        Element profileNode = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:amdSec");
        profileNode.setAttribute("ID", "SERVICE-PROFILE");
        Element techMD = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:techMD");
        techMD.setAttribute("ID", "SERVICE-PROFILE1.0");
        techMD.setAttribute("CREATED", this.now);
        techMD.setAttribute("STATUS", "A");
        Element mdWrap = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:mdWrap");
        mdWrap.setAttribute("MIMETYPE", "text/xml");
        mdWrap.setAttribute("MDTYPE", "OTHER");
        mdWrap.setAttribute("LABEL", "Service Profile - Technical description of the service");
        Element xmlData = this.document.createElementNS(ServiceDeploymentMETSSerializer.METS.uri, "METS:xmlData");
        Node importProfile = this.document.importNode(serviceProfile, true);
        xmlData.appendChild(importProfile);
        mdWrap.appendChild(xmlData);
        techMD.appendChild(mdWrap);
        profileNode.appendChild(techMD);
        return profileNode;
    }
}

