/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment.xml;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.data.Method;
import fedora.client.deployment.data.MethodParm;
import fedora.client.deployment.data.ServiceDeploymentTemplate;
import fedora.client.deployment.xml.XMLWriter;
import fedora.common.Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDLGenerator
implements Constants {
    private static final String THIS = "bmech";
    private Document document;
    private Element root;
    private Element types;
    private Vector<Element> messageElements;
    private Element portType;
    private Element service;
    private Element binding;

    public WSDLGenerator(ServiceDeploymentTemplate newSDep) throws DeploymentBuilderException {
        this.initializeTree();
        this.genWSDL(newSDep);
        this.finalizeTree();
    }

    private void initializeTree() throws DeploymentBuilderException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new DeploymentBuilderException("WSDLGenerator: error configuring parser.Underlying exception: " + pce.getMessage());
        }
        this.root = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:definitions");
        this.types = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:types");
        this.messageElements = new Vector();
        this.portType = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:portType");
        this.service = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:service");
        this.binding = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:binding");
    }

    private void finalizeTree() {
        Element[] messages;
        this.document.appendChild(this.root);
        this.root.appendChild(this.types);
        for (Element element : messages = this.messageElements.toArray(new Element[0])) {
            this.root.appendChild(element);
        }
        this.root.appendChild(this.portType);
        this.root.appendChild(this.service);
        this.root.appendChild(this.binding);
    }

    private void genWSDL(ServiceDeploymentTemplate newSDep) {
        boolean hasBaseURL = newSDep.getHasBaseURL();
        String baseURL = newSDep.getServiceBaseURL();
        String sDefPID = newSDep.getSDefContractPID();
        String sDepLabel = newSDep.getbObjLabel();
        String sDepName = newSDep.getbObjName();
        Method[] methods = newSDep.getMethods();
        String name = sDepLabel == null ? "" : sDepLabel;
        this.root.setAttribute("name", name);
        this.root.setAttribute("targetNamespace", THIS);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:this", THIS);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:wsdl", WSDLGenerator.WSDL.uri);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:soap", WSDLGenerator.SOAP.uri);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:soapenc", WSDLGenerator.SOAP_ENC.uri);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:http", WSDLGenerator.WSDL_HTTP.uri);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:mime", WSDLGenerator.WSDL_MIME.uri);
        this.root.setAttributeNS(WSDLGenerator.XMLNS.uri, "xmlns:xsd", WSDLGenerator.XML_XSD.uri);
        this.createService(sDepName, hasBaseURL, baseURL);
        this.processMethods(sDepName, hasBaseURL, methods);
    }

    private void createService(String sDepName, boolean hasBaseURL, String baseURL) {
        this.service.setAttribute("name", sDepName);
        Element port = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:port");
        port.setAttribute("name", sDepName + "_port");
        port.setAttribute("binding", "this:" + sDepName + "_http");
        Element httpAddr = this.document.createElementNS(WSDLGenerator.WSDL_HTTP.uri, "http:address");
        if (hasBaseURL) {
            httpAddr.setAttribute("location", baseURL);
        } else {
            httpAddr.setAttribute("location", "LOCAL");
        }
        port.appendChild(httpAddr);
        this.service.appendChild(port);
        this.binding.setAttribute("name", sDepName + "_http");
        this.binding.setAttribute("type", "this:" + sDepName + "PortType");
        Element httpBinding = this.document.createElementNS(WSDLGenerator.WSDL_HTTP.uri, "http:binding");
        httpBinding.setAttribute("verb", "GET");
        this.binding.appendChild(httpBinding);
    }

    private void processMethods(String sDepName, boolean hasBaseURL, Method[] methods) {
        Element schema = this.document.createElementNS(WSDLGenerator.XML_XSD.uri, "xsd:schema");
        schema.setAttribute("targetNamespace", THIS);
        HashMap<String, MethodParm> parmUnion = new HashMap<String, MethodParm>();
        for (Method element : methods) {
            MethodParm[] parms;
            Element message = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:message");
            message.setAttribute("name", element.methodName + "Request");
            for (MethodParm element2 : parms = element.methodProperties.methodParms) {
                Element part = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:part");
                part.setAttribute("name", element2.parmName);
                part.setAttribute("type", "this:" + element2.parmName + "Type");
                message.appendChild(part);
                if (parmUnion.containsKey(element2.parmName)) {
                    MethodParm existingParm = (MethodParm)parmUnion.get(element2.parmName);
                    String[] existingDomain = existingParm.parmDomainValues;
                    HashSet<String> oldVals = new HashSet<String>();
                    for (String element3 : existingDomain) {
                        oldVals.add(element3);
                    }
                    String[] newDomain = element2.parmDomainValues;
                    HashSet<String> newVals = new HashSet<String>();
                    for (String element3 : newDomain) {
                        newVals.add(element3);
                    }
                    HashSet<String> unionVals = new HashSet<String>(oldVals);
                    unionVals.addAll(newVals);
                    existingParm.parmDomainValues = unionVals.toArray(new String[0]);
                    parmUnion.put(element2.parmName, existingParm);
                    continue;
                }
                parmUnion.put(element2.parmName, element2);
            }
            this.messageElements.add(message);
            this.portType.setAttribute("name", sDepName + "PortType");
            Element operation = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:operation");
            operation.setAttribute("name", element.methodName);
            Element input = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:input");
            input.setAttribute("message", "this:" + element.methodName + "Request");
            Element output = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:output");
            output.setAttribute("message", "this:dissemResponse");
            operation.appendChild(input);
            operation.appendChild(output);
            this.portType.appendChild(operation);
            Element wsdlOperation = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:operation");
            wsdlOperation.setAttribute("name", element.methodName);
            Element httpOperation = this.document.createElementNS(WSDLGenerator.WSDL_HTTP.uri, "http:operation");
            if (hasBaseURL) {
                httpOperation.setAttribute("location", element.methodProperties.methodRelativeURL);
            } else {
                httpOperation.setAttribute("location", element.methodProperties.methodFullURL);
            }
            Element wsdlInput = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:input");
            wsdlInput.appendChild(this.document.createElementNS(WSDLGenerator.WSDL_HTTP.uri, "http:urlReplacement"));
            Element wsdlOutput = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:output");
            String[] MIMETypes = element.methodProperties.returnMIMETypes;
            for (String element2 : MIMETypes) {
                Element MIMEType = this.document.createElementNS(WSDLGenerator.WSDL_MIME.uri, "mime:content");
                MIMEType.setAttribute("type", element2);
                wsdlOutput.appendChild(MIMEType);
            }
            wsdlOperation.appendChild(httpOperation);
            wsdlOperation.appendChild(wsdlInput);
            wsdlOperation.appendChild(wsdlOutput);
            this.binding.appendChild(wsdlOperation);
        }
        Element responseMessage = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:message");
        responseMessage.setAttribute("name", "dissemResponse");
        Element responseMessagePart = this.document.createElementNS(WSDLGenerator.WSDL.uri, "wsdl:part");
        responseMessagePart.setAttribute("name", "dissem");
        responseMessagePart.setAttribute("type", "xsd:base64Binary");
        responseMessage.appendChild(responseMessagePart);
        this.messageElements.add(responseMessage);
        for (MethodParm parm : parmUnion.values()) {
            String[] domainValues;
            Element typeDef = this.document.createElementNS(WSDLGenerator.XML_XSD.uri, "xsd:simpleType");
            typeDef.setAttribute("name", parm.parmName + "Type");
            Element restrict = this.document.createElementNS(WSDLGenerator.XML_XSD.uri, "xsd:restriction");
            restrict.setAttribute("base", "xsd:string");
            for (String element : domainValues = parm.parmDomainValues) {
                Element val = this.document.createElementNS(WSDLGenerator.XML_XSD.uri, "xsd:enumeration");
                val.setAttribute("value", element);
                restrict.appendChild(val);
            }
            typeDef.appendChild(restrict);
            schema.appendChild(typeDef);
        }
        this.types.appendChild(schema);
    }

    public Element getRootElement() {
        return this.document.getDocumentElement();
    }

    public void printWSDL() {
        try {
            String str = new XMLWriter(new DOMResult(this.document)).getXMLAsString();
            System.out.println(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

