/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.ingest;

import fedora.client.Administrator;
import fedora.client.FedoraClient;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.RepositoryInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class SourceRepoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JTextField m_serverField;
    private final JTextField m_protocolField;
    private final JTextField m_usernameField;
    private final JPasswordField m_passwordField;
    private FedoraAPIA m_apia;
    private FedoraAPIM m_apim;
    private RepositoryInfo m_repositoryInfo;
    private static String s_lastServer;
    private static String s_lastProtocol;
    private static String s_lastUsername;
    private static String s_lastPassword;
    private String m_protocol;
    private String m_host;
    private int m_port;

    public SourceRepoDialog() {
        super(JOptionPane.getFrameForComponent(Administrator.getDesktop()), "Source Repository", true);
        JPanel inputPane = new JPanel();
        inputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        GridBagLayout gridBag = new GridBagLayout();
        inputPane.setLayout(gridBag);
        JLabel serverLabel = new JLabel("Fedora Server");
        JLabel protocolLabel = new JLabel("Protocol");
        JLabel usernameLabel = new JLabel("Username");
        JLabel passwordLabel = new JLabel("Password");
        if (s_lastServer == null) {
            s_lastServer = "hostname:portnumber";
        }
        this.m_serverField = new JTextField(s_lastServer);
        if (s_lastProtocol == null) {
            s_lastProtocol = "http";
        }
        this.m_protocolField = new JTextField(s_lastProtocol);
        if (s_lastUsername == null) {
            s_lastUsername = "fedoraAdmin";
        }
        this.m_usernameField = new JTextField(s_lastUsername);
        if (s_lastPassword == null) {
            s_lastPassword = "";
        }
        this.m_passwordField = new JPasswordField(s_lastPassword);
        this.addLabelValueRows(new JLabel[]{serverLabel, protocolLabel, usernameLabel, passwordLabel}, new JComponent[]{this.m_serverField, this.m_protocolField, this.m_usernameField, this.m_passwordField}, gridBag, inputPane);
        JButton okButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                block12: {
                    if (SourceRepoDialog.this.m_passwordField.getPassword().length == 0 || SourceRepoDialog.this.m_usernameField.getText().equals("")) {
                        JOptionPane.showMessageDialog(Administrator.getDesktop(), "Username and password must both be non-empty", "Error", 0);
                    } else {
                        String[] hp = SourceRepoDialog.this.m_serverField.getText().split(":");
                        if (hp.length == 2) {
                            try {
                                SourceRepoDialog.this.m_protocol = SourceRepoDialog.this.m_protocolField.getText();
                                SourceRepoDialog.this.m_host = hp[0];
                                SourceRepoDialog.this.m_port = Integer.parseInt(hp[1]);
                                String baseURL = SourceRepoDialog.this.m_protocol + "://" + SourceRepoDialog.this.m_host + ":" + SourceRepoDialog.this.m_port + "/fedora";
                                FedoraClient fc = new FedoraClient(baseURL, SourceRepoDialog.this.m_usernameField.getText(), new String(SourceRepoDialog.this.m_passwordField.getPassword()));
                                SourceRepoDialog.this.m_apia = fc.getAPIA();
                                SourceRepoDialog.this.m_apim = fc.getAPIM();
                                try {
                                    SourceRepoDialog.this.m_repositoryInfo = SourceRepoDialog.this.m_apia.describeRepository();
                                    s_lastServer = SourceRepoDialog.this.m_host + ":" + SourceRepoDialog.this.m_port;
                                    s_lastProtocol = SourceRepoDialog.this.m_protocol;
                                    s_lastUsername = SourceRepoDialog.this.m_usernameField.getText();
                                    s_lastPassword = new String(SourceRepoDialog.this.m_passwordField.getPassword());
                                    SourceRepoDialog.this.dispose();
                                }
                                catch (Exception e) {
                                    boolean retry = false;
                                    if (e.getMessage().indexOf("Unauthorized") != -1 || e.getMessage().indexOf("Unrecognized") != -1) {
                                        Administrator.showErrorDialog(Administrator.getDesktop(), "Connection Error", "Bad username or password.", e);
                                        retry = true;
                                    }
                                    if (e.getMessage().indexOf("java.net") != -1) {
                                        Administrator.showErrorDialog(Administrator.getDesktop(), "Connection Error", "Can't connect to " + SourceRepoDialog.this.m_protocol + "://" + SourceRepoDialog.this.m_host + ":" + SourceRepoDialog.this.m_port, e);
                                        retry = true;
                                    }
                                    if (!retry) {
                                        s_lastServer = SourceRepoDialog.this.m_host + ":" + SourceRepoDialog.this.m_port;
                                        s_lastProtocol = SourceRepoDialog.this.m_protocol;
                                        s_lastUsername = SourceRepoDialog.this.m_usernameField.getText();
                                        s_lastPassword = new String(SourceRepoDialog.this.m_passwordField.getPassword());
                                        SourceRepoDialog.this.dispose();
                                        break block12;
                                    }
                                    e.printStackTrace();
                                }
                            }
                            catch (NumberFormatException nfe) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Error", "Server port must be numeric", nfe);
                            }
                            catch (Exception e) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Error", "Malformed host information", e);
                            }
                        } else {
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), "Server should be specified as host:port", "Error", 0);
                        }
                    }
                }
            }
        });
        okButton.setText("OK");
        JButton cancelButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                SourceRepoDialog.this.dispose();
            }
        });
        cancelButton.setText("Cancel");
        JPanel buttonPane = new JPanel();
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)inputPane, "Center");
        contentPane.add((Component)buttonPane, "South");
        this.pack();
        this.setLocation(Administrator.INSTANCE.getCenteredPos(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    public FedoraAPIA getAPIA() {
        return this.m_apia;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public FedoraAPIM getAPIM() {
        return this.m_apim;
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.m_repositoryInfo;
    }

    public void addLabelValueRows(JLabel[] labels, JComponent[] values, GridBagLayout gridBag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 6, 6, 6);
        for (int i = 0; i < labels.length; ++i) {
            c.anchor = 13;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            if (!(values[i] instanceof JComboBox)) {
                c.fill = 2;
            } else {
                c.anchor = 17;
            }
            c.weightx = 1.0;
            gridBag.setConstraints(values[i], c);
            container.add(values[i]);
        }
    }
}

