/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.ContentEditor;
import fedora.client.objecteditor.ContentHandlerFactory;
import fedora.client.objecteditor.ContentViewer;
import fedora.client.objecteditor.DatastreamsPane;
import fedora.client.objecteditor.EditingPane;
import fedora.client.objecteditor.ImageContentViewer;
import fedora.client.objecteditor.ImportDialog;
import fedora.client.objecteditor.ObjectEditorFrame;
import fedora.client.objecteditor.PotentiallyDirty;
import fedora.client.objecteditor.RDFTupleEditor;
import fedora.client.objecteditor.SVGContentViewer;
import fedora.client.objecteditor.TextContentEditor;
import fedora.server.types.gen.Datastream;
import fedora.server.utilities.StreamUtility;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class DatastreamPane
extends EditingPane
implements ChangeListener {
    private static final Logger LOG = Logger.getLogger((String)DatastreamPane.class.getName());
    private static final long serialVersionUID = 1L;
    protected String m_pid;
    private final Datastream m_mostRecent;
    protected JComboBox m_stateComboBox;
    protected static String[] s_stateComboBoxValues = new String[]{"A", "I", "D"};
    protected JComboBox m_versionableComboBox;
    private JSlider m_versionSlider;
    private final JPanel m_valuePane;
    private final CardLayout m_versionCardLayout;
    protected CurrentVersionPane m_currentVersionPane;
    protected DatastreamsPane m_owner;
    private final PurgeButtonListener m_purgeButtonListener;
    private boolean m_done;
    private final Dimension m_labelDims;
    private JTextArea m_dtLabel;
    private JPanel m_dateLabelAndValue;
    private final Datastream[] m_versions;
    protected static final int NEW_VERSION_ON_UPDATE = 0;
    protected static final int REPLACE_ON_UPDATE = 1;

    public DatastreamPane(ObjectEditorFrame gramps, String pid, Datastream[] versions, DatastreamsPane owner) throws Exception {
        super(gramps, owner, versions[0].getID());
        Datastream mostRecent;
        this.m_pid = pid;
        this.m_versions = versions;
        this.m_mostRecent = mostRecent = versions[0];
        this.m_owner = owner;
        this.m_labelDims = new JLabel("Control Group").getPreferredSize();
        new TextContentEditor();
        new ImageContentViewer();
        new SVGContentViewer();
        new RDFTupleEditor();
        JLabel idLabel = new JLabel("ID");
        JLabel stateLabel = new JLabel("State");
        JLabel versionableLabel = new JLabel("Versionable");
        JLabel controlGroupLabel = new JLabel("Control Group");
        JLabel[] leftCommonLabels = new JLabel[]{idLabel, controlGroupLabel, stateLabel, versionableLabel};
        String[] comboBoxStrings = new String[]{"Active", "Inactive", "Deleted"};
        this.m_stateComboBox = new JComboBox<String>(comboBoxStrings);
        Administrator.constrainHeight(this.m_stateComboBox);
        if (mostRecent.getState().equals("A")) {
            this.m_stateComboBox.setSelectedIndex(0);
            this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
        } else if (mostRecent.getState().equals("I")) {
            this.m_stateComboBox.setSelectedIndex(1);
            this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
        } else {
            this.m_stateComboBox.setSelectedIndex(2);
            this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
        }
        this.m_stateComboBox.addActionListener(this.dataChangeListener);
        this.m_stateComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String curState;
                if (DatastreamPane.this.m_stateComboBox.getSelectedIndex() == 1) {
                    curState = "I";
                    DatastreamPane.this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
                } else if (DatastreamPane.this.m_stateComboBox.getSelectedIndex() == 2) {
                    curState = "D";
                    DatastreamPane.this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
                } else {
                    curState = "A";
                    DatastreamPane.this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
                }
                DatastreamPane.this.m_owner.colorTabForState(DatastreamPane.this.m_mostRecent.getID(), curState);
            }
        });
        String[] comboBoxStrings2 = new String[]{"Updates will create new version", "Updates will replace most recent version"};
        this.m_versionableComboBox = new JComboBox<String>(comboBoxStrings2);
        Administrator.constrainHeight(this.m_versionableComboBox);
        this.m_versionableComboBox.setSelectedIndex(mostRecent.isVersionable() ? 0 : 1);
        this.m_versionableComboBox.addActionListener(this.dataChangeListener);
        JTextArea controlGroupValueLabel = new JTextArea(this.getControlGroupString(mostRecent.getControlGroup().toString()));
        controlGroupValueLabel.setBackground(Administrator.BACKGROUND_COLOR);
        controlGroupValueLabel.setEditable(false);
        JComponent[] leftCommonValues = new JComponent[]{new JLabel(mostRecent.getID()), controlGroupValueLabel, this.m_stateComboBox, this.m_versionableComboBox};
        JPanel leftCommonPane = new JPanel();
        GridBagLayout leftCommonGridBag = new GridBagLayout();
        leftCommonPane.setLayout(leftCommonGridBag);
        this.addLabelValueRows(leftCommonLabels, leftCommonValues, leftCommonGridBag, leftCommonPane);
        JPanel commonPane = leftCommonPane;
        this.m_purgeButtonListener = new PurgeButtonListener(versions);
        if (versions.length > 1) {
            this.m_versionSlider = new JSlider(0, 0, versions.length - 1, 0);
            this.m_versionSlider.addChangeListener(this);
            this.m_versionSlider.setMajorTickSpacing(1);
            this.m_versionSlider.setSnapToTicks(true);
            this.m_versionSlider.setPaintTicks(true);
        }
        this.m_valuePane = new JPanel();
        this.m_versionCardLayout = new CardLayout();
        this.m_valuePane.setLayout(this.m_versionCardLayout);
        JPanel[] valuePanes = new JPanel[versions.length];
        this.m_currentVersionPane = new CurrentVersionPane(mostRecent);
        valuePanes[0] = this.m_currentVersionPane;
        this.m_valuePane.add((Component)valuePanes[0], "0");
        for (int i = 1; i < versions.length; ++i) {
            valuePanes[i] = new PriorVersionPane(versions[i]);
            this.m_valuePane.add((Component)valuePanes[i], "" + i);
        }
        JPanel versionPane = new JPanel();
        versionPane.setLayout(new BorderLayout());
        if (versions.length > 1) {
            this.m_dateLabelAndValue = new JPanel(new FlowLayout(0, 4, 0));
            JLabel createdLabel = new JLabel("Created");
            createdLabel.setPreferredSize(this.m_labelDims);
            this.m_dateLabelAndValue.add(createdLabel);
            this.m_dateLabelAndValue.add(Box.createHorizontalStrut(0));
            this.m_dtLabel = new JTextArea(versions[0].getCreateDate() + " ");
            this.m_dtLabel.setBackground(Administrator.BACKGROUND_COLOR);
            this.m_dtLabel.setEditable(false);
            this.m_dateLabelAndValue.add(this.m_dtLabel);
            JPanel stretch = new JPanel(new BorderLayout());
            stretch.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            stretch.add((Component)this.m_dateLabelAndValue, "West");
            stretch.add((Component)this.m_versionSlider, "Center");
            versionPane.add((Component)stretch, "North");
        }
        versionPane.add((Component)this.m_valuePane, "Center");
        this.mainPane.setLayout(new BorderLayout());
        this.mainPane.add((Component)commonPane, "North");
        this.mainPane.add((Component)versionPane, "Center");
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            this.m_versionCardLayout.show(this.m_valuePane, "" + source.getValue());
            this.m_dtLabel.setText(this.m_versions[source.getValue()].getCreateDate());
        }
    }

    public boolean isDirty() {
        int versionableIndex;
        if (this.m_done) {
            return false;
        }
        int stateIndex = 0;
        if (this.m_mostRecent.getState().equals("I")) {
            stateIndex = 1;
        }
        if (this.m_mostRecent.getState().equals("D")) {
            stateIndex = 2;
        }
        if (stateIndex != this.m_stateComboBox.getSelectedIndex()) {
            return true;
        }
        int n = versionableIndex = this.m_mostRecent.isVersionable() ? 0 : 1;
        if (versionableIndex != this.m_versionableComboBox.getSelectedIndex()) {
            return true;
        }
        return this.m_currentVersionPane.isDirty();
    }

    private String getControlGroupString(String abbrev) {
        if (abbrev.equals("M")) {
            return "Managed Content";
        }
        if (abbrev.equals("X")) {
            return "Internal XML Metadata";
        }
        if (abbrev.equals("R")) {
            return "Redirect";
        }
        return "External Reference";
    }

    public static String getFormattedChecksumTypeAndChecksum(Datastream m_ds) {
        if (m_ds.getChecksumType() == null || m_ds.getChecksumType().equals("") || m_ds.getChecksumType().equals("none")) {
            return "";
        }
        if (m_ds.getChecksumType().equals("DISABLED")) {
            return "DISABLED";
        }
        return m_ds.getChecksumType() + ": " + m_ds.getChecksum();
    }

    public void saveChanges(String logMessage) throws Exception {
        block6: {
            String state = null;
            int i = this.m_stateComboBox.getSelectedIndex();
            state = s_stateComboBoxValues[i];
            if (!state.equals(this.m_mostRecent.getState())) {
                Administrator.APIM.setDatastreamState(this.m_pid, this.m_mostRecent.getID(), state, logMessage);
            }
            if ((this.m_mostRecent.isVersionable() ? 0 : 1) != this.m_versionableComboBox.getSelectedIndex()) {
                boolean newVersionableSetting = this.m_versionableComboBox.getSelectedIndex() == 0;
                Administrator.APIM.setDatastreamVersionable(this.m_pid, this.m_mostRecent.getID(), newVersionableSetting, logMessage);
            }
            if (this.m_currentVersionPane.isDirty()) {
                try {
                    this.m_currentVersionPane.saveChanges(logMessage, false);
                }
                catch (Exception e) {
                    if (e.getMessage() == null || e.getMessage().indexOf(" would invalidate ") == -1) {
                        throw e;
                    }
                    Object[] options = new Object[]{"Yes", "No"};
                    int selected = JOptionPane.showOptionDialog(null, e.getMessage() + "\n\nForce it?", "Warning", -1, 2, null, options, options[1]);
                    if (selected != 0) break block6;
                    this.m_currentVersionPane.saveChanges(logMessage, true);
                }
            }
        }
    }

    public void changesSaved() {
        this.m_owner.refresh(this.m_mostRecent.getID());
        this.m_done = true;
    }

    public void undoChanges() {
        if (this.m_mostRecent.getState().equals("A")) {
            this.m_stateComboBox.setSelectedIndex(0);
            this.m_stateComboBox.setBackground(Administrator.ACTIVE_COLOR);
        } else if (this.m_mostRecent.getState().equals("I")) {
            this.m_stateComboBox.setSelectedIndex(1);
            this.m_stateComboBox.setBackground(Administrator.INACTIVE_COLOR);
        } else if (this.m_mostRecent.getState().equals("D")) {
            this.m_stateComboBox.setSelectedIndex(2);
            this.m_stateComboBox.setBackground(Administrator.DELETED_COLOR);
        }
        if ((this.m_mostRecent.isVersionable() ? 0 : 1) != this.m_versionableComboBox.getSelectedIndex()) {
            this.m_versionableComboBox.setSelectedIndex(this.m_mostRecent.isVersionable() ? 0 : 1);
        }
        this.m_owner.colorTabForState(this.m_mostRecent.getID(), this.m_mostRecent.getState());
        this.m_currentVersionPane.undoChanges();
    }

    protected String getFedoraURL(Datastream ds, boolean withDate) {
        StringBuffer buf = new StringBuffer();
        buf.append(Administrator.getProtocol() + "://");
        buf.append(Administrator.getHost());
        if (Administrator.getPort() != 80) {
            buf.append(':');
            buf.append(Administrator.getPort());
        }
        buf.append("/fedora/get/");
        buf.append(this.m_pid);
        buf.append('/');
        buf.append(ds.getID());
        if (withDate) {
            buf.append('/');
            buf.append(ds.getCreateDate());
        }
        return buf.toString();
    }

    public String getCustomMimeType(Datastream ds) {
        String dsMimetype = ds.getMIMEType();
        if (ds.getID().equals("RELS-EXT")) {
            dsMimetype = "application/rdf+xml";
        }
        return dsMimetype;
    }

    public InputStream getDatastreamContent(String pid, String id, String createDate) throws IOException {
        return Administrator.DOWNLOADER.getDatastreamContent(pid, id, createDate);
    }

    public class ExportActionListener
    implements ActionListener {
        Datastream m_ds;

        public ExportActionListener(Datastream ds) {
            this.m_ds = ds;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                FileDialog dlg = new FileDialog((Frame)Administrator.INSTANCE, "Export Datastream Content to...", 1);
                if (Administrator.getLastDir() != null) {
                    dlg.setDirectory(Administrator.getLastDir().getPath());
                }
                dlg.setVisible(true);
                if (dlg.getFile() != null) {
                    File file = new File(new File(dlg.getDirectory()), dlg.getFile());
                    LOG.debug((Object)("Exporting to " + file.getPath()));
                    Administrator.setLastDir(file.getParentFile());
                    Administrator.DOWNLOADER.getDatastreamContent(DatastreamPane.this.m_pid, this.m_ds.getID(), this.m_ds.getCreateDate(), new FileOutputStream(file));
                }
            }
            catch (Exception e) {
                Administrator.showErrorDialog(Administrator.getDesktop(), "Content Export Failure", e.getMessage(), e);
            }
        }
    }

    public class PurgeDataStreamDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        Object startDate;
        Object endDate;
        boolean canceled;
        private final JList list;

        public PurgeDataStreamDialog(JFrame parent, String datastreamName, String defaultVal, Object[] dateStrings) {
            super(parent, "Purge Datastream", true);
            JLabel label = new JLabel("Choose versions of datastream " + datastreamName + " to purge:");
            this.getContentPane().add((Component)label, "North");
            label.setBorder(new EmptyBorder(10, 10, 0, 10));
            this.list = new JList<Object>(dateStrings);
            this.list.setSelectionMode(1);
            JScrollPane scroll = new JScrollPane(this.list);
            scroll.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new LineBorder(Color.BLACK)));
            this.getContentPane().add((Component)scroll, "Center");
            for (int i = 0; i < dateStrings.length; ++i) {
                if (!dateStrings[i].toString().equals(defaultVal)) continue;
                this.list.setSelectionInterval(i, i);
            }
            JPanel buttons = new JPanel();
            this.getContentPane().add((Component)buttons, "South");
            JButton purge = new JButton("Purge");
            purge.addActionListener(this);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(this);
            buttons.add(purge);
            buttons.add(cancel);
            this.list.setSize(500, 600);
            this.pack();
            this.setLocation(Administrator.getInstance().getCenteredPos(this.getWidth(), this.getHeight()));
            this.canceled = true;
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Purge") {
                this.canceled = false;
                Object[] sel = this.list.getSelectedValues();
                this.startDate = sel[0];
                this.endDate = sel[sel.length - 1];
                this.setVisible(false);
            }
            if (e.getActionCommand() == "Cancel") {
                this.canceled = true;
                this.setVisible(false);
            }
        }

        public Object getEndDate() {
            return this.endDate;
        }

        public Object getStartDate() {
            return this.startDate;
        }

        public boolean isCanceled() {
            return this.canceled;
        }
    }

    protected class PurgeButtonListener
    implements ActionListener {
        Datastream[] m_versions;
        Object[] m_dateStrings;
        HashMap m_dsIndex;

        public PurgeButtonListener(Datastream[] versions) {
            this.m_versions = versions;
            this.m_dateStrings = new Object[versions.length];
            this.m_dsIndex = new HashMap();
            for (int i = 0; i < versions.length; ++i) {
                this.m_dateStrings[i] = versions[i].getCreateDate();
                this.m_dsIndex.put(versions[i].getCreateDate(), new Integer(i));
            }
        }

        public void actionPerformed(ActionEvent evt) {
            int sIndex1 = 0;
            int sIndex2 = 0;
            boolean canceled = false;
            if (this.m_versions.length > 1) {
                String defaultValue = evt.getActionCommand();
                PurgeDataStreamDialog purgeDialog = new PurgeDataStreamDialog(Administrator.getInstance(), this.m_versions[0].getID(), defaultValue, this.m_dateStrings);
                if (purgeDialog.isCanceled()) {
                    canceled = true;
                } else {
                    sIndex1 = (Integer)this.m_dsIndex.get(purgeDialog.getStartDate());
                    sIndex2 = (Integer)this.m_dsIndex.get(purgeDialog.getEndDate());
                }
            }
            if (!canceled) {
                String detail;
                boolean removeAll = false;
                if (sIndex1 == 0 && sIndex2 == this.m_dsIndex.size() - 1) {
                    detail = "the entire datastream.";
                    removeAll = true;
                } else if (sIndex1 == sIndex2) {
                    detail = "one version of the datastream.";
                } else {
                    int num = sIndex2 - sIndex1 + 1;
                    detail = "" + num + " versions of the datastream.";
                }
                int n = JOptionPane.showOptionDialog(Administrator.getDesktop(), "This will permanently remove " + detail + "\n" + "Are you sure you want to do this?", "Confirmation", 0, 2, null, new Object[]{"Yes", "No"}, "Yes");
                if (n == 0) {
                    try {
                        Administrator.APIM.purgeDatastream(DatastreamPane.this.m_pid, this.m_versions[sIndex1].getID(), this.m_versions[sIndex2].getCreateDate(), this.m_versions[sIndex1].getCreateDate(), "DatastreamPane generated this logMessage.", false);
                        if (removeAll) {
                            DatastreamPane.this.m_owner.remove(this.m_versions[0].getID());
                            DatastreamPane.this.m_done = true;
                        } else {
                            DatastreamPane.this.m_owner.refresh(this.m_versions[0].getID());
                            DatastreamPane.this.m_done = true;
                        }
                    }
                    catch (Exception e) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Purge error", e.getMessage(), e);
                    }
                }
            }
        }
    }

    public class PriorVersionPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private boolean X;
        private boolean M;
        private boolean E;
        private boolean R;
        private ContentViewer v;
        private final Datastream m_ds;
        private String m_priorLabel;
        private String m_priorMIME;
        private String m_priorFormatURI;
        private String m_priorAltIDs;
        private JButton m_viewButton;
        private JButton m_viewTextButton;

        public PriorVersionPane(Datastream ds) {
            JComponent[] values;
            JLabel[] labels;
            this.m_ds = ds;
            this.m_priorLabel = this.m_ds.getLabel();
            if (this.m_priorLabel == null) {
                this.m_priorLabel = "";
            }
            this.m_priorMIME = this.m_ds.getMIMEType();
            if (this.m_priorMIME == null) {
                this.m_priorMIME = "";
            }
            this.m_priorFormatURI = this.m_ds.getFormatURI();
            if (this.m_priorFormatURI == null) {
                this.m_priorFormatURI = "";
            }
            this.m_priorAltIDs = "";
            String[] altIDs = this.m_ds.getAltIDs();
            if (altIDs != null) {
                for (int z = 0; z < altIDs.length; ++z) {
                    if (z > 0) {
                        this.m_priorAltIDs = this.m_priorAltIDs + " ";
                    }
                    this.m_priorAltIDs = this.m_priorAltIDs + altIDs[z];
                }
            }
            if (ds.getControlGroup().toString().equals("X")) {
                this.X = true;
            } else if (ds.getControlGroup().toString().equals("M")) {
                this.M = true;
            } else if (ds.getControlGroup().toString().equals("E")) {
                this.E = true;
            } else if (ds.getControlGroup().toString().equals("R")) {
                this.R = true;
            }
            this.setLayout(new BorderLayout());
            JLabel labelLabel = new JLabel("Label");
            labelLabel.setMinimumSize(DatastreamPane.this.m_labelDims);
            JTextField labelValue = new JTextField();
            labelValue.setText(this.m_priorLabel);
            labelValue.setEditable(false);
            JLabel MIMELabel = new JLabel("MIME Type");
            MIMELabel.setMinimumSize(DatastreamPane.this.m_labelDims);
            JTextField MIMEValue = new JTextField();
            MIMEValue.setText(this.m_priorMIME);
            MIMEValue.setEditable(false);
            JLabel formatURILabel = new JLabel("Format URI");
            formatURILabel.setMinimumSize(DatastreamPane.this.m_labelDims);
            JTextField formatURIValue = new JTextField();
            formatURIValue.setText(this.m_priorFormatURI);
            formatURIValue.setEditable(false);
            JLabel altIDsLabel = new JLabel("Alternate IDs");
            altIDsLabel.setMinimumSize(DatastreamPane.this.m_labelDims);
            JTextField altIDsValue = new JTextField();
            altIDsValue.setText(this.m_priorAltIDs);
            altIDsValue.setEditable(false);
            JLabel urlLabel = new JLabel("Fedora URL");
            urlLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JTextField urlTextField = new JTextField(DatastreamPane.this.getFedoraURL(this.m_ds, true));
            urlTextField.setEditable(false);
            JLabel checksumLabel = new JLabel("Checksum");
            checksumLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JTextField checksumTextField = new JTextField(DatastreamPane.getFormattedChecksumTypeAndChecksum(this.m_ds));
            checksumTextField.setEditable(false);
            if (this.E || this.R) {
                labels = new JLabel[]{labelLabel, MIMELabel, formatURILabel, altIDsLabel, new JLabel("Location"), urlLabel, checksumLabel};
                JTextField refValue = new JTextField();
                refValue.setText(ds.getLocation());
                refValue.setEditable(false);
                values = new JComponent[]{labelValue, MIMEValue, formatURIValue, altIDsValue, refValue, urlTextField, checksumTextField};
            } else {
                labels = new JLabel[]{labelLabel, MIMELabel, formatURILabel, altIDsLabel, urlLabel, checksumLabel};
                values = new JComponent[]{labelValue, MIMEValue, formatURIValue, altIDsValue, urlTextField, checksumTextField};
            }
            JPanel fieldPanel = new JPanel();
            GridBagLayout fieldGrid = new GridBagLayout();
            fieldPanel.setLayout(fieldGrid);
            DatastreamPane.this.addLabelValueRows(labels, values, fieldGrid, fieldPanel);
            this.add((Component)fieldPanel, "North");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            if (ds.getMIMEType() != DatastreamPane.this.getCustomMimeType(ds)) {
                if (ContentHandlerFactory.hasViewer(ds.getMIMEType())) {
                    this.m_viewButton = new JButton("View");
                    Administrator.constrainHeight(this.m_viewButton);
                    this.m_viewButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            JButton btn = (JButton)evt.getSource();
                            try {
                                ContentViewer v = ContentHandlerFactory.getViewer(DatastreamPane.this.getCustomMimeType(PriorVersionPane.this.m_ds), Administrator.DOWNLOADER.getDatastreamContent(DatastreamPane.this.m_pid, PriorVersionPane.this.m_ds.getID(), PriorVersionPane.this.m_ds.getCreateDate()));
                                PriorVersionPane.this.add((Component)v.getComponent(), "Center");
                                btn.setEnabled(false);
                                PriorVersionPane.this.m_viewTextButton.setEnabled(true);
                                PriorVersionPane.this.validate();
                            }
                            catch (Exception e) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Content View Failure", e.getMessage(), e);
                            }
                        }
                    });
                    buttonPanel.add(this.m_viewButton);
                    this.m_viewTextButton = new JButton("View as Text");
                    Administrator.constrainHeight(this.m_viewTextButton);
                    this.m_viewTextButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            JButton btn = (JButton)evt.getSource();
                            try {
                                ContentViewer v = ContentHandlerFactory.getViewer(PriorVersionPane.this.m_ds.getMIMEType(), Administrator.DOWNLOADER.getDatastreamContent(DatastreamPane.this.m_pid, PriorVersionPane.this.m_ds.getID(), PriorVersionPane.this.m_ds.getCreateDate()));
                                PriorVersionPane.this.add((Component)v.getComponent(), "Center");
                                btn.setEnabled(false);
                                PriorVersionPane.this.m_viewButton.setEnabled(true);
                                PriorVersionPane.this.validate();
                            }
                            catch (Exception e) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Content View Failure", e.getMessage(), e);
                            }
                        }
                    });
                    buttonPanel.add(this.m_viewTextButton);
                }
            } else if (ContentHandlerFactory.hasViewer(ds.getMIMEType())) {
                this.m_viewButton = new JButton("View");
                Administrator.constrainHeight(this.m_viewButton);
                this.m_viewButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        JButton btn = (JButton)evt.getSource();
                        try {
                            ContentViewer v = ContentHandlerFactory.getViewer(DatastreamPane.this.getCustomMimeType(PriorVersionPane.this.m_ds), Administrator.DOWNLOADER.getDatastreamContent(DatastreamPane.this.m_pid, PriorVersionPane.this.m_ds.getID(), PriorVersionPane.this.m_ds.getCreateDate()));
                            PriorVersionPane.this.add((Component)v.getComponent(), "Center");
                            btn.setEnabled(false);
                            PriorVersionPane.this.validate();
                        }
                        catch (Exception e) {
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Content View Failure", e.getMessage(), e);
                        }
                    }
                });
                buttonPanel.add(this.m_viewButton);
            }
            JButton exportButton = new JButton("Export...");
            Administrator.constrainHeight(exportButton);
            exportButton.addActionListener(new ExportActionListener(this.m_ds));
            buttonPanel.add(exportButton);
            JButton purgeButton = new JButton("Purge...");
            Administrator.constrainHeight(purgeButton);
            purgeButton.addActionListener(DatastreamPane.this.m_purgeButtonListener);
            purgeButton.setActionCommand(this.m_ds.getCreateDate());
            buttonPanel.add(purgeButton);
            this.add((Component)buttonPanel, "South");
        }

        public Datastream getDatastream() {
            return this.m_ds;
        }
    }

    public class CurrentVersionPane
    extends JPanel
    implements PotentiallyDirty {
        private static final long serialVersionUID = 1L;
        protected Datastream m_ds;
        private JTextField m_locationTextField;
        protected JTextField m_labelTextField;
        private String m_origLabel;
        protected JTextField m_MIMETextField;
        private String m_origMIME;
        protected JTextField m_formatURITextField;
        private String m_origFormatURI;
        protected JTextField m_altIDsTextField;
        private final String m_origAltIDs;
        protected JButton m_editButton;
        private JButton m_viewButton;
        protected JButton m_editCustomButton;
        private JButton m_viewCustomButton;
        private final JButton m_importButton;
        protected JButton m_exportButton;
        private JButton m_separateViewButton;
        protected JComboBox m_checksumTypeComboBox;
        protected JTextField m_checksumTextField;
        private final JPanel m_checksumPanel;
        protected ContentEditor m_editor;
        private ContentViewer m_viewer;
        private boolean m_canEdit;
        private boolean m_hasCustomEditor;
        private final boolean m_canView;
        private File m_importFile;
        private JLabel m_importLabel;
        protected JPanel m_actionPane;
        protected JButton m_purgeButton;
        private boolean X;
        private boolean M;
        private boolean E;
        private boolean R;

        public CurrentVersionPane(Datastream ds) {
            JTextArea cDateTextArea;
            JComponent[] values;
            JLabel[] labels;
            this.m_ds = ds;
            this.m_origLabel = this.m_ds.getLabel();
            if (this.m_origLabel == null) {
                this.m_origLabel = "";
            }
            this.m_origMIME = this.m_ds.getMIMEType();
            if (this.m_origMIME == null) {
                this.m_origMIME = "";
            }
            this.m_origFormatURI = this.m_ds.getFormatURI();
            if (this.m_origFormatURI == null) {
                this.m_origFormatURI = "";
            }
            this.m_origAltIDs = this.getAltIdsString();
            if (ds.getControlGroup().toString().equals("X")) {
                this.X = true;
            } else if (ds.getControlGroup().toString().equals("M")) {
                this.M = true;
            } else if (ds.getControlGroup().toString().equals("E")) {
                this.E = true;
            } else if (ds.getControlGroup().toString().equals("R")) {
                this.R = true;
            }
            boolean noEdits = ds.getState().equals("D");
            String dsMimetype = DatastreamPane.this.getCustomMimeType(this.m_ds);
            if ((this.X || this.M) && !noEdits) {
                this.m_canEdit = ContentHandlerFactory.hasEditor(dsMimetype);
            }
            if (!dsMimetype.equals(this.m_ds.getMIMEType())) {
                this.m_hasCustomEditor = true;
            }
            this.m_canView = ContentHandlerFactory.hasViewer(dsMimetype);
            if (this.m_hasCustomEditor) {
                this.m_editCustomButton = new JButton("Edit");
                Administrator.constrainHeight(this.m_editCustomButton);
                this.m_viewCustomButton = new JButton("View");
                Administrator.constrainHeight(this.m_viewCustomButton);
                this.m_editButton = new JButton("Edit as Text");
                Administrator.constrainHeight(this.m_editButton);
                this.m_viewButton = new JButton("View as Text");
                Administrator.constrainHeight(this.m_viewButton);
            } else {
                this.m_editButton = new JButton("Edit");
                Administrator.constrainHeight(this.m_editButton);
                this.m_viewButton = new JButton("View");
                Administrator.constrainHeight(this.m_viewButton);
                this.m_editCustomButton = new JButton("Unused Edit");
                Administrator.constrainHeight(this.m_editCustomButton);
                this.m_viewCustomButton = new JButton("Unused View");
                Administrator.constrainHeight(this.m_viewCustomButton);
            }
            this.m_importButton = new JButton("Import...");
            Administrator.constrainHeight(this.m_importButton);
            this.m_exportButton = new JButton("Export...");
            Administrator.constrainHeight(this.m_exportButton);
            this.setLayout(new BorderLayout());
            JLabel labelLabel = new JLabel("Label");
            labelLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JLabel MIMELabel = new JLabel("MIME Type");
            MIMELabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JLabel formatURILabel = new JLabel("Format URI");
            formatURILabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JLabel altIDsLabel = new JLabel("Alternate IDs");
            altIDsLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JLabel urlLabel = new JLabel("Fedora URL");
            urlLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            JLabel checksumLabel = new JLabel("Checksum");
            checksumLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
            if (this.R || this.E) {
                JLabel locationLabel = new JLabel("Location");
                locationLabel.setPreferredSize(DatastreamPane.this.m_labelDims);
                labels = DatastreamPane.this.m_versionSlider != null ? new JLabel[]{labelLabel, MIMELabel, formatURILabel, altIDsLabel, locationLabel, urlLabel, checksumLabel} : new JLabel[]{new JLabel("Created"), labelLabel, MIMELabel, formatURILabel, altIDsLabel, locationLabel, urlLabel, checksumLabel};
            } else {
                labels = DatastreamPane.this.m_versionSlider != null ? new JLabel[]{labelLabel, MIMELabel, formatURILabel, altIDsLabel, urlLabel, checksumLabel} : (this.m_ds.getCreateDate() == null ? new JLabel[]{labelLabel, MIMELabel, formatURILabel, altIDsLabel, checksumLabel} : new JLabel[]{new JLabel("Created"), labelLabel, MIMELabel, formatURILabel, altIDsLabel, urlLabel, checksumLabel});
            }
            this.m_labelTextField = new JTextField(this.m_origLabel);
            this.m_labelTextField.getDocument().addDocumentListener(DatastreamPane.this.dataChangeListener);
            this.m_MIMETextField = new JTextField(this.m_origMIME);
            this.m_MIMETextField.getDocument().addDocumentListener(DatastreamPane.this.dataChangeListener);
            this.m_formatURITextField = new JTextField(this.m_origFormatURI);
            this.m_formatURITextField.getDocument().addDocumentListener(DatastreamPane.this.dataChangeListener);
            this.m_altIDsTextField = new JTextField(this.m_origAltIDs);
            this.m_altIDsTextField.getDocument().addDocumentListener(DatastreamPane.this.dataChangeListener);
            if (noEdits) {
                this.m_labelTextField.setEnabled(false);
                this.m_MIMETextField.setEnabled(false);
                this.m_formatURITextField.setEnabled(false);
                this.m_altIDsTextField.setEnabled(false);
            }
            JTextField urlTextField = new JTextField(DatastreamPane.this.getFedoraURL(this.m_ds, false));
            urlTextField.setEditable(false);
            this.m_checksumTypeComboBox = new JComboBox<String>(new String[]{"DISABLED", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"});
            this.setSelectedChecksumType(this.m_checksumTypeComboBox, ds.getChecksumType());
            this.m_checksumTextField = new JTextField(this.m_ds.getChecksum());
            this.m_checksumTextField.setEditable(false);
            this.m_checksumPanel = new JPanel();
            this.m_checksumPanel.setLayout(new BorderLayout());
            this.m_checksumPanel.add((Component)this.m_checksumTypeComboBox, "West");
            this.m_checksumPanel.add((Component)this.m_checksumTextField, "Center");
            this.m_checksumTypeComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String csType = CurrentVersionPane.this.m_checksumTypeComboBox.getSelectedItem().toString();
                    DatastreamPane.this.dataChangeListener.dataChanged();
                    if (csType.equals("DISABLED") || !csType.equals(CurrentVersionPane.this.m_ds.getChecksumType())) {
                        if (CurrentVersionPane.this.m_checksumTextField != null) {
                            CurrentVersionPane.this.m_checksumPanel.remove(CurrentVersionPane.this.m_checksumTextField);
                            CurrentVersionPane.this.m_checksumTextField = null;
                            CurrentVersionPane.this.m_checksumPanel.validate();
                            CurrentVersionPane.this.m_checksumPanel.repaint();
                        }
                    } else {
                        if (CurrentVersionPane.this.m_checksumTextField != null) {
                            CurrentVersionPane.this.m_checksumPanel.remove(CurrentVersionPane.this.m_checksumTextField);
                        }
                        CurrentVersionPane.this.m_checksumTextField = new JTextField(CurrentVersionPane.this.m_ds.getChecksum());
                        CurrentVersionPane.this.m_checksumTextField.setEditable(false);
                        CurrentVersionPane.this.m_checksumPanel.add((Component)CurrentVersionPane.this.m_checksumTextField, "Center");
                        CurrentVersionPane.this.m_checksumPanel.validate();
                        CurrentVersionPane.this.m_checksumPanel.repaint();
                    }
                }
            });
            if (this.R || this.E) {
                this.m_locationTextField = new JTextField(this.m_ds.getLocation());
                this.m_locationTextField.getDocument().addDocumentListener(DatastreamPane.this.dataChangeListener);
                if (noEdits) {
                    this.m_locationTextField.setEnabled(false);
                }
                if (DatastreamPane.this.m_versionSlider != null) {
                    values = new JComponent[]{this.m_labelTextField, this.m_MIMETextField, this.m_formatURITextField, this.m_altIDsTextField, this.m_locationTextField, urlTextField, this.m_checksumPanel};
                } else {
                    cDateTextArea = new JTextArea(this.m_ds.getCreateDate());
                    cDateTextArea.setBackground(Administrator.BACKGROUND_COLOR);
                    cDateTextArea.setEditable(false);
                    values = new JComponent[]{cDateTextArea, this.m_labelTextField, this.m_MIMETextField, this.m_formatURITextField, this.m_altIDsTextField, this.m_locationTextField, urlTextField, this.m_checksumPanel};
                }
            } else if (DatastreamPane.this.m_versionSlider != null) {
                values = new JComponent[]{this.m_labelTextField, this.m_MIMETextField, this.m_formatURITextField, this.m_altIDsTextField, urlTextField, this.m_checksumPanel};
            } else if (this.m_ds.getCreateDate() == null) {
                values = new JComponent[]{this.m_labelTextField, this.m_MIMETextField, this.m_formatURITextField, this.m_altIDsTextField, this.m_checksumPanel};
            } else {
                cDateTextArea = new JTextArea(this.m_ds.getCreateDate());
                cDateTextArea.setBackground(Administrator.BACKGROUND_COLOR);
                cDateTextArea.setEditable(false);
                values = new JComponent[]{cDateTextArea, this.m_labelTextField, this.m_MIMETextField, this.m_formatURITextField, this.m_altIDsTextField, urlTextField, this.m_checksumPanel};
            }
            JPanel fieldPane = new JPanel();
            GridBagLayout grid = new GridBagLayout();
            fieldPane.setLayout(grid);
            DatastreamPane.this.addLabelValueRows(labels, values, grid, fieldPane);
            this.add((Component)fieldPane, "North");
            this.m_actionPane = new JPanel();
            this.m_actionPane.setLayout(new FlowLayout());
            if (this.m_canEdit) {
                if (this.m_hasCustomEditor) {
                    this.m_editCustomButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            try {
                                CurrentVersionPane.this.startCustomEditor();
                            }
                            catch (Exception e) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Content Edit Error", e.getMessage(), e);
                            }
                        }
                    });
                    this.m_actionPane.add(this.m_editCustomButton);
                }
                this.m_editButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            CurrentVersionPane.this.startEditor();
                        }
                        catch (Exception e) {
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Content Edit Error", e.getMessage(), e);
                        }
                    }
                });
                this.m_actionPane.add(this.m_editButton);
                if (!ContentHandlerFactory.viewerIsEditor(dsMimetype)) {
                    this.m_separateViewButton = new JButton("View");
                    Administrator.constrainHeight(this.m_separateViewButton);
                    this.m_separateViewButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            try {
                                CurrentVersionPane.this.startSeparateViewer();
                            }
                            catch (Exception e) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Content View Error", e.getMessage(), e);
                            }
                        }
                    });
                    this.m_actionPane.add(this.m_separateViewButton);
                }
            } else if (this.m_canView) {
                if (this.m_hasCustomEditor) {
                    this.m_viewCustomButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent evt) {
                            try {
                                CurrentVersionPane.this.startCustomViewer();
                            }
                            catch (Exception e) {
                                Administrator.showErrorDialog(Administrator.getDesktop(), "Content Edit Error", e.getMessage(), e);
                            }
                        }
                    });
                    this.m_actionPane.add(this.m_viewCustomButton);
                }
                this.m_viewButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        try {
                            CurrentVersionPane.this.startViewer();
                        }
                        catch (Exception e) {
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Content View Error", e.getMessage(), e);
                        }
                    }
                });
                this.m_actionPane.add(this.m_viewButton);
            }
            if ((this.X || this.M) && !noEdits) {
                this.m_actionPane.add(this.m_importButton);
                this.m_importButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        boolean startedEditor = false;
                        boolean startedViewer = false;
                        try {
                            ImportDialog imp = new ImportDialog();
                            if (imp.file != null) {
                                File file = imp.file;
                                String url = imp.url;
                                Administrator.setLastDir(file.getParentFile());
                                if (CurrentVersionPane.this.m_canEdit) {
                                    if (CurrentVersionPane.this.m_editor == null) {
                                        if (CurrentVersionPane.this.m_hasCustomEditor) {
                                            CurrentVersionPane.this.startCustomEditor();
                                        } else {
                                            CurrentVersionPane.this.startEditor();
                                        }
                                        startedEditor = true;
                                    }
                                    CurrentVersionPane.this.m_editor.setContent(new FileInputStream(file));
                                    CurrentVersionPane.this.m_importFile = file;
                                    DatastreamPane.this.dataChangeListener.dataChanged();
                                } else if (CurrentVersionPane.this.m_canView) {
                                    if (CurrentVersionPane.this.m_viewer == null) {
                                        if (CurrentVersionPane.this.m_hasCustomEditor) {
                                            CurrentVersionPane.this.startCustomViewer();
                                        } else {
                                            CurrentVersionPane.this.startViewer();
                                        }
                                        startedViewer = true;
                                    }
                                    CurrentVersionPane.this.m_viewer.setContent(new FileInputStream(file));
                                    CurrentVersionPane.this.m_importFile = file;
                                    DatastreamPane.this.dataChangeListener.dataChanged();
                                } else {
                                    if (url != null) {
                                        CurrentVersionPane.this.m_importLabel = new JLabel("Will import " + url);
                                    } else {
                                        CurrentVersionPane.this.m_importLabel = new JLabel("Will import " + file.getPath());
                                    }
                                    CurrentVersionPane.this.add((Component)CurrentVersionPane.this.m_importLabel, "Center");
                                    CurrentVersionPane.this.validate();
                                    CurrentVersionPane.this.m_importFile = file;
                                    DatastreamPane.this.dataChangeListener.dataChanged();
                                }
                            }
                        }
                        catch (Exception e) {
                            if (startedEditor) {
                                CurrentVersionPane.this.m_editButton.setEnabled(true);
                                CurrentVersionPane.this.remove(CurrentVersionPane.this.m_editor.getComponent());
                                CurrentVersionPane.this.m_editor = null;
                            }
                            if (startedViewer) {
                                CurrentVersionPane.this.m_viewButton.setEnabled(true);
                                CurrentVersionPane.this.remove(CurrentVersionPane.this.m_viewer.getComponent());
                                CurrentVersionPane.this.m_viewer = null;
                            }
                            Administrator.showErrorDialog(Administrator.getDesktop(), "Content Import Failure", e.getMessage(), e);
                        }
                    }
                });
            }
            this.m_actionPane.add(this.m_exportButton);
            this.m_exportButton.addActionListener(new ExportActionListener(this.m_ds));
            this.m_purgeButton = new JButton("Purge...");
            Administrator.constrainHeight(this.m_purgeButton);
            this.m_purgeButton.addActionListener(DatastreamPane.this.m_purgeButtonListener);
            this.m_purgeButton.setActionCommand(this.m_ds.getCreateDate());
            this.m_actionPane.add(this.m_purgeButton);
            this.add((Component)this.m_actionPane, "South");
        }

        private String getAltIdsString() {
            String altIDStr = "";
            String[] altIDs = this.m_ds.getAltIDs();
            if (altIDs != null) {
                for (int z = 0; z < altIDs.length; ++z) {
                    if (z > 0) {
                        altIDStr = altIDStr + " ";
                    }
                    altIDStr = altIDStr + altIDs[z];
                }
            }
            return altIDStr;
        }

        private void setSelectedChecksumType(JComboBox typeComboBox, String checksumType) {
            for (int i = 0; i < typeComboBox.getItemCount(); ++i) {
                if (!typeComboBox.getItemAt(i).toString().equals(checksumType)) continue;
                typeComboBox.setSelectedIndex(i);
                break;
            }
        }

        public Datastream getDatastream() {
            return this.m_ds;
        }

        private void startEditor() throws Exception {
            InputStream curContent = null;
            if (this.m_editor != null) {
                if (this.m_editor.isDirty()) {
                    curContent = this.m_editor.getContent();
                }
                this.remove(this.m_editor.getComponent());
                this.m_editor = null;
            }
            InputStream origContent = DatastreamPane.this.getDatastreamContent(DatastreamPane.this.m_pid, this.m_ds.getID(), this.m_ds.getCreateDate());
            this.m_editor = ContentHandlerFactory.getEditor(this.m_ds.getMIMEType(), origContent);
            this.m_editor.setContentChangeListener(DatastreamPane.this.dataChangeListener);
            if (curContent != null) {
                this.m_editor.setContent(curContent);
            }
            this.m_editor.setPIDAndDSID(DatastreamPane.this.m_pid, this.m_ds.getID());
            this.add((Component)this.m_editor.getComponent(), "Center");
            this.m_editButton.setEnabled(false);
            this.m_editCustomButton.setEnabled(true);
            this.validate();
        }

        public void startViewer() throws Exception {
            if (this.m_viewer != null) {
                this.remove(this.m_viewer.getComponent());
                this.m_viewer = null;
            }
            this.m_viewer = ContentHandlerFactory.getViewer(this.m_ds.getMIMEType(), DatastreamPane.this.getDatastreamContent(DatastreamPane.this.m_pid, this.m_ds.getID(), this.m_ds.getCreateDate()));
            this.add((Component)this.m_viewer.getComponent(), "Center");
            this.m_viewButton.setEnabled(false);
            this.m_viewCustomButton.setEnabled(true);
            this.validate();
        }

        private void startCustomEditor() throws Exception {
            InputStream curContent = null;
            if (this.m_editor != null) {
                if (this.m_editor.isDirty()) {
                    curContent = this.m_editor.getContent();
                }
                this.remove(this.m_editor.getComponent());
                this.m_editor = null;
            }
            InputStream origContent = DatastreamPane.this.getDatastreamContent(DatastreamPane.this.m_pid, this.m_ds.getID(), this.m_ds.getCreateDate());
            this.m_editor = ContentHandlerFactory.getEditor(DatastreamPane.this.getCustomMimeType(this.m_ds), origContent);
            this.m_editor.setContentChangeListener(DatastreamPane.this.dataChangeListener);
            if (curContent != null) {
                this.m_editor.setContent(curContent);
            }
            this.m_editor.setPIDAndDSID(DatastreamPane.this.m_pid, this.m_ds.getID());
            this.add((Component)this.m_editor.getComponent(), "Center");
            this.m_editCustomButton.setEnabled(false);
            this.m_editButton.setEnabled(true);
            this.validate();
        }

        public void startCustomViewer() throws Exception {
            if (this.m_viewer != null) {
                this.remove(this.m_viewer.getComponent());
                this.m_viewer = null;
            }
            this.m_viewer = ContentHandlerFactory.getViewer(DatastreamPane.this.getCustomMimeType(this.m_ds), DatastreamPane.this.getDatastreamContent(DatastreamPane.this.m_pid, this.m_ds.getID(), this.m_ds.getCreateDate()));
            this.add((Component)this.m_viewer.getComponent(), "Center");
            this.m_viewCustomButton.setEnabled(false);
            this.m_viewButton.setEnabled(true);
            this.validate();
        }

        public void startSeparateViewer() throws Exception {
            InputStream contentStream = this.m_separateViewButton.getText().equals("Preview") ? this.m_editor.getContent() : DatastreamPane.this.getDatastreamContent(DatastreamPane.this.m_pid, this.m_ds.getID(), this.m_ds.getCreateDate());
            ContentViewer separateViewer = ContentHandlerFactory.getViewer(DatastreamPane.this.getCustomMimeType(this.m_ds), contentStream);
            JInternalFrame viewFrame = new JInternalFrame(this.m_separateViewButton.getText() + "ing " + this.m_ds.getID() + " datastream from object " + DatastreamPane.this.m_pid, true, true, true, true);
            JPanel myPanel = new JPanel();
            myPanel.setLayout(new BorderLayout());
            myPanel.add((Component)separateViewer.getComponent(), "Center");
            viewFrame.getContentPane().add(myPanel);
            viewFrame.setSize(720, 520);
            Administrator.getDesktop().add(viewFrame);
            viewFrame.setVisible(true);
            viewFrame.toFront();
        }

        public void saveChanges(String logMessage, boolean force) throws Exception {
            String label = this.m_labelTextField.getText().trim();
            String mimeType = this.m_MIMETextField.getText().trim();
            String formatURI = this.m_formatURITextField.getText().trim();
            String[] altIDs = this.m_altIDsTextField.getText().trim().split(" ");
            String checksumType = this.m_checksumTypeComboBox.getSelectedItem().toString();
            if (checksumType.equals(this.m_ds.getChecksumType())) {
                checksumType = null;
            }
            if (this.X) {
                byte[] content = new byte[]{};
                if (this.m_editor != null && this.m_editor.isDirty()) {
                    InputStream in = this.m_editor.getContent();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    StreamUtility.pipeStream(in, out, 4096);
                    content = out.toByteArray();
                }
                Administrator.APIM.modifyDatastreamByValue(DatastreamPane.this.m_pid, this.m_ds.getID(), altIDs, label, mimeType, formatURI, content, checksumType, null, logMessage, force);
            } else if (this.M) {
                String loc = null;
                if (this.m_importFile != null) {
                    loc = Administrator.UPLOADER.upload(this.m_importFile);
                } else if (this.m_editor != null && this.m_editor.isDirty()) {
                    loc = Administrator.UPLOADER.upload(this.m_editor.getContent());
                }
                Administrator.APIM.modifyDatastreamByReference(DatastreamPane.this.m_pid, this.m_ds.getID(), altIDs, label, mimeType, formatURI, loc, checksumType, null, logMessage, force);
            } else {
                Administrator.APIM.modifyDatastreamByReference(DatastreamPane.this.m_pid, this.m_ds.getID(), altIDs, label, mimeType, formatURI, this.m_locationTextField.getText(), checksumType, null, logMessage, force);
            }
        }

        public boolean isDirty() {
            if (this.m_editor != null) {
                if (this.m_editor.isDirty()) {
                    if (this.m_separateViewButton != null && this.m_separateViewButton.getText().equals("View")) {
                        this.m_separateViewButton.setText("Preview");
                    }
                    return true;
                }
                if (this.m_separateViewButton != null && this.m_separateViewButton.getText().equals("Preview")) {
                    this.m_separateViewButton.setText("View");
                }
            }
            if (!this.m_ds.getLabel().equals(this.m_labelTextField.getText())) {
                return true;
            }
            if (!this.m_origMIME.equals(this.m_MIMETextField.getText())) {
                return true;
            }
            if (!this.m_origFormatURI.equals(this.m_formatURITextField.getText())) {
                return true;
            }
            if (!this.m_origAltIDs.equals(this.m_altIDsTextField.getText())) {
                return true;
            }
            if (this.m_locationTextField != null && !this.m_locationTextField.getText().equals(this.m_ds.getLocation())) {
                return true;
            }
            if (!this.m_checksumTypeComboBox.getSelectedItem().toString().equals(this.m_ds.getChecksumType())) {
                return true;
            }
            return this.m_importFile != null;
        }

        public void undoChanges() {
            this.m_labelTextField.setText(this.m_origLabel);
            this.m_MIMETextField.setText(this.m_origMIME);
            this.m_formatURITextField.setText(this.m_origFormatURI);
            this.m_altIDsTextField.setText(this.m_origAltIDs);
            if (this.m_locationTextField != null) {
                this.m_locationTextField.setText(this.m_ds.getLocation());
            }
            if (this.m_editor != null) {
                this.m_editor.undoChanges();
            }
            this.setSelectedChecksumType(this.m_checksumTypeComboBox, this.m_ds.getChecksumType());
            if (this.m_importFile != null) {
                this.m_importFile = null;
                if (this.m_canView) {
                    this.m_viewButton.setEnabled(true);
                    this.remove(this.m_viewer.getComponent());
                    this.m_viewer = null;
                } else {
                    this.remove(this.m_importLabel);
                    this.m_importLabel = null;
                }
            }
        }
    }
}

