/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.ObjectEditorFrame;
import fedora.client.objecteditor.PotentiallyDirty;
import fedora.client.objecteditor.TabDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class EditingPane
extends JPanel
implements PotentiallyDirty {
    protected JButton m_saveButton;
    protected JButton m_undoButton;
    public DataChangeListener dataChangeListener;
    public JPanel mainPane;
    private final TabDrawer m_td;
    private final String m_itemId;
    private final ObjectEditorFrame m_owner;
    private boolean m_isValid;

    public EditingPane(ObjectEditorFrame owner, TabDrawer td, String itemId) throws Exception {
        this.m_owner = owner;
        this.m_td = td;
        this.m_itemId = itemId;
        this.m_isValid = true;
        this.dataChangeListener = new DataChangeListener(this);
        this.m_saveButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                String logMessage = JOptionPane.showInputDialog("Enter a log message.");
                if (logMessage != null) {
                    try {
                        EditingPane.this.saveChanges(logMessage);
                        EditingPane.this.changesSaved();
                    }
                    catch (Exception ex) {
                        String msg = ex.getMessage();
                        if (msg == null) {
                            msg = ex.getClass().getName();
                        }
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Save Error", msg, ex);
                    }
                    EditingPane.this.updateButtonVisibility();
                }
            }
        });
        this.m_saveButton.setText("Save Changes...");
        Administrator.constrainHeight(this.m_saveButton);
        this.m_saveButton.setEnabled(false);
        this.m_undoButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                EditingPane.this.undoChanges();
                EditingPane.this.updateButtonVisibility();
            }
        });
        this.m_undoButton.setText("Undo Changes");
        Administrator.constrainHeight(this.m_undoButton);
        this.m_undoButton.setEnabled(false);
        JPanel saveUndoPane = new JPanel();
        saveUndoPane.setLayout(new FlowLayout());
        saveUndoPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        saveUndoPane.add(this.m_saveButton);
        saveUndoPane.add(this.m_undoButton);
        this.mainPane = new JPanel();
        this.mainPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)this.mainPane, "Center");
        this.add((Component)saveUndoPane, "South");
    }

    public void updateButtonVisibility() {
        if (this.isDirty()) {
            if (this.m_isValid) {
                this.m_saveButton.setEnabled(true);
            }
            this.m_undoButton.setEnabled(true);
            if (this.m_td != null) {
                this.m_td.setDirty(this.m_itemId, true);
            }
            this.m_owner.indicateDirtiness();
        } else {
            this.m_saveButton.setEnabled(false);
            this.m_undoButton.setEnabled(false);
            if (this.m_td != null) {
                this.m_td.setDirty(this.m_itemId, false);
            }
            this.m_owner.indicateDirtiness();
        }
        if (!this.m_isValid) {
            this.m_saveButton.setEnabled(false);
        }
    }

    public void setValid(boolean isValid) {
        this.m_isValid = isValid;
    }

    public abstract void saveChanges(String var1) throws Exception;

    public abstract void changesSaved() throws Exception;

    public abstract void undoChanges();

    public void addLabelValueRows(JLabel[] labels, JComponent[] values, GridBagLayout gridBag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 4, 4, 4);
        for (int i = 0; i < labels.length; ++i) {
            c.anchor = 17;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridBag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            if (values[i] instanceof JComboBox || values[i] instanceof JButton) {
                c.anchor = 17;
            } else {
                c.anchor = 13;
                c.fill = 2;
            }
            c.weightx = 1.0;
            gridBag.setConstraints(values[i], c);
            container.add(values[i]);
        }
    }

    public class DataChangeListener
    implements ActionListener,
    DocumentListener {
        private final EditingPane m_editingPane;

        public DataChangeListener(EditingPane editingPane2) {
            this.m_editingPane = editingPane2;
        }

        public void actionPerformed(ActionEvent e) {
            this.dataChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            this.dataChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dataChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dataChanged();
        }

        public void dataChanged() {
            this.m_editingPane.updateButtonVisibility();
        }
    }
}

