/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.Util;
import fedora.client.objecteditor.types.MethodDefinition;
import fedora.client.objecteditor.types.ParameterDefinition;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class ServiceDescriptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Map<String, JPanel> m_loadedPanels;
    private final JComponent m_containerToValidate;

    public ServiceDescriptionPanel(String sDefPID, JComponent containerToValidate) throws IOException {
        this.m_containerToValidate = containerToValidate;
        this.setLayout(new BorderLayout());
        this.m_loadedPanels = new HashMap<String, JPanel>();
        if (sDefPID != null) {
            this.setSDef(sDefPID);
        }
    }

    public void setSDef(String sDefPID) throws IOException {
        this.removeAll();
        if (sDefPID != null) {
            JPanel lp = this.m_loadedPanels.get(sDefPID);
            if (lp == null) {
                lp = this.makePanel(sDefPID);
                this.m_loadedPanels.put(sDefPID, lp);
            }
            this.add((Component)lp, "Center");
        }
        if (this.m_containerToValidate != null) {
            this.m_containerToValidate.revalidate();
            this.m_containerToValidate.repaint(new Rectangle(this.m_containerToValidate.getSize()));
        }
    }

    private JPanel makePanel(String sDefPID) throws IOException {
        JTextArea supportsMethodsTextArea = new JTextArea("   defines method");
        supportsMethodsTextArea.setLineWrap(false);
        supportsMethodsTextArea.setEditable(false);
        supportsMethodsTextArea.setBackground(Administrator.BACKGROUND_COLOR);
        JTextArea methodParametersTextArea = new JTextArea("   with parm(s)");
        methodParametersTextArea.setLineWrap(false);
        methodParametersTextArea.setEditable(false);
        methodParametersTextArea.setBackground(Administrator.BACKGROUND_COLOR);
        JComponent[] left = new JComponent[]{supportsMethodsTextArea, methodParametersTextArea};
        List methodDefs = Util.getMethodDefinitions(sDefPID);
        String[] methodSelections = new String[methodDefs.size()];
        for (int i = 0; i < methodDefs.size(); ++i) {
            MethodDefinition def = (MethodDefinition)methodDefs.get(i);
            StringBuffer buf = new StringBuffer();
            buf.append(def.getName());
            if (def.getLabel() != null) {
                buf.append(" - ");
                buf.append(def.getLabel());
            }
            methodSelections[i] = buf.toString();
        }
        final JComboBox<String> methodComboBox = new JComboBox<String>(methodSelections);
        Administrator.constrainHeight(methodComboBox);
        final ParameterPanel parameterPanel = new ParameterPanel(methodDefs);
        methodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String[] parts = ((String)methodComboBox.getSelectedItem()).split(" - ");
                parameterPanel.show(parts[0]);
                parameterPanel.revalidate();
            }
        });
        JComponent[] right = new JComponent[]{methodComboBox, parameterPanel};
        GridBagLayout gb = new GridBagLayout();
        JPanel panel = new JPanel(gb);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        Util.addRows(left, right, gb, panel, true, false);
        return panel;
    }

    class ParameterPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final CardLayout m_cardLayout = new CardLayout();

        public ParameterPanel(List methodDefs) {
            this.setLayout(this.m_cardLayout);
            for (int i = 0; i < methodDefs.size(); ++i) {
                MethodDefinition def = (MethodDefinition)methodDefs.get(i);
                this.add((Component)this.makePane(def), def.getName());
            }
        }

        public void show(String methodName) {
            this.m_cardLayout.show(this, methodName);
        }

        private JComponent makePane(MethodDefinition def) {
            if (def.parameterDefinitions().size() == 0) {
                JTextArea noParams = new JTextArea("no parameters.");
                noParams.setLineWrap(false);
                noParams.setEditable(false);
                noParams.setBackground(Administrator.BACKGROUND_COLOR);
                JPanel pane = new JPanel(new BorderLayout());
                JPanel leftPane = new JPanel(new BorderLayout());
                leftPane.add((Component)noParams, "North");
                pane.add((Component)leftPane, "West");
                return pane;
            }
            JTabbedPane pane = new JTabbedPane();
            for (int i = 0; i < def.parameterDefinitions().size(); ++i) {
                ParameterDefinition parmDef = (ParameterDefinition)def.parameterDefinitions().get(i);
                pane.add(parmDef.getName(), this.makeDescPane(parmDef));
            }
            return pane;
        }

        private JPanel makeDescPane(ParameterDefinition parmDef) {
            StringBuffer buf = new StringBuffer();
            if (parmDef.isRequired()) {
                buf.append("Required.");
            } else {
                buf.append("Optional. ");
                if (parmDef.getDefaultValue() != null && parmDef.getDefaultValue().length() > 0) {
                    buf.append("Defaults to " + parmDef.getDefaultValue() + ".");
                }
            }
            if (parmDef.getLabel() != null) {
                buf.append(" " + parmDef.getLabel());
            }
            if (parmDef.validValues().size() > 0) {
                buf.append(" Valid values: ");
                for (int k = 0; k < parmDef.validValues().size(); ++k) {
                    if (k > 0) {
                        buf.append(", ");
                    }
                    buf.append((String)parmDef.validValues().get(k));
                }
            }
            JTextArea desc = new JTextArea(buf.toString());
            desc.setLineWrap(true);
            desc.setEditable(false);
            desc.setWrapStyleWord(true);
            desc.setBackground(Administrator.BACKGROUND_COLOR);
            JPanel pane = new JPanel(new BorderLayout());
            pane.add((Component)desc, "North");
            return pane;
        }
    }
}

