/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.utility.export;

import fedora.common.Constants;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import fedora.server.types.gen.RepositoryInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class AutoExporter
implements Constants {
    private final FedoraAPIM m_apim;
    private final FedoraAPIA m_apia;
    private static HashMap<FedoraAPIA, RepositoryInfo> s_repoInfo = new HashMap();

    public AutoExporter(FedoraAPIA apia, FedoraAPIM apim) throws MalformedURLException, ServiceException {
        this.m_apia = apia;
        this.m_apim = apim;
    }

    public void export(String pid, String format, String exportContext, OutputStream outStream) throws RemoteException, IOException {
        AutoExporter.export(this.m_apia, this.m_apim, pid, format, exportContext, outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void export(FedoraAPIA apia, FedoraAPIM apim, String pid, String format, String exportContext, OutputStream outStream) throws RemoteException, IOException {
        byte[] bytes;
        StringTokenizer stoken;
        int majorVersion;
        RepositoryInfo repoinfo = s_repoInfo.get(apia);
        if (repoinfo == null) {
            repoinfo = apia.describeRepository();
            s_repoInfo.put(apia, repoinfo);
        }
        if ((majorVersion = new Integer((stoken = new StringTokenizer(repoinfo.getRepositoryVersion(), ".")).nextToken()).intValue()) < 2) {
            if (format != null && !format.equals(AutoExporter.METS_EXT1_1.uri) && !format.equals(AutoExporter.METS_EXT1_0.uri) && !format.equals("metslikefedora1") && !format.equals("default")) throw new IOException("You are connected to a pre-2.0 Fedora repository which will only export the XML format \"metslikefedora1\".");
            if (format.equals(AutoExporter.METS_EXT1_1.uri)) {
                System.out.println("WARNING: Repository does not support METS Fedora Extension 1.1; exporting older format (v1.0) instead");
            }
            bytes = apim.export(pid, AutoExporter.METS_EXT1_0.uri, exportContext);
        } else {
            if (majorVersion < 3) {
                if (format != null) {
                    if (format.equals(AutoExporter.FOXML1_1.uri)) {
                        System.out.println("WARNING: Repository does not support FOXML 1.1; exporting older format (v1.0) instead");
                        format = "foxml1.0";
                    } else if (format.equals(AutoExporter.METS_EXT1_1.uri)) {
                        System.out.println("WARNING: Repository does not support METS Fedora Extension 1.1; exporting older format (v1.0) instead");
                        format = "metslikefedora1";
                    }
                }
            } else {
                if (format != null && (format.equals(AutoExporter.METS_EXT1_0.uri) || format.equals("metslikefedora1"))) {
                    System.out.println("WARNING: Repository does not support METS Fedora Extension 1.0; exporting newer format (v1.1) instead");
                    format = AutoExporter.METS_EXT1_1.uri;
                }
                AutoExporter.validateFormat(format);
            }
            bytes = apim.export(pid, format, exportContext);
        }
        try {
            OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
            fmt.setIndent(2);
            fmt.setLineWidth(120);
            fmt.setPreserveSpace(false);
            XMLSerializer ser = new XMLSerializer(outStream, fmt);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(bytes));
            ser.serialize(doc);
            return;
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + " : " + e.getMessage());
            return;
        }
        finally {
            outStream.close();
        }
    }

    public void getObjectXML(String pid, OutputStream outStream) throws RemoteException, IOException {
        AutoExporter.getObjectXML(this.m_apia, this.m_apim, pid, outStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getObjectXML(FedoraAPIA apia, FedoraAPIM apim, String pid, OutputStream outStream) throws RemoteException, IOException {
        RepositoryInfo repoinfo = s_repoInfo.get(apia);
        if (repoinfo == null) {
            repoinfo = apia.describeRepository();
            s_repoInfo.put(apia, repoinfo);
        }
        byte[] bytes = apim.getObjectXML(pid);
        try {
            OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
            fmt.setIndent(2);
            fmt.setLineWidth(120);
            fmt.setPreserveSpace(false);
            XMLSerializer ser = new XMLSerializer(outStream, fmt);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(bytes));
            ser.serialize(doc);
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getClass().getName() + " : " + e.getMessage());
        }
        finally {
            outStream.close();
        }
    }

    public static void validateFormat(String format) throws IOException {
        if (format == null) {
            return;
        }
        if (!(format.equals(AutoExporter.FOXML1_1.uri) || format.equals(AutoExporter.FOXML1_0.uri) || format.equals(AutoExporter.METS_EXT1_1.uri) || format.equals(AutoExporter.ATOM1_0.uri) || format.equals("default"))) {
            throw new IOException("Invalid export format. Valid FORMAT values are: '" + AutoExporter.FOXML1_1.uri + "' '" + AutoExporter.FOXML1_0.uri + "' '" + AutoExporter.METS_EXT1_1.uri + "' '" + AutoExporter.ATOM1_0.uri + "' and 'default'");
        }
    }
}

