/*
 * Decompiled with CFR 0.152.
 */
package fedora.common.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;

public class HttpInputStream
extends InputStream {
    private final HttpClient m_client;
    private final HttpMethod m_method;
    private final String m_url;
    private int m_code;
    private InputStream m_in;

    public HttpInputStream(HttpClient client, HttpMethod method, String url) throws IOException {
        this.m_client = client;
        this.m_method = method;
        this.m_url = url;
        try {
            this.m_code = this.m_client.executeMethod(this.m_method);
            this.m_in = this.m_method.getResponseBodyAsStream();
            if (this.m_in == null) {
                this.m_in = new ByteArrayInputStream(new byte[0]);
            }
        }
        catch (IOException e) {
            this.m_method.releaseConnection();
            throw e;
        }
    }

    public String getMethodName() {
        return this.m_method.getName();
    }

    public String getURL() {
        return this.m_url;
    }

    public int getStatusCode() {
        return this.m_code;
    }

    public String getStatusText() {
        return this.m_method.getStatusLine().getReasonPhrase();
    }

    public Header getResponseHeader(String name) {
        return this.m_method.getResponseHeader(name);
    }

    public String getResponseHeaderValue(String name, String defaultValue) {
        Header header = this.m_method.getResponseHeader(name);
        if (header == null) {
            return defaultValue;
        }
        String value = header.getValue();
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return header.getValue();
    }

    public Header[] getResponseHeaders() {
        return this.m_method.getResponseHeaders();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int read() throws IOException {
        return this.m_in.read();
    }

    public int read(byte[] b) throws IOException {
        return this.m_in.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.m_in.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.m_in.skip(n);
    }

    public int available() throws IOException {
        return this.m_in.available();
    }

    public void mark(int readlimit) {
        this.m_in.mark(readlimit);
    }

    public void reset() throws IOException {
        this.m_in.reset();
    }

    public boolean markSupported() {
        return this.m_in.markSupported();
    }

    public void close() throws IOException {
        this.m_method.releaseConnection();
        this.m_in.close();
    }
}

