/*
 * Decompiled with CFR 0.152.
 */
package fedora.common.http;

import fedora.common.http.HttpInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

public class WebClient {
    public int TIMEOUT_SECONDS = 20;
    public int SOCKET_TIMEOUT_SECONDS = 120;
    public int MAX_CONNECTIONS_PER_HOST = 5;
    public int MAX_TOTAL_CONNECTIONS = 20;
    public boolean FOLLOW_REDIRECTS = true;
    public int MAX_REDIRECTS = 3;
    public String USER_AGENT = null;
    private final MultiThreadedHttpConnectionManager m_cManager = new MultiThreadedHttpConnectionManager();

    public HttpClient getHttpClient() throws IOException {
        return this.getHttpClient(null, null);
    }

    public HttpClient getHttpClient(String hostOrURL, UsernamePasswordCredentials creds) throws IOException {
        String host = null;
        if (hostOrURL != null) {
            if (hostOrURL.indexOf("/") != -1) {
                URL url = new URL(hostOrURL);
                host = url.getHost();
            } else {
                host = hostOrURL;
            }
        }
        this.m_cManager.getParams().setDefaultMaxConnectionsPerHost(this.MAX_CONNECTIONS_PER_HOST);
        this.m_cManager.getParams().setMaxTotalConnections(this.MAX_TOTAL_CONNECTIONS);
        this.m_cManager.getParams().setConnectionTimeout(this.TIMEOUT_SECONDS * 1000);
        this.m_cManager.getParams().setSoTimeout(this.SOCKET_TIMEOUT_SECONDS * 1000);
        HttpClient client = new HttpClient((HttpConnectionManager)this.m_cManager);
        if (host != null && creds != null) {
            client.getState().setCredentials(new AuthScope(host, -1), (Credentials)creds);
            client.getParams().setAuthenticationPreemptive(true);
        }
        return client;
    }

    public HttpInputStream get(String url, boolean failIfNotOK) throws IOException {
        return this.get(url, failIfNotOK, null);
    }

    public HttpInputStream get(String url, boolean failIfNotOK, String user, String pass) throws IOException {
        return this.get(url, failIfNotOK, new UsernamePasswordCredentials(user, pass));
    }

    public HttpInputStream get(String url, boolean failIfNotOK, UsernamePasswordCredentials creds) throws IOException {
        HttpClient client;
        GetMethod getMethod = new GetMethod(url);
        if (this.USER_AGENT != null) {
            getMethod.setRequestHeader("User-Agent", this.USER_AGENT);
        }
        if (creds != null && creds.getUserName() != null && creds.getUserName().length() > 0) {
            client = this.getHttpClient(url, creds);
            getMethod.setDoAuthentication(true);
        } else {
            client = this.getHttpClient();
        }
        HttpInputStream in = new HttpInputStream(client, (HttpMethod)getMethod, url);
        int status = in.getStatusCode();
        if (failIfNotOK && status != 200) {
            if (this.FOLLOW_REDIRECTS && 300 <= status && status <= 399) {
                for (int count = 1; 300 <= status && status <= 399 && count <= this.MAX_REDIRECTS; ++count) {
                    if (in.getResponseHeader("location") == null) {
                        throw new IOException("Redirect HTTP response provided no location header.");
                    }
                    url = in.getResponseHeader("location").getValue();
                    in.close();
                    getMethod = new GetMethod(url);
                    if (this.USER_AGENT != null) {
                        getMethod.setRequestHeader("User-Agent", this.USER_AGENT);
                    }
                    in = new HttpInputStream(client, (HttpMethod)getMethod, url);
                    status = in.getStatusCode();
                }
                if (300 <= status && status <= 399) {
                    in.close();
                    throw new IOException("Too many redirects");
                }
                if (status != 200) {
                    in.close();
                    throw new IOException("Request failed [" + in.getStatusCode() + " " + in.getStatusText() + "]");
                }
            } else {
                try {
                    throw new IOException("Request failed [" + in.getStatusCode() + " " + in.getStatusText() + "]");
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        System.err.println("Can't close InputStream: " + e.getMessage());
                    }
                    throw throwable;
                }
            }
        }
        return in;
    }

    public String getResponseAsString(String url, boolean failIfNotOK) throws IOException {
        return this.getResponseAsString(url, failIfNotOK, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseAsString(String url, boolean failIfNotOK, UsernamePasswordCredentials creds) throws IOException {
        HttpInputStream in = this.get(url, failIfNotOK, creds);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buffer = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line + "\n");
                line = reader.readLine();
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {
                System.err.println("Can't close InputStream: " + e.getMessage());
            }
        }
    }
}

