/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.management;

import fedora.common.Constants;
import fedora.server.management.APIMStub;
import fedora.server.management.FedoraAPIM;
import fedora.server.management.FedoraAPIMService;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class FedoraAPIMServiceLocator
extends Service
implements Constants,
FedoraAPIMService {
    private static final long serialVersionUID = 1L;
    private final String FedoraAPIMPortSOAPHTTP_address = "http://localhost:0/fedora/services/management";
    private final String FedoraAPIMPortSOAPHTTPS_address = "https://localhost:0/fedora/services/management";
    private String username = null;
    private String password = null;
    private int socketTimeoutMilliseconds = 120000;
    private String FedoraAPIMPortSOAPHTTPWSDDServiceName = "FedoraAPIMPortSOAPHTTP";
    private String FedoraAPIMPortSOAPHTTPSWSDDServiceName = "FedoraAPIMPortSOAPHTTPS";
    private HashSet ports = null;

    public FedoraAPIMServiceLocator(String user, String pass) {
        this.username = user;
        this.password = pass;
    }

    public FedoraAPIMServiceLocator(String user, String pass, int socketTimeoutSeconds) {
        this.username = user;
        this.password = pass;
        this.socketTimeoutMilliseconds = socketTimeoutSeconds * 1000;
    }

    public String getFedoraAPIMPortSOAPHTTPAddress() {
        return "http://localhost:0/fedora/services/management";
    }

    public String getFedoraAPIMPortSOAPHTTPWSDDServiceName() {
        return this.FedoraAPIMPortSOAPHTTPWSDDServiceName;
    }

    public void setFedoraAPIMPortSOAPHTTPWSDDServiceName(String name) {
        this.FedoraAPIMPortSOAPHTTPWSDDServiceName = name;
    }

    public FedoraAPIM getFedoraAPIMPortSOAPHTTP() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL("http://localhost:0/fedora/services/management");
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.getFedoraAPIMPortSOAPHTTP(endpoint);
    }

    public FedoraAPIM getFedoraAPIMPortSOAPHTTP(URL portAddress) throws ServiceException {
        try {
            APIMStub _stub = new APIMStub(portAddress, this, this.username, this.password);
            _stub.setPortName(this.getFedoraAPIMPortSOAPHTTPWSDDServiceName());
            _stub.setTimeout(this.socketTimeoutMilliseconds);
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public String getFedoraAPIMPortSOAPHTTPSAddress() {
        return "https://localhost:0/fedora/services/management";
    }

    public String getFedoraAPIMPortSOAPHTTPSWSDDServiceName() {
        return this.FedoraAPIMPortSOAPHTTPSWSDDServiceName;
    }

    public void setFedoraAPIMPortSOAPHTTPSWSDDServiceName(String name) {
        this.FedoraAPIMPortSOAPHTTPSWSDDServiceName = name;
    }

    public FedoraAPIM getFedoraAPIMPortSOAPHTTPS() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL("https://localhost:0/fedora/services/management");
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this.getFedoraAPIMPortSOAPHTTPS(endpoint);
    }

    public FedoraAPIM getFedoraAPIMPortSOAPHTTPS(URL portAddress) throws ServiceException {
        try {
            APIMStub _stub = new APIMStub(portAddress, this, this.username, this.password);
            _stub.setPortName(this.getFedoraAPIMPortSOAPHTTPSWSDDServiceName());
            _stub.setTimeout(this.socketTimeoutMilliseconds);
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (FedoraAPIM.class.isAssignableFrom(serviceEndpointInterface)) {
                APIMStub _stub = new APIMStub(new URL("http://localhost:0/fedora/services/management"), this, this.username, this.password);
                _stub.setPortName(this.getFedoraAPIMPortSOAPHTTPWSDDServiceName());
                _stub.setTimeout(this.socketTimeoutMilliseconds);
                return _stub;
            }
            if (FedoraAPIM.class.isAssignableFrom(serviceEndpointInterface)) {
                APIMStub _stub = new APIMStub(new URL("https://localhost:0/fedora/services/management"), this, this.username, this.password);
                _stub.setPortName(this.getFedoraAPIMPortSOAPHTTPSWSDDServiceName());
                _stub.setTimeout(this.socketTimeoutMilliseconds);
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("FedoraAPIMPortSOAPHTTPS".equals(inputPortName)) {
            return this.getFedoraAPIMPortSOAPHTTPS();
        }
        if ("FedoraAPIMPortSOAPHTTP".equals(inputPortName)) {
            return this.getFedoraAPIMPortSOAPHTTP();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        ((Stub)_stub).setTimeout(this.socketTimeoutMilliseconds);
        return _stub;
    }

    public QName getServiceName() {
        return new QName(FedoraAPIMServiceLocator.API.uri, "Fedora-API-M-Service");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("FedoraAPIMPortSOAPHTTP"));
            this.ports.add(new QName("FedoraAPIMPortSOAPHTTPS"));
        }
        return this.ports.iterator();
    }
}

