/*
 * Decompiled with CFR 0.152.
 */
package fedora.server.utilities.status;

import fedora.server.utilities.status.ServerState;
import fedora.server.utilities.status.ServerStatusMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Date;

public class ServerStatusFile {
    public static final String FILENAME = "status";
    public static final String BEGIN_LINE = "[STATUS]";
    public static final String END_LINE = "[/STATUS]";
    private final File _file;

    public ServerStatusFile(File serverHome) throws Exception {
        if (!serverHome.isDirectory()) {
            throw new Exception("Server home directory not found: " + serverHome.getPath());
        }
        this._file = new File(serverHome, FILENAME);
    }

    public String getPath() {
        return this._file.getPath();
    }

    public synchronized void clear() throws Exception {
        boolean deleted;
        if (this._file.exists() && !(deleted = this._file.delete())) {
            throw new Exception("Failed to delete server status file: " + this._file.getPath());
        }
    }

    public synchronized boolean exists() {
        return this._file.exists();
    }

    public synchronized void appendError(ServerState state, Throwable detail) throws Exception {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        detail.printStackTrace(writer);
        writer.close();
        this.append(state, stringWriter.toString());
    }

    public synchronized void append(ServerState state, String detail) throws Exception {
        ServerStatusMessage message = new ServerStatusMessage(state, null, detail);
        FileOutputStream out = null;
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try {
            out = new FileOutputStream(this._file, true);
            channel = out.getChannel();
            lock = ((FileChannel)channel).lock();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
            this.serialize(message, writer);
            writer.close();
        }
        catch (IOException ioe) {
            throw new Exception("Error opening server status file for writing: " + this._file.getPath(), ioe);
        }
        finally {
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (Exception e) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public synchronized ServerStatusMessage[] getMessages(ServerStatusMessage afterMessage) throws Exception {
        boolean sawAfterMessage;
        String afterMessageString = null;
        if (afterMessage == null) {
            sawAfterMessage = true;
        } else {
            sawAfterMessage = false;
            afterMessageString = afterMessage.toString();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this._file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            ArrayList<ServerStatusMessage> messages = new ArrayList<ServerStatusMessage>();
            ServerStatusMessage message = this.getNextMessage(reader);
            while (message != null) {
                if (!sawAfterMessage) {
                    if (message.toString().equals(afterMessageString)) {
                        sawAfterMessage = true;
                    }
                } else {
                    messages.add(message);
                }
                message = this.getNextMessage(reader);
            }
            ServerStatusMessage[] serverStatusMessageArray = messages.toArray(new ServerStatusMessage[0]);
            return serverStatusMessageArray;
        }
        catch (IOException ioe) {
            throw new Exception("Error opening server status file for reading: " + this._file.getPath(), ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void serialize(ServerStatusMessage message, PrintWriter writer) throws Exception {
        writer.println(BEGIN_LINE);
        writer.println(message.getState().toString());
        writer.println(ServerStatusMessage.dateToString(message.getDate()));
        if (message.getDetail() != null) {
            writer.println(message.getDetail());
        }
        writer.println(END_LINE);
        writer.println();
    }

    private ServerStatusMessage getNextMessage(BufferedReader reader) throws Exception {
        boolean messageStarted = false;
        String line = reader.readLine();
        while (line != null && !messageStarted) {
            if (line.equals(BEGIN_LINE)) {
                messageStarted = true;
                continue;
            }
            line = reader.readLine();
        }
        if (messageStarted) {
            ServerState state = ServerState.fromString(this.getNextLine(reader));
            Date time = ServerStatusMessage.stringToDate(this.getNextLine(reader));
            String detail = null;
            line = this.getNextLine(reader);
            if (!line.equals(END_LINE)) {
                StringBuffer buf = new StringBuffer();
                while (!line.equals(END_LINE)) {
                    buf.append(line + "\n");
                    line = this.getNextLine(reader);
                }
                detail = buf.toString();
            }
            return new ServerStatusMessage(state, time, detail);
        }
        return null;
    }

    private String getNextLine(BufferedReader reader) throws Exception {
        String line = reader.readLine();
        if (line != null) {
            return line;
        }
        throw new Exception("Error parsing server status file (unexpectedly ended): " + this._file.getPath());
    }
}

