/*
 * Decompiled with CFR 0.152.
 */
package fedora.swing.mdi;

import fedora.swing.mdi.MDIDesktopManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = 1L;
    private static int FRAME_OFFSET = 20;
    private final MDIDesktopManager manager = new MDIDesktopManager(this);

    public MDIDesktopPane() {
        this.setDesktopManager(this.manager);
        this.setDragMode(0);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame frame) {
        Point p;
        JInternalFrame[] array = this.getAllFrames();
        Component retval = super.add(frame);
        this.checkDesktopSize();
        if (array.length > 0) {
            p = array[0].getLocation();
            p.x += FRAME_OFFSET;
            p.y += FRAME_OFFSET;
        } else {
            p = new Point(0, 0);
        }
        frame.setLocation(p.x, p.y);
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    public void cascadeFrames() {
        this.restoreFrames();
        int x = 0;
        int y = 0;
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height - 5 - allFrames.length * FRAME_OFFSET;
        int frameWidth = this.getBounds().width - 5 - allFrames.length * FRAME_OFFSET;
        for (int i = allFrames.length - 1; i >= 0; --i) {
            allFrames[i].setSize(frameWidth, frameHeight);
            allFrames[i].setLocation(x, y);
            x += FRAME_OFFSET;
            y += FRAME_OFFSET;
        }
    }

    public void tileFrames() {
        this.restoreFrames();
        JInternalFrame[] allFrames = this.getAllFrames();
        this.manager.setNormalSize();
        int frameHeight = this.getBounds().height / allFrames.length;
        int y = 0;
        for (JInternalFrame element : allFrames) {
            element.setSize(this.getBounds().width, frameHeight);
            element.setLocation(0, y);
            y += frameHeight;
        }
    }

    public void minimizeFrames() {
        JInternalFrame[] array;
        for (JInternalFrame element : array = this.getAllFrames()) {
            try {
                element.setIcon(true);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    public void restoreFrames() {
        JInternalFrame[] array;
        for (JInternalFrame element : array = this.getAllFrames()) {
            try {
                element.setIcon(false);
            }
            catch (PropertyVetoException pve) {
                // empty catch block
            }
        }
    }

    public int deIconifiedFrames() {
        int c = 0;
        JInternalFrame[] array = this.getAllFrames();
        for (int i = 0; i < array.length; ++i) {
            if (array[i].isIcon()) continue;
            ++c;
        }
        return c;
    }

    public int iconifiedFrames() {
        JInternalFrame[] array;
        int c = 0;
        for (JInternalFrame element : array = this.getAllFrames()) {
            if (!element.isIcon()) continue;
            ++c;
        }
        return c;
    }

    public void setAllSize(Dimension d) {
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setPreferredSize(d);
    }

    public void setAllSize(int width, int height) {
        this.setAllSize(new Dimension(width, height));
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }
}

