/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.jrdf.util.ClosableIterator;

public abstract class AbstractGraphUnitTest
extends TestCase {
    protected Graph graph;
    protected GraphElementFactory elementFactory;
    protected static BlankNode blank1;
    protected static BlankNode blank2;
    protected static URI uri1;
    protected static URI uri2;
    protected static URI uri3;
    protected static URIReference ref1;
    protected static URIReference ref2;
    protected static URIReference ref3;
    protected static final String TEST_STR1 = "A test string";
    protected static final String TEST_STR2 = "Another test string";
    protected static Literal l1;
    protected static Literal l2;

    public AbstractGraphUnitTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.graph = this.newGraph();
        this.elementFactory = this.graph.getElementFactory();
        blank1 = this.elementFactory.createResource();
        blank2 = this.elementFactory.createResource();
        uri1 = new URI("http://namespace#somevalue");
        uri2 = new URI("http://namespace#someothervalue");
        uri3 = new URI("http://namespace#yetanothervalue");
        ref1 = this.elementFactory.createResource(uri1);
        ref2 = this.elementFactory.createResource(uri2);
        ref3 = this.elementFactory.createResource(uri3);
        l1 = this.elementFactory.createLiteral(TEST_STR1);
        l2 = this.elementFactory.createLiteral(TEST_STR2);
    }

    public static Test suite() {
        return null;
    }

    public abstract Graph newGraph() throws Exception;

    public void testEmpty() throws Exception {
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)0L, (long)this.graph.getNumberOfTriples());
    }

    public void testFactory() throws Exception {
        GraphElementFactory graphElementFactory = this.graph.getElementFactory();
        AbstractGraphUnitTest.assertTrue((graphElementFactory != null ? 1 : 0) != 0);
    }

    public void testAddition() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)1L, (long)this.graph.getNumberOfTriples());
        Triple triple = this.elementFactory.createTriple(blank2, ref1, blank2);
        this.graph.add(triple);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)2L, (long)this.graph.getNumberOfTriples());
        this.graph.add(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)2L, (long)this.graph.getNumberOfTriples());
        Triple triple2 = this.elementFactory.createTriple(blank2, ref1, blank2);
        this.graph.add(triple2);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)2L, (long)this.graph.getNumberOfTriples());
        this.graph.add(triple);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)2L, (long)this.graph.getNumberOfTriples());
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        arrayList.add(this.elementFactory.createTriple(ref1, ref1, ref1));
        arrayList.add(this.elementFactory.createTriple(ref2, ref2, ref2));
        this.graph.add(arrayList.iterator());
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)4L, (long)this.graph.getNumberOfTriples());
    }

    public void testRemoval() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        this.graph.add(blank1, ref2, blank2);
        this.graph.add(ref1, ref2, l2);
        Triple triple = this.elementFactory.createTriple(blank2, ref1, blank1);
        this.graph.add(triple);
        Triple triple2 = this.elementFactory.createTriple(blank2, ref2, blank1);
        this.graph.add(triple2);
        Triple triple3 = this.elementFactory.createTriple(blank2, ref1, l1);
        this.graph.add(triple3);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)6L, (long)this.graph.getNumberOfTriples());
        this.graph.remove(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertEquals((long)5L, (long)this.graph.getNumberOfTriples());
        this.graph.remove(triple3);
        AbstractGraphUnitTest.assertEquals((long)4L, (long)this.graph.getNumberOfTriples());
        triple2 = this.elementFactory.createTriple(blank2, ref2, blank1);
        this.graph.remove(triple2);
        AbstractGraphUnitTest.assertEquals((long)3L, (long)this.graph.getNumberOfTriples());
        this.graph.remove(blank2, ref1, blank1);
        AbstractGraphUnitTest.assertEquals((long)2L, (long)this.graph.getNumberOfTriples());
        this.graph.remove(ref1, ref2, l2);
        AbstractGraphUnitTest.assertEquals((long)1L, (long)this.graph.getNumberOfTriples());
        try {
            this.graph.remove(blank2, ref1, blank1);
            AbstractGraphUnitTest.assertTrue((boolean)false);
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        AbstractGraphUnitTest.assertEquals((long)1L, (long)this.graph.getNumberOfTriples());
        try {
            this.graph.remove(blank2, ref2, l2);
            AbstractGraphUnitTest.assertTrue((boolean)false);
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        AbstractGraphUnitTest.assertEquals((long)1L, (long)this.graph.getNumberOfTriples());
        triple = this.elementFactory.createTriple(blank2, ref1, blank1);
        try {
            this.graph.remove(triple);
            AbstractGraphUnitTest.assertTrue((boolean)false);
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        AbstractGraphUnitTest.assertEquals((long)1L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        this.graph.remove(blank1, ref2, blank2);
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)0L, (long)this.graph.getNumberOfTriples());
        try {
            this.graph.remove(blank1, ref2, blank2);
            AbstractGraphUnitTest.assertTrue((boolean)false);
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)0L, (long)this.graph.getNumberOfTriples());
        this.graph.add(this.elementFactory.createTriple(ref1, ref1, ref1));
        this.graph.add(this.elementFactory.createTriple(ref2, ref2, ref2));
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        arrayList.add(this.elementFactory.createTriple(ref1, ref1, ref1));
        arrayList.add(this.elementFactory.createTriple(ref2, ref2, ref2));
        this.graph.remove(arrayList.iterator());
        try {
            this.graph.remove(ref2, ref2, ref2);
            AbstractGraphUnitTest.assertTrue((boolean)false);
        }
        catch (GraphException graphException) {
            // empty catch block
        }
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)0L, (long)this.graph.getNumberOfTriples());
    }

    public void testContains() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        this.graph.add(blank1, ref2, blank2);
        this.graph.add(ref1, ref2, l2);
        Triple triple = this.elementFactory.createTriple(blank2, ref1, blank1);
        this.graph.add(triple);
        Triple triple2 = this.elementFactory.createTriple(blank2, ref2, blank1);
        this.graph.add(triple2);
        Triple triple3 = this.elementFactory.createTriple(blank2, ref1, l1);
        this.graph.add(triple3);
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.contains(blank1, ref1, blank2));
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.contains(triple));
        triple = this.elementFactory.createTriple(blank2, ref2, blank1);
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.contains(triple));
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.contains(blank1, ref1, blank1));
        triple = this.elementFactory.createTriple(blank2, ref2, ref1);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.contains(triple));
        this.graph.remove(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.contains(blank1, ref1, blank2));
        triple = this.elementFactory.createTriple(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.contains(triple));
        this.graph.add(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.contains(blank1, ref1, blank2));
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.contains(triple));
        Graph graph = this.newGraph();
        AbstractGraphUnitTest.assertFalse((boolean)graph.contains(null, null, null));
        GraphElementFactory graphElementFactory = graph.getElementFactory();
        blank1 = graphElementFactory.createResource();
        blank2 = graphElementFactory.createResource();
        ref1 = graphElementFactory.createResource(uri1);
        triple = graphElementFactory.createTriple(blank1, ref1, blank2);
        graph.add(triple);
        AbstractGraphUnitTest.assertTrue((boolean)graph.contains(null, ref1, blank2));
        AbstractGraphUnitTest.assertTrue((boolean)graph.contains(null, null, blank2));
        AbstractGraphUnitTest.assertTrue((boolean)graph.contains(null, null, null));
        AbstractGraphUnitTest.assertTrue((boolean)graph.contains(blank1, null, blank2));
        AbstractGraphUnitTest.assertTrue((boolean)graph.contains(blank1, null, null));
        AbstractGraphUnitTest.assertTrue((boolean)graph.contains(blank1, ref1, null));
        AbstractGraphUnitTest.assertFalse((boolean)graph.contains(null, ref2, blank1));
        AbstractGraphUnitTest.assertFalse((boolean)graph.contains(null, null, blank1));
        AbstractGraphUnitTest.assertFalse((boolean)graph.contains(blank2, null, blank1));
        AbstractGraphUnitTest.assertFalse((boolean)graph.contains(blank2, null, null));
        AbstractGraphUnitTest.assertFalse((boolean)graph.contains(blank2, ref2, null));
    }

    public void testFinding() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        this.graph.add(blank1, ref1, l1);
        this.graph.add(blank1, ref2, blank2);
        this.graph.add(blank1, ref1, l2);
        this.graph.add(blank2, ref1, blank2);
        this.graph.add(blank2, ref2, blank2);
        this.graph.add(blank2, ref1, l1);
        this.graph.add(blank2, ref1, l2);
        ClosableIterator closableIterator = this.graph.find(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(ref1, ref1, blank1);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(blank1, ref1, null);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(blank1, null, blank2);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(null, ref1, blank2);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(ref1, ref1, null);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(ref1, null, blank2);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(null, ref3, blank2);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(blank1, null, null);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(null, ref1, null);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(null, null, l1);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(ref1, null, null);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(null, ref3, null);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        closableIterator = this.graph.find(null, null, ref1);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        Triple triple = this.elementFactory.createTriple(blank1, ref1, blank2);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(ref1, ref1, blank1);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(blank1, ref1, null);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(blank1, null, blank2);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(null, ref1, blank2);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(ref1, ref1, null);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(ref1, null, blank2);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(null, ref3, blank2);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(blank1, null, null);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(null, ref1, null);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(null, null, l1);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(ref1, null, null);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(null, ref3, null);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        triple = this.elementFactory.createTriple(null, null, ref1);
        closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
    }

    public void testIteration() throws Exception {
        Triple triple = this.elementFactory.createTriple(blank1, ref1, blank2);
        Triple triple2 = this.elementFactory.createTriple(blank1, ref2, blank2);
        Triple triple3 = this.elementFactory.createTriple(blank1, ref1, l1);
        Triple triple4 = this.elementFactory.createTriple(blank1, ref1, l2);
        Triple triple5 = this.elementFactory.createTriple(blank2, ref1, blank2);
        Triple triple6 = this.elementFactory.createTriple(blank2, ref2, blank2);
        Triple triple7 = this.elementFactory.createTriple(blank2, ref1, l1);
        Triple triple8 = this.elementFactory.createTriple(blank2, ref1, l2);
        this.graph.add(triple);
        this.graph.add(triple2);
        this.graph.add(triple3);
        this.graph.add(triple4);
        this.graph.add(triple5);
        this.graph.add(triple6);
        this.graph.add(triple7);
        this.graph.add(triple8);
        ClosableIterator closableIterator = this.graph.find(triple);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        Triple triple9 = (Triple)closableIterator.next();
        AbstractGraphUnitTest.assertTrue((boolean)((Object)triple9).equals(triple));
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        HashSet<Triple> hashSet = new HashSet<Triple>();
        triple9 = this.elementFactory.createTriple(blank1, ref1, null);
        hashSet.add(triple);
        hashSet.add(triple3);
        hashSet.add(triple4);
        closableIterator = this.graph.find(triple9);
        this.checkSet(hashSet, closableIterator);
        triple9 = this.elementFactory.createTriple(blank1, null, blank2);
        hashSet.add(triple);
        hashSet.add(triple2);
        closableIterator = this.graph.find(triple9);
        this.checkSet(hashSet, closableIterator);
        triple9 = this.elementFactory.createTriple(null, ref1, blank2);
        hashSet.add(triple);
        hashSet.add(triple5);
        closableIterator = this.graph.find(triple9);
        this.checkSet(hashSet, closableIterator);
        triple9 = this.elementFactory.createTriple(blank1, null, null);
        hashSet.add(triple);
        hashSet.add(triple2);
        hashSet.add(triple3);
        hashSet.add(triple4);
        closableIterator = this.graph.find(triple9);
        this.checkSet(hashSet, closableIterator);
        triple9 = this.elementFactory.createTriple(null, ref1, null);
        hashSet.add(triple);
        hashSet.add(triple3);
        hashSet.add(triple4);
        hashSet.add(triple5);
        hashSet.add(triple7);
        hashSet.add(triple8);
        closableIterator = this.graph.find(triple9);
        this.checkSet(hashSet, closableIterator);
        triple9 = this.elementFactory.createTriple(null, null, l1);
        hashSet.add(triple3);
        hashSet.add(triple7);
        closableIterator = this.graph.find(triple9);
        this.checkSet(hashSet, closableIterator);
        closableIterator = this.graph.find(blank1, ref1, blank2);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        triple9 = (Triple)closableIterator.next();
        AbstractGraphUnitTest.assertTrue((boolean)((Object)triple9).equals(triple));
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator = this.graph.find(blank1, ref1, null);
        hashSet.add(triple);
        hashSet.add(triple3);
        hashSet.add(triple4);
        this.checkSet(hashSet, closableIterator);
        closableIterator = this.graph.find(blank1, null, blank2);
        hashSet.add(triple);
        hashSet.add(triple2);
        this.checkSet(hashSet, closableIterator);
        closableIterator = this.graph.find(null, ref1, blank2);
        hashSet.add(triple);
        hashSet.add(triple5);
        this.checkSet(hashSet, closableIterator);
        closableIterator = this.graph.find(blank1, null, null);
        hashSet.add(triple);
        hashSet.add(triple2);
        hashSet.add(triple3);
        hashSet.add(triple4);
        this.checkSet(hashSet, closableIterator);
        closableIterator = this.graph.find(null, ref1, null);
        hashSet.add(triple);
        hashSet.add(triple3);
        hashSet.add(triple4);
        hashSet.add(triple5);
        hashSet.add(triple7);
        hashSet.add(triple8);
        this.checkSet(hashSet, closableIterator);
        closableIterator = this.graph.find(null, null, l1);
        hashSet.add(triple3);
        hashSet.add(triple7);
        this.checkSet(hashSet, closableIterator);
    }

    public void testIterativeRemoval() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        this.graph.add(blank1, ref2, blank2);
        this.graph.add(ref1, ref2, l2);
        Triple triple = this.elementFactory.createTriple(blank2, ref1, blank1);
        this.graph.add(triple);
        Triple triple2 = this.elementFactory.createTriple(blank2, ref2, blank1);
        this.graph.add(triple2);
        Triple triple3 = this.elementFactory.createTriple(blank2, ref1, l1);
        this.graph.add(triple3);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)6L, (long)this.graph.getNumberOfTriples());
        ClosableIterator closableIterator = this.graph.find(blank2, ref1, null);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.next();
        closableIterator.remove();
        AbstractGraphUnitTest.assertEquals((long)5L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.next();
        closableIterator.remove();
        AbstractGraphUnitTest.assertEquals((long)4L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator = this.graph.find(blank1, null, null);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.next();
        closableIterator.remove();
        AbstractGraphUnitTest.assertEquals((long)3L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.next();
        closableIterator.remove();
        AbstractGraphUnitTest.assertEquals((long)2L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator = this.graph.find(ref1, ref2, l2);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.next();
        closableIterator.remove();
        AbstractGraphUnitTest.assertEquals((long)1L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator = this.graph.find(null, null, null);
        AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
        closableIterator.next();
        closableIterator.remove();
        AbstractGraphUnitTest.assertEquals((long)0L, (long)this.graph.getNumberOfTriples());
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
        try {
            this.graph.remove(ref2, ref2, ref2);
            AbstractGraphUnitTest.assertTrue((boolean)false);
        }
        catch (GraphException graphException) {
            // empty catch block
        }
    }

    public void testFullIterativeRemoval() throws Exception {
        this.graph.add(blank1, ref1, blank2);
        this.graph.add(blank1, ref2, blank2);
        this.graph.add(ref1, ref2, l2);
        Triple triple = this.elementFactory.createTriple(blank2, ref1, blank1);
        this.graph.add(triple);
        Triple triple2 = this.elementFactory.createTriple(blank2, ref2, blank1);
        this.graph.add(triple2);
        Triple triple3 = this.elementFactory.createTriple(blank2, ref1, l1);
        this.graph.add(triple3);
        AbstractGraphUnitTest.assertFalse((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertEquals((long)6L, (long)this.graph.getNumberOfTriples());
        ClosableIterator closableIterator = this.graph.find(null, null, null);
        for (int i = 5; i >= 0; --i) {
            AbstractGraphUnitTest.assertTrue((boolean)closableIterator.hasNext());
            closableIterator.next();
            closableIterator.remove();
            AbstractGraphUnitTest.assertEquals((long)i, (long)this.graph.getNumberOfTriples());
        }
        AbstractGraphUnitTest.assertTrue((boolean)this.graph.isEmpty());
        AbstractGraphUnitTest.assertFalse((boolean)closableIterator.hasNext());
        closableIterator.close();
    }

    private void checkSet(Set set, ClosableIterator closableIterator) throws Exception {
        while (closableIterator.hasNext()) {
            Triple triple = (Triple)closableIterator.next();
            AbstractGraphUnitTest.assertTrue((boolean)set.contains(triple));
            set.remove(triple);
        }
        if (!set.isEmpty()) {
            System.out.println("triples still contains: " + set.toString());
        }
        AbstractGraphUnitTest.assertTrue((boolean)set.isEmpty());
        closableIterator.close();
    }
}

