/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.impl.postgres;

import java.util.ArrayList;
import java.util.List;
import org.nsdl.mptstore.core.AbstractDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDDLGenerator
extends AbstractDDLGenerator {
    private final String[] _users;
    private final String[] _groups;

    public PostgresDDLGenerator() {
        this._users = PostgresDDLGenerator.splitProperty("mptstore.postgres.autoGrantUsers");
        this._groups = PostgresDDLGenerator.splitProperty("mptstore.postgres.autoGrantGroups");
    }

    public PostgresDDLGenerator(String[] users, String[] groups) {
        this._users = users == null ? new String[0] : users;
        this._groups = groups == null ? new String[0] : groups;
    }

    private static String[] splitProperty(String name) {
        String val = System.getProperty(name);
        if (val == null || val.trim().length() == 0) {
            return new String[0];
        }
        return val.trim().split(" +");
    }

    private void addSelectGrants(List<String> cmds, String table) {
        for (String name : this._users) {
            cmds.add("GRANT SELECT ON TABLE " + table + " TO " + name);
        }
        for (String name : this._groups) {
            cmds.add("GRANT SELECT ON TABLE " + table + " TO GROUP " + name);
        }
    }

    @Override
    public List<String> getCreateMapTableDDL(String table) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("CREATE TABLE " + table + " (\n" + "  pKey SERIAL,\n" + "  p TEXT NOT NULL\n" + ")");
        cmds.add("CREATE INDEX " + table + "_pKey " + " on " + table + " (pKey)");
        cmds.add("CREATE INDEX " + table + "_p " + " on " + table + " (p)");
        this.addSelectGrants(cmds, table);
        return cmds;
    }

    @Override
    public List<String> getCreateSOTableDDL(String table) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("CREATE TABLE " + table + " (\n" + "  s TEXT NOT NULL,\n" + "  o TEXT NOT NULL\n" + ")");
        cmds.add("CREATE INDEX " + table + "_s " + " on " + table + " (s)");
        cmds.add("CREATE INDEX " + table + "_o " + " on " + table + " (o)");
        this.addSelectGrants(cmds, table);
        return cmds;
    }
}

