/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query.component;

import org.nsdl.mptstore.query.component.MPTable;
import org.nsdl.mptstore.query.component.NodePattern;
import org.nsdl.mptstore.rdf.Node;
import org.nsdl.mptstore.rdf.ObjectNode;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.rdf.SubjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappableNodePattern<T extends Node>
implements NodePattern<T> {
    private final boolean isVariable;
    private final T nodeValue;
    private final String varName;
    private MPTable boundTable;
    private String theType;

    public MappableNodePattern(String variable, String type) {
        this.varName = variable;
        this.isVariable = true;
        this.nodeValue = null;
        this.theType = type;
    }

    public MappableNodePattern(T node) {
        if (node instanceof SubjectNode) {
            this.theType = "s";
        } else if (node instanceof ObjectNode) {
            this.theType = "o";
        } else if (node instanceof PredicateNode) {
            this.theType = "p";
        } else {
            throw new IllegalArgumentException("Given node type is not a SubjectNode, PredicateNode, or ObjectNode");
        }
        this.varName = null;
        this.isVariable = false;
        this.nodeValue = node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MappableNodePattern(NodePattern<? extends T> nodePattern) {
        this.varName = nodePattern.getVarName();
        this.isVariable = nodePattern.isVariable();
        this.nodeValue = nodePattern.getNode();
        if (!nodePattern.isVariable()) {
            T node = nodePattern.getNode();
            if (node instanceof SubjectNode) {
                this.theType = "s";
                return;
            } else if (node instanceof ObjectNode) {
                this.theType = "o";
                return;
            } else {
                if (!(node instanceof PredicateNode)) throw new IllegalArgumentException("Given node type is not a SubjectNode, PredicateNode, or ObjectNode");
                this.theType = "p";
            }
            return;
        } else {
            this.theType = null;
        }
    }

    public MappableNodePattern(NodePattern<? extends T> nodePattern, Class<T> patternType) {
        this.varName = nodePattern.getVarName();
        this.isVariable = nodePattern.isVariable();
        this.nodeValue = nodePattern.getNode();
        if (SubjectNode.class.isAssignableFrom(patternType)) {
            this.theType = "s";
        } else if (ObjectNode.class.isAssignableFrom(patternType)) {
            this.theType = "o";
        } else if (PredicateNode.class.isAssignableFrom(patternType)) {
            this.theType = "p";
        } else {
            throw new IllegalArgumentException("Given node type is not a SubjectNode, PredicateNode, or ObjectNode");
        }
    }

    @Override
    public boolean isVariable() {
        return this.isVariable;
    }

    public void bindTo(MPTable t) {
        if (t == null) {
            throw new NullPointerException("Cannot bind to null table");
        }
        this.boundTable = t;
    }

    public void bindTo(MPTable t, String type) {
        if (t == null) {
            throw new NullPointerException("Cannot bind to null table");
        }
        if (this.theType == null) {
            if (!type.matches("^s|p|o$")) {
                throw new IllegalArgumentException("Unknown type '" + type + "'");
            }
            this.theType = type;
        }
        this.boundTable = t;
    }

    public String mappedName() {
        if (this.boundTable == null) {
            if (this.isVariable) {
                throw new RuntimeException("Variable " + this.varName + " has not been bound");
            }
            throw new RuntimeException("Node " + this.nodeValue + " has not been bound");
        }
        if (this.theType == null || this.theType.equals("p")) {
            return this.boundTable.alias();
        }
        return this.boundTable.alias() + "." + this.theType;
    }

    public MPTable boundTable() {
        return this.boundTable;
    }

    @Override
    public T getNode() {
        return this.nodeValue;
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    public boolean equals(Object p) {
        if (!(p instanceof MappableNodePattern)) {
            return false;
        }
        MappableNodePattern comparison = (MappableNodePattern)p;
        if (this.isVariable() && comparison.isVariable()) {
            if (this.getVarName() == null || comparison.getVarName() == null) {
                return false;
            }
            return this.getVarName().equals(comparison.getVarName());
        }
        if (!this.isVariable() && !comparison.isVariable()) {
            if (this.getNode() == null || comparison.getNode() == null) {
                return false;
            }
            try {
                return this.getNode().getValue().equals(comparison.getNode().getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isVariable) {
            return this.varName;
        }
        return this.nodeValue.toString();
    }

    public int hashCode() {
        if (this.isVariable) {
            return this.varName.hashCode();
        }
        return this.nodeValue.hashCode();
    }

    public static class Types {
        public static final String SUBJECT = "s";
        public static final String PREDICATE = "p";
        public static final String OBJECT = "o";
    }
}

