/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.util;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class DBUtil {
    private static final Logger LOG = Logger.getLogger((String)DBUtil.class.getName());

    private DBUtil() {
    }

    public static String getLongString(ResultSet rs, int pos) throws SQLException {
        String s = rs.getString(pos);
        if (s != null) {
            return s;
        }
        Clob c = rs.getClob(pos);
        if (c == null) {
            return null;
        }
        return c.getSubString(1L, (int)c.length());
    }

    public static String quotedString(String in, boolean backslashIsEscape) {
        StringBuffer out = new StringBuffer();
        out.append('\'');
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\'') {
                out.append("''");
                continue;
            }
            if (backslashIsEscape && c == '\\') {
                out.append("\\\\");
                continue;
            }
            out.append(c);
        }
        out.append('\'');
        return out.toString();
    }

    public static void release(Connection conn) {
        try {
            if (!conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error setting autocommit", (Throwable)e);
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            LOG.warn((Object)"Error closing/releasing connection", (Throwable)e);
        }
    }
}

