/*
 * Decompiled with CFR 0.152.
 */
package org.trippi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.URIReference;
import org.trippi.RDFUtil;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;
import org.trippi.io.TupleWriter;

public class SimpleTupleWriter
extends TupleWriter {
    private PrintWriter m_out;
    private Map m_aliases;

    public SimpleTupleWriter(OutputStream out, Map aliases) throws TrippiException {
        try {
            this.m_out = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
            this.m_aliases = aliases;
        }
        catch (IOException e) {
            throw new TrippiException("Error setting up writer", e);
        }
    }

    public int write(TupleIterator iter) throws TrippiException {
        String[] names = iter.names();
        int longest = 0;
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= longest) continue;
            longest = names[i].length();
        }
        int count = 0;
        while (iter.hasNext()) {
            Map result = iter.next();
            for (int i = 0; i < names.length; ++i) {
                this.m_out.println(names[i] + SimpleTupleWriter.indent(longest - names[i].length()) + " : " + this.getString((Node)result.get(names[i])));
            }
            this.m_out.println("");
            this.m_out.flush();
            ++count;
        }
        this.m_out.flush();
        iter.close();
        return count;
    }

    public String getString(Node node) {
        String fullString;
        block2: {
            Literal literal;
            block3: {
                fullString = RDFUtil.toString(node);
                if (this.m_aliases == null) break block2;
                if (!(node instanceof URIReference)) break block3;
                Iterator iter = this.m_aliases.keySet().iterator();
                while (iter.hasNext()) {
                    String alias = (String)iter.next();
                    String prefix = (String)this.m_aliases.get(alias);
                    if (!fullString.startsWith("<" + prefix)) continue;
                    return "<" + alias + ":" + fullString.substring(prefix.length() + 1);
                }
                break block2;
            }
            if (!(node instanceof Literal) || (literal = (Literal)node).getDatatypeURI() == null) break block2;
            String uri = literal.getDatatypeURI().toString();
            Iterator iter = this.m_aliases.keySet().iterator();
            while (iter.hasNext()) {
                String alias = (String)iter.next();
                String prefix = (String)this.m_aliases.get(alias);
                if (!uri.startsWith(prefix)) continue;
                StringBuffer out = new StringBuffer();
                out.append('\"');
                out.append(literal.getLexicalForm().replaceAll("\"", "\\\""));
                out.append("\"^^");
                out.append(alias);
                out.append(':');
                out.append(uri.substring(prefix.length()));
                return out.toString();
            }
        }
        return fullString;
    }

    public static String indent(int num) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            out.append(' ');
        }
        return out.toString();
    }
}

