/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bvalid.xsd;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.bvalid.ValidatorException;
import net.sf.bvalid.locator.SchemaLocator;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocatorEntityResolver
implements EntityResolver {
    private static Logger _LOG = Logger.getLogger((String)LocatorEntityResolver.class.getName());
    private SchemaLocator _locator;
    private boolean _mustResolveAll;
    private String _primarySchemaURI;
    private String _lastResolvedSchemaURL;
    private Set _resolvedURIs;
    private Set _inputStreams;
    private boolean _closed;

    public LocatorEntityResolver(SchemaLocator locator, boolean mustResolveAll, String primarySchemaURI) {
        this._locator = locator;
        this._mustResolveAll = mustResolveAll;
        this._primarySchemaURI = primarySchemaURI;
        this._resolvedURIs = new HashSet();
        this._inputStreams = new HashSet();
        this._closed = false;
    }

    public Set getResolvedURIs() {
        return this._resolvedURIs;
    }

    public boolean close() {
        if (!this._closed) {
            _LOG.debug((Object)("Closing " + this._inputStreams.size() + " returned InputSources' underlying InputStreams"));
            Iterator iter = this._inputStreams.iterator();
            this._closed = true;
            while (iter.hasNext()) {
                InputStream in = (InputStream)iter.next();
                try {
                    in.close();
                }
                catch (Exception e) {
                    this._closed = false;
                }
            }
        }
        return this._closed;
    }

    public void finalize() {
        if (!this._closed) {
            this.close();
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputStream in;
        if (publicId != null) {
            try {
                return this.resolveDTD(publicId, systemId);
            }
            catch (ValidatorException e) {
                throw new SAXException("Error resolving DTD", e);
            }
        }
        _LOG.info((Object)("Resolving schema: " + systemId));
        try {
            in = this._locator.get(systemId, this._mustResolveAll);
        }
        catch (ValidatorException e) {
            throw new SAXException("Unable to resolve required schema", e);
        }
        if (in == null) {
            if (this._primarySchemaURI != null && this._primarySchemaURI.equals(systemId)) {
                throw new SAXException("Unable to resolve primary schema");
            }
            return new InputSource();
        }
        if (systemId.startsWith("http://")) {
            this._lastResolvedSchemaURL = systemId;
        }
        this._resolvedURIs.add(systemId);
        this._inputStreams.add(in);
        return new InputSource(in);
    }

    private InputSource resolveDTD(String publicId, String systemId) throws ValidatorException {
        String uri = this.getDTDURI(publicId, systemId);
        _LOG.info((Object)("Resolving DTD: " + uri));
        InputStream in = this._locator.get(uri, this._mustResolveAll);
        this._inputStreams.add(in);
        InputSource inputSource = new InputSource(in);
        this._resolvedURIs.add(uri);
        return inputSource;
    }

    private String getDTDURI(String publicId, String systemId) throws ValidatorException {
        URL url;
        _LOG.debug((Object)("Determining URI for DTD (publicId=" + publicId + ", systemId=" + systemId + ")"));
        if (systemId.startsWith("http:")) {
            return systemId;
        }
        if (!systemId.startsWith("file:")) {
            throw new ValidatorException("Unrecognized scheme for DTD systemId: " + systemId);
        }
        try {
            url = new URL(systemId);
        }
        catch (Exception e) {
            throw new ValidatorException("Cannot convert to file URL: " + systemId);
        }
        File f = new File(url.getFile());
        if (f.exists() || this._lastResolvedSchemaURL == null) {
            return systemId;
        }
        String cwd = new File("").getAbsolutePath();
        String fPath = f.getPath();
        if (fPath.startsWith(cwd)) {
            try {
                URL lastURL = new URL(this._lastResolvedSchemaURL);
                URL thisURL = new URL(lastURL, fPath.substring(cwd.length() + 1));
                return thisURL.toString();
            }
            catch (Exception e) {
                throw new ValidatorException("Error converting to relative URL: " + systemId, e);
            }
        }
        return systemId;
    }
}

