/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.batch.BatchTool;
import fedora.common.Constants;
import java.io.File;
import java.util.Properties;

public class AutoBatchIngest
implements Constants {
    private final Properties batchProperties = new Properties();

    public AutoBatchIngest(String objectDir, String logFile, String logFormat, String objectFormat, String host, String port, String username, String password, String protocol) throws Exception {
        this.batchProperties.setProperty("ingest", "yes");
        this.batchProperties.setProperty("objects", objectDir);
        this.batchProperties.setProperty("ingested-pids", logFile);
        this.batchProperties.setProperty("pids-format", logFormat);
        this.batchProperties.setProperty("object-format", objectFormat);
        this.batchProperties.setProperty("server-fqdn", host);
        this.batchProperties.setProperty("server-port", port);
        this.batchProperties.setProperty("username", username);
        this.batchProperties.setProperty("password", password);
        this.batchProperties.setProperty("server-protocol", protocol);
        BatchTool batchTool = new BatchTool(this.batchProperties, null, null);
        batchTool.prep();
        batchTool.process();
    }

    public static final void main(String[] args) throws Exception {
        boolean errors = false;
        if (args.length == 8) {
            String[] server;
            if (!new File(args[0]).isDirectory()) {
                System.out.println("Specified object directory: \"" + args[0] + "\" is not a directory.");
                errors = true;
            }
            if (!args[2].equals("xml") && !args[2].equals("text")) {
                System.out.println("Format for log file must must be either: \"\"xml\"  or  \"txt\"");
                errors = true;
            }
            if (!args[3].equals(AutoBatchIngest.FOXML1_1.uri) && !args[3].equals(AutoBatchIngest.METS_EXT1_1.uri)) {
                System.out.println("Object format must must be either: \"\"" + AutoBatchIngest.FOXML1_1.uri + "\" or \"" + AutoBatchIngest.METS_EXT1_1.uri + "\"");
                errors = true;
            }
            if ((server = args[4].split(":")).length != 2) {
                System.out.println("Specified server name does not specify port number: \"" + args[4] + "\" .");
                errors = true;
            }
            if (!args[7].equals("http") && !args[7].equals("https")) {
                System.out.println("Protocl must be either: \"\"http\"  or  \"https\"");
                errors = true;
            }
            if (!errors) {
                AutoBatchIngest autoBatchIngest = new AutoBatchIngest(args[0], args[1], args[2], args[3], server[0], server[1], args[5], args[6], args[7]);
            }
        } else {
            System.out.println("\n**** Wrong Number of Arguments *****\n");
            System.out.println("AutoBatchIngest requires 8 arguments.");
            System.out.println("(1) - full path to object directory");
            System.out.println("(2) - full path to log file");
            System.out.println("(3) - format of log file (xml or text)");
            System.out.println("(4) - object format (" + AutoBatchIngest.FOXML1_1.uri + " or " + AutoBatchIngest.METS_EXT1_1.uri + ")\n");
            System.out.println("(5) - host name and port of Fedora server (host:port)");
            System.out.println("(6) - admin username of Fedora server");
            System.out.println("(7) - password for admin user of Fedora server\n");
            System.out.println("(8) - protocol to communicate with Fedora server (http or https)");
        }
    }
}

