/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.batch;

import fedora.client.batch.BatchAdditions;
import fedora.client.batch.BatchIngest;
import fedora.client.batch.BatchXforms;
import fedora.common.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class BatchTool {
    private final Properties miscProperties;
    private final Properties datastreamProperties;
    private final Properties metadataProperties;
    private final Properties batchAdditionsValues;
    private final Properties batchXformsValues;
    private final Properties batchIngestValues;
    private boolean good2go = false;
    static final String XMLREPORTROOT = "object-processing-map";
    static final String STARTOBJECT = "initial-pid";
    static final String KEYPATH = "key-path";
    static final String METADATAPATH = "metadata";
    static final String URLPATH = "url";
    static final String DATAPATH = "data";
    static final String STRINGPREFIX = "url-prefix";
    static final String DECLARATIONS = "namespace-declarations";
    private static final String AGGREGATE = "process-tree";
    static final String ADDITIONSPATH = "specifics";
    static final String XFORMPATH = "xform";
    static final String CMODEL = "template";
    private static final String DISCRETE = "merge-objects";
    static final String OBJECTSPATH = "objects";
    static final String SERVERPROTOCOL = "server-protocol";
    static final String SERVERFQDN = "server-fqdn";
    static final String SERVERPORT = "server-port";
    static final String USERNAME = "username";
    static final String PASSWORD = "password";
    private static final String EAT = "ingest";
    static final String PIDSPATH = "ingested-pids";
    static final String PIDSFORMAT = "pids-format";
    static final String OBJECTFORMAT = "object-format";

    public BatchTool(Properties miscProperties, Properties datastreamProperties, Properties metadataProperties) throws Exception {
        this.miscProperties = miscProperties;
        this.metadataProperties = metadataProperties;
        this.datastreamProperties = datastreamProperties;
        this.batchAdditionsValues = (Properties)miscProperties.clone();
        this.batchXformsValues = (Properties)miscProperties.clone();
        this.batchIngestValues = (Properties)miscProperties.clone();
    }

    public final void prep() {
        this.good2go = true;
    }

    public final void process() throws Exception {
        if (this.good2go) {
            BatchAdditions batchAdditions = null;
            BatchXforms batchXforms = null;
            BatchIngest batchIngest = null;
            if (this.miscProperties.getProperty(AGGREGATE) != null && this.miscProperties.getProperty(AGGREGATE).equals("yes")) {
                batchAdditions = new BatchAdditions(this.batchAdditionsValues, this.datastreamProperties, this.metadataProperties);
            }
            if (this.miscProperties.getProperty(DISCRETE) != null && this.miscProperties.getProperty(DISCRETE).equals("yes")) {
                batchXforms = new BatchXforms(this.batchXformsValues);
            }
            if (this.miscProperties.getProperty(EAT) != null && this.miscProperties.getProperty(EAT).equals("yes")) {
                batchIngest = new BatchIngest(this.batchIngestValues);
            }
            if (this.miscProperties.getProperty(AGGREGATE) != null && this.miscProperties.getProperty(AGGREGATE).equals("yes")) {
                batchAdditions.prep();
            }
            if (this.miscProperties.getProperty(DISCRETE) != null && this.miscProperties.getProperty(DISCRETE).equals("yes")) {
                batchXforms.prep();
            }
            if (this.miscProperties.getProperty(EAT) != null && this.miscProperties.getProperty(EAT).equals("yes")) {
                batchIngest.prep();
            }
            if (this.miscProperties.getProperty(AGGREGATE) != null && this.miscProperties.getProperty(AGGREGATE).equals("yes")) {
                batchAdditions.process();
            }
            Vector buildKeys = null;
            if (this.miscProperties.getProperty(DISCRETE) == null || !this.miscProperties.getProperty(DISCRETE).equals("yes")) {
                buildKeys = new Vector();
            } else {
                batchXforms.process();
                buildKeys = batchXforms.getKeys();
            }
            Hashtable ingestMaps = null;
            Vector ingestKeys = null;
            if (this.miscProperties.getProperty(EAT) == null || !this.miscProperties.getProperty(EAT).equals("yes")) {
                ingestMaps = new Hashtable();
                ingestKeys = new Vector();
            } else {
                batchIngest.process();
                ingestMaps = batchIngest.getPidMaps();
                ingestKeys = batchIngest.getKeys();
            }
            String buildPath2directory = this.batchXformsValues.getProperty(ADDITIONSPATH);
            String ingestPath2directory = this.batchIngestValues.getProperty(OBJECTSPATH);
            String pidsPath = this.batchIngestValues.getProperty(PIDSPATH);
            String pidsFormat = this.miscProperties.getProperty(PIDSFORMAT);
            String objectFormat = this.miscProperties.getProperty(OBJECTFORMAT);
            PrintStream out = new PrintStream(new FileOutputStream(pidsPath));
            if (pidsFormat.equals("xml")) {
                out.println("<object-processing-map>");
            }
            int i = 0;
            int j = 0;
            while (i < buildKeys.size() || j < ingestKeys.size()) {
                String buildPath2file = "";
                String ingestPath2file = "";
                String pid = "";
                try {
                    String buildFilename = "";
                    String ingestFilename = "";
                    int compared = 0;
                    if (i < buildKeys.size()) {
                        buildFilename = (String)buildKeys.get(i);
                        compared = -1;
                    }
                    if (j < ingestKeys.size()) {
                        ingestFilename = (String)ingestKeys.get(j);
                        compared = 1;
                    }
                    if (i < buildKeys.size() & j < ingestKeys.size()) {
                        compared = buildFilename.compareTo(ingestFilename);
                    }
                    if (compared <= 0) {
                        buildPath2file = buildPath2directory + File.separator + buildFilename;
                        ingestPath2file = ingestPath2directory + File.separator + buildFilename;
                        ++i;
                    }
                    if (compared >= 0) {
                        ingestPath2file = ingestPath2directory + File.separator + ingestFilename;
                        pid = (String)ingestMaps.get(ingestFilename);
                        ++j;
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    Thread.dumpStack();
                    throw e;
                }
                if (pidsFormat.equals("xml")) {
                    out.print("\t<map ");
                    if (buildPath2file != null && !buildPath2file.equals("")) {
                        out.print("path2spec=\"" + buildPath2file + "\" ");
                    }
                    if (ingestPath2file != null && !ingestPath2file.equals("")) {
                        out.print("path2object=\"" + ingestPath2file + "\" ");
                    }
                    if (pid != null && !pid.equals("")) {
                        out.print("pid=\"" + pid + "\" ");
                    }
                    out.println("/>");
                    continue;
                }
                if (!pidsFormat.equals("text")) continue;
                out.println(buildPath2file + "\t" + ingestPath2file + "\t" + pid);
            }
            if (pidsFormat.equals("xml")) {
                out.println("</object-processing-map>");
            }
            out.close();
        }
    }

    static final boolean argOK(String value) {
        return value != null && !value.equals("");
    }

    public static final void main(String[] args) throws Exception {
        Properties defaults = new Properties();
        String defaultsPath = Constants.FEDORA_HOME + "\\..\\batch\\default.properties";
        defaults.load(new FileInputStream(defaultsPath));
        Properties miscProperties = new Properties(defaults);
        Properties datastreamProperties = new Properties();
        Properties metadataProperties = new Properties();
        miscProperties.load(new FileInputStream(args[0]));
        BatchTool batchTool = new BatchTool(miscProperties, datastreamProperties, metadataProperties);
        batchTool.prep();
        batchTool.process();
    }
}

