/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.deployment.DeploymentBuilderException;
import fedora.client.deployment.MethodDialog;
import fedora.client.deployment.MethodPropertiesDialog;
import fedora.client.deployment.ServiceDefinitionBuilder;
import fedora.client.deployment.ServiceDeploymentBuilder;
import fedora.client.deployment.data.Method;
import fedora.client.deployment.data.MethodParm;
import fedora.client.deployment.data.MethodProperties;
import fedora.client.objecteditor.Util;
import fedora.client.objecteditor.types.MethodDefinition;
import fedora.client.objecteditor.types.ParameterDefinition;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class MethodsPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JInternalFrame parent;
    private JRadioButton rb_baseURL;
    private JRadioButton rb_noBaseURL;
    private JRadioButton rb_noBaseURLMS;
    private final ButtonGroup rb_buttonGroup = new ButtonGroup();
    protected String rb_chosen;
    private JTextField baseURL;
    protected DefaultTableModel methodTableModel;
    protected MethodDialog methodDialog;
    private boolean editMethodMode = false;
    private HashMap methodMap = new HashMap();
    private JTable methodTable;

    public MethodsPane(ServiceDefinitionBuilder parent) {
        this.parent = parent;
        JPanel methodsPanel = this.setMethodsPanel();
        methodsPanel.setBorder(new TitledBorder("Abstract Method Definitions:"));
        this.add((Component)methodsPanel, "Center");
        this.setVisible(true);
    }

    public MethodsPane(ServiceDeploymentBuilder parent) {
        this.parent = parent;
        this.setLayout(new BorderLayout());
        BaseURLActionListener rb_listen = new BaseURLActionListener();
        this.rb_baseURL = new JRadioButton("Base URL: ", true);
        this.rb_baseURL.setActionCommand("baseURL");
        this.rb_baseURL.addActionListener(rb_listen);
        this.rb_chosen = "baseURL";
        this.rb_noBaseURLMS = new JRadioButton("No Base URL (Multi-Server Service)", false);
        this.rb_noBaseURLMS.setActionCommand("noBaseURLMS");
        this.rb_noBaseURLMS.addActionListener(rb_listen);
        this.rb_noBaseURL = new JRadioButton("Fedora Built-in Datastream Resolver", false);
        this.rb_noBaseURL.setActionCommand("noBaseURL");
        this.rb_noBaseURL.addActionListener(rb_listen);
        this.rb_buttonGroup.add(this.rb_baseURL);
        this.rb_buttonGroup.add(this.rb_noBaseURL);
        this.rb_buttonGroup.add(this.rb_noBaseURLMS);
        JPanel serviceBasePanel = new JPanel();
        serviceBasePanel.setBorder(new TitledBorder("Service Address"));
        serviceBasePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridy = 0;
        gbc.gridx = 0;
        serviceBasePanel.add((Component)this.rb_baseURL, gbc);
        gbc.gridx = 1;
        this.baseURL = new JTextField(30);
        serviceBasePanel.add((Component)this.baseURL, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        serviceBasePanel.add((Component)this.rb_noBaseURLMS, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        serviceBasePanel.add((Component)this.rb_noBaseURL, gbc);
        JPanel methodsPanel = this.setMethodsPanel();
        methodsPanel.setBorder(new TitledBorder("Service Method Definitions:"));
        this.add((Component)serviceBasePanel, "North");
        this.add((Component)methodsPanel, "Center");
        this.setVisible(true);
    }

    private JPanel setMethodsPanel() {
        this.methodTableModel = new DefaultTableModel();
        this.methodTable = new JTable(this.methodTableModel){
            private static final long serialVersionUID = 1L;

            public boolean isCellEditable(int rowIndex, int vColIndex) {
                return false;
            }
        };
        this.methodTable.setColumnSelectionAllowed(false);
        this.methodTable.setRowSelectionAllowed(true);
        this.methodTableModel.addColumn("Method Name");
        this.methodTableModel.addColumn("Method Description");
        JScrollPane scrollpane = new JScrollPane(this.methodTable);
        scrollpane.getViewport().setBackground(Color.white);
        JButton jb1 = new JButton("New");
        jb1.setMinimumSize(new Dimension(100, 30));
        jb1.setMaximumSize(new Dimension(100, 30));
        jb1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodsPane.this.addMethod();
            }
        });
        JButton jb1b = new JButton("Edit");
        jb1b.setMinimumSize(new Dimension(100, 30));
        jb1b.setMaximumSize(new Dimension(100, 30));
        jb1b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodsPane.this.editMethod();
            }
        });
        JButton jb2 = new JButton("Delete");
        jb2.setMinimumSize(new Dimension(100, 30));
        jb2.setMaximumSize(new Dimension(100, 30));
        jb2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodsPane.this.deleteMethod();
            }
        });
        JButton jb3 = new JButton("Properties");
        jb3.setMinimumSize(new Dimension(100, 30));
        jb3.setMaximumSize(new Dimension(100, 30));
        jb3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodsPane.this.addMethodProperties();
            }
        });
        JButton jb4 = new JButton("Help");
        jb4.setMinimumSize(new Dimension(100, 30));
        jb4.setMaximumSize(new Dimension(100, 30));
        jb4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodsPane.this.helpTable();
            }
        });
        JPanel t_buttonPanel = new JPanel();
        t_buttonPanel.setLayout(new BoxLayout(t_buttonPanel, 1));
        t_buttonPanel.add(jb1);
        t_buttonPanel.add(jb1b);
        t_buttonPanel.add(jb2);
        t_buttonPanel.add(jb3);
        t_buttonPanel.add(jb4);
        JPanel methodsPanel = new JPanel(new BorderLayout());
        methodsPanel.add((Component)scrollpane, "Center");
        methodsPanel.add((Component)t_buttonPanel, "East");
        return methodsPanel;
    }

    public void clearContractMethods() {
        this.methodMap = new HashMap();
        ((DefaultTableModel)this.methodTable.getModel()).setNumRows(0);
    }

    public JTable renderContractMethods(String sDefPID) {
        this.clearContractMethods();
        List methodDefs = this.getSDefMethods(sDefPID);
        for (int i = 0; i < methodDefs.size(); ++i) {
            MethodDefinition def = (MethodDefinition)methodDefs.get(i);
            List parms = def.parameterDefinitions();
            Method newmethod = new Method();
            newmethod.methodName = def.getName();
            newmethod.methodLabel = def.getLabel();
            newmethod.methodProperties = new MethodProperties();
            newmethod.methodProperties.dsBindingKeys = new String[0];
            newmethod.methodProperties.methodFullURL = null;
            newmethod.methodProperties.methodRelativeURL = null;
            newmethod.methodProperties.protocolType = "HTTP";
            newmethod.methodProperties.returnMIMETypes = new String[0];
            newmethod.methodProperties.methodParms = new MethodParm[parms.size()];
            for (int j = 0; j < parms.size(); ++j) {
                ParameterDefinition parm = (ParameterDefinition)parms.get(j);
                MethodParm p = new MethodParm();
                p.parmDefaultValue = parm.getDefaultValue();
                p.parmDomainValues = parm.validValues().toArray(new String[0]);
                p.parmLabel = parm.getLabel();
                p.parmName = parm.getName();
                p.parmPassBy = "VALUE";
                p.parmRequired = Boolean.toString(parm.isRequired());
                p.parmType = "fedora:userInputType";
                newmethod.methodProperties.methodParms[j] = p;
            }
            try {
                this.setSDepMethod(newmethod.methodName, newmethod.methodLabel);
                this.setMethodProperties(newmethod.methodName, newmethod.methodProperties);
                continue;
            }
            catch (DeploymentBuilderException e) {
                this.assertMethodLoadErrorMsg("Problem loading sdef contract methods");
            }
        }
        return this.methodTable;
    }

    private void cleanupMethodURLs() {
        Method[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            methods[i].methodProperties.methodFullURL = " ";
            methods[i].methodProperties.methodRelativeURL = " ";
            this.methodMap.put(methods[i].methodName, methods[i]);
        }
    }

    public boolean hasBaseURL() {
        return this.rb_chosen.equalsIgnoreCase("baseURL");
    }

    public String getBaseURL() {
        if (this.hasBaseURL()) {
            return this.baseURL.getText();
        }
        return null;
    }

    public boolean isMultiServer() {
        return this.rb_chosen.equalsIgnoreCase("noBaseURLMS");
    }

    public boolean isLocalHTTP() {
        return this.rb_chosen.equalsIgnoreCase("noBaseURL");
    }

    public HashMap getMethodMap() {
        return this.methodMap;
    }

    public Method[] getMethods() {
        Vector<Method> v_methods = new Vector<Method>();
        Collection c = this.methodMap.values();
        for (Method m : c) {
            v_methods.add(m);
        }
        return v_methods.toArray(new Method[0]);
    }

    public void setSDepMethod(String methodName, String methodDesc) throws DeploymentBuilderException {
        if (this.editMethodMode) {
            int currentRowIndex = this.methodTable.getSelectedRow();
            String oldMethodName = (String)this.methodTable.getValueAt(currentRowIndex, 0);
            Method methodData = (Method)this.methodMap.get(oldMethodName);
            if (!oldMethodName.equalsIgnoreCase(methodName)) {
                this.methodMap.remove(oldMethodName);
            }
            methodData.methodName = methodName;
            methodData.methodLabel = methodDesc;
            this.methodMap.put(methodData.methodName, methodData);
            this.methodTable.setValueAt(methodData.methodName, currentRowIndex, 0);
            this.methodTable.setValueAt(methodData.methodLabel, currentRowIndex, 1);
        } else {
            if (this.methodMap.containsKey(methodName)) {
                throw new DeploymentBuilderException("MethodsPane.setSDepMethod: Method name exists already");
            }
            this.methodTableModel.addRow(new Object[]{methodName, methodDesc});
            Method methodData = new Method();
            methodData.methodName = methodName;
            methodData.methodLabel = methodDesc;
            this.methodMap.put(methodName, methodData);
        }
    }

    public void setMethodProperties(String methodName, MethodProperties mproperties) {
        Method method = (Method)this.methodMap.get(methodName);
        method.methodProperties = mproperties;
        this.methodMap.put(methodName, method);
    }

    private void addMethod() {
        this.methodDialog = new MethodDialog(this, "Add Method", true);
    }

    private void editMethod() {
        this.editMethodMode = true;
        int currentRowIndex = this.methodTable.getSelectedRow();
        if (this.methodTable.getRowCount() <= 0) {
            this.editMethodMode = false;
            this.assertNoMethodMsg("There are no rows to edit.");
            return;
        }
        if (currentRowIndex == -1) {
            this.editMethodMode = false;
            this.assertNoMethodMsg("You must select a method row before attempting editing.");
            return;
        }
        this.methodDialog = new MethodDialog(this, "Edit Method", true, (String)this.methodTable.getValueAt(currentRowIndex, 0), (String)this.methodTable.getValueAt(currentRowIndex, 1));
        this.editMethodMode = false;
    }

    private void deleteMethod() {
        int currentRowIndex = this.methodTable.getSelectedRow();
        if (this.methodTable.getRowCount() <= 0) {
            this.assertNoMethodMsg("There are no rows to delete.");
            return;
        }
        if (currentRowIndex == -1) {
            this.assertNoMethodMsg("You must select a method row before attempting deletion.");
            return;
        }
        String methodName = (String)this.methodTable.getValueAt(currentRowIndex, 0);
        this.methodTableModel.removeRow(currentRowIndex);
        if (this.methodMap.containsKey(methodName)) {
            this.methodMap.remove(methodName);
        }
    }

    private void addMethodProperties() {
        if (this.methodTable.getRowCount() <= 0) {
            this.assertNoMethodMsg("You must enter a method before entering properties");
            return;
        }
        if (this.methodTable.getSelectedRowCount() <= 0) {
            this.assertNoMethodMsg("You must select a method row before entering properties");
            return;
        }
        if (this.rb_baseURL != null && this.baseURL != null && this.rb_baseURL.isSelected() && this.baseURL.getText().trim().equalsIgnoreCase("")) {
            this.assertNoMethodMsg("You must enter the Base URL for the service before entering method properties");
            return;
        }
        int currentRowIndex = this.methodTable.getSelectedRow();
        String methodName = (String)this.methodTable.getValueAt(currentRowIndex, 0);
        if (methodName == null || methodName.trim().equalsIgnoreCase("")) {
            this.assertNoMethodMsg("You must enter a method name before entering properties");
            return;
        }
        Method m = (Method)this.methodMap.get(methodName);
        MethodPropertiesDialog properties = new MethodPropertiesDialog(this, m.methodName, m.methodProperties);
    }

    private void helpTable() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("The Methods Tab is used to define a 'service contract' which is a set of abstract method definitions.  Define the method names and any user-supplied parameters to those methods.");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Abstract Methods Tab", 0);
    }

    protected void assertNoMethodMsg(String msg) {
        JOptionPane.showMessageDialog(this, new String(msg), "No Method Message", 1);
    }

    protected void assertMethodExistsMsg(String msg) {
        JOptionPane.showMessageDialog(this, new String(msg), "Method Exists Message", 1);
    }

    protected void assertMethodLoadErrorMsg(String msg) {
        JOptionPane.showMessageDialog(this, new String(msg), "Method Loading Problem", 1);
    }

    private List getSDefMethods(String sDefPID) {
        List methodDefs = null;
        try {
            methodDefs = Util.getMethodDefinitions(sDefPID);
        }
        catch (IOException e) {
            this.assertNoMethodMsg("Could not obtain methods from Service Definition object.");
        }
        return methodDefs;
    }

    class BaseURLActionListener
    implements ActionListener {
        BaseURLActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MethodsPane.this.rb_chosen = MethodsPane.this.rb_buttonGroup.getSelection().getActionCommand();
            if (MethodsPane.this.rb_chosen.equalsIgnoreCase("baseURL")) {
                MethodsPane.this.baseURL.setEnabled(true);
            } else if (MethodsPane.this.rb_chosen.equalsIgnoreCase("noBaseURLMS")) {
                MethodsPane.this.baseURL.setEnabled(false);
                MethodsPane.this.baseURL.setText("");
                MethodsPane.this.cleanupMethodURLs();
            } else if (MethodsPane.this.rb_chosen.equalsIgnoreCase("noBaseURL")) {
                MethodsPane.this.baseURL.setEnabled(false);
                MethodsPane.this.baseURL.setText("");
                MethodsPane.this.cleanupMethodURLs();
            }
        }
    }
}

