/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.deployment;

import fedora.client.Administrator;
import fedora.client.deployment.DocumentsPane;
import fedora.client.deployment.GeneralPane;
import fedora.client.deployment.MethodsPane;
import fedora.client.deployment.XMLFileChooserFilter;
import fedora.client.deployment.data.BObjTemplate;
import fedora.client.deployment.data.DCElement;
import fedora.client.deployment.data.Datastream;
import fedora.client.deployment.data.Method;
import fedora.client.deployment.data.MethodParm;
import fedora.client.deployment.xml.DCGenerator;
import fedora.client.deployment.xml.MethodMapGenerator;
import fedora.client.deployment.xml.ServiceDefinitionMETSSerializer;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.common.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ServiceDefinitionBuilder
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private final JTabbedPane tabpane;
    protected BObjTemplate newSDef;
    private File s_lastDir = null;
    private String currentTabName;
    private int currentTabIndex;

    public static void main(String[] args) {
        try {
            if (args.length == 5) {
                JFrame frame = new JFrame("SDefBuilder Test");
                String protocol = args[0];
                String host = args[1];
                int port = new Integer(args[2]);
                String user = args[3];
                String pass = args[4];
                File dir = null;
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                frame.getContentPane().add((Component)new ServiceDefinitionBuilder(protocol, host, port, user, pass, dir), "Center");
                frame.setSize(700, 500);
                frame.setVisible(true);
            } else {
                System.out.println("SDefBuilder main method requires 5 arguments.");
                System.out.println("Usage: SDefBuilder protocol host port user pass");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public ServiceDefinitionBuilder(String protocol, String host, int port, String user, String pass, File dir) {
        super("Service Definition Builder");
        this.s_lastDir = dir;
        this.setClosable(true);
        this.setMaximizable(true);
        this.setSize(700, 500);
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.newSDef = new BObjTemplate();
        this.tabpane = new JTabbedPane();
        this.tabpane.setBackground(Color.GRAY);
        this.tabpane.addTab("General", this.createGeneralPane());
        this.tabpane.addTab("Abstract Methods", this.createMethodsPane());
        this.tabpane.addTab("Documentation", this.createDocPane());
        this.tabpane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ServiceDefinitionBuilder.this.currentTabIndex = ServiceDefinitionBuilder.this.tabpane.getSelectedIndex();
                ServiceDefinitionBuilder.this.currentTabName = ServiceDefinitionBuilder.this.tabpane.getTitleAt(ServiceDefinitionBuilder.this.currentTabIndex);
            }
        });
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDefinitionBuilder.this.save();
            }
        });
        JButton ingest = new JButton("Ingest");
        ingest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDefinitionBuilder.this.ingest();
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDefinitionBuilder.this.showHelp();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceDefinitionBuilder.this.cancel();
            }
        });
        JPanel gbuttonPanel = new JPanel();
        gbuttonPanel.setBackground(Color.WHITE);
        gbuttonPanel.add(save);
        gbuttonPanel.add(ingest);
        gbuttonPanel.add(help);
        gbuttonPanel.add(cancel);
        this.getContentPane().add((Component)this.tabpane, "Center");
        this.getContentPane().add((Component)gbuttonPanel, "South");
        this.setVisible(true);
    }

    public BObjTemplate getBObjTemplate() {
        return this.newSDef;
    }

    public void save() {
        ServiceDefinitionMETSSerializer mets = this.savePanelInfo();
        File file = null;
        if (mets != null) {
            JFileChooser chooser = new JFileChooser(this.s_lastDir);
            chooser.setFileSelectionMode(0);
            XMLFileChooserFilter filter = new XMLFileChooserFilter();
            chooser.setFileFilter(filter);
            if (chooser.showSaveDialog(this.tabpane) == 0) {
                file = chooser.getSelectedFile();
                this.s_lastDir = file.getParentFile();
                String ext = filter.getExtension(file);
                if (ext == null || !ext.equalsIgnoreCase("xml")) {
                    file = new File(file.getPath() + ".xml");
                }
                try {
                    mets.writeMETSFile(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.assertTabPaneMsg("SDefBuilder: Error saving METS file for sdef: " + e.getMessage(), "SDefBuilder");
                }
            } else {
                this.assertTabPaneMsg("SDefBuilder: You did not specify a file to Save.", "SDefBuilder");
            }
        }
    }

    public void ingest() {
        InputStream in = null;
        String pid = null;
        ServiceDefinitionMETSSerializer mets = this.savePanelInfo();
        if (mets != null) {
            try {
                in = mets.writeMETSStream();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("SDefBuilder: Error saving METS to stream for sdef: " + e.getMessage(), "SDefBuilder");
            }
            try {
                AutoIngestor ingestor = new AutoIngestor(Administrator.APIA, Administrator.APIM);
                pid = ingestor.ingestAndCommit(in, Constants.METS_EXT1_1.uri, "ingest sdef object via SDefBuilder tool");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.assertTabPaneMsg("SDefBuilder: error ingesting sdef object: " + e.getMessage(), null);
            }
            this.assertTabPaneMsg("New PID = " + pid, "Successful Ingest");
        }
    }

    public void showHelp() {
        if (this.currentTabIndex == 0) {
            this.showGeneralHelp();
        } else if (this.currentTabIndex == 1) {
            this.showMethodsHelp();
        } else if (this.currentTabIndex == 2) {
            this.showDocumentsHelp();
        }
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public ServiceDefinitionMETSSerializer savePanelInfo() {
        Component[] tabs;
        for (Component element : tabs = this.tabpane.getComponents()) {
            if (element.getName().equalsIgnoreCase("GeneralTab")) {
                if (this.validGeneralTab((GeneralPane)element)) {
                    GeneralPane gp = (GeneralPane)element;
                    if (gp.rb_chosen.equalsIgnoreCase("retainPID")) {
                        this.newSDef.setbObjPID(gp.getBObjectPID());
                    } else {
                        this.newSDef.setbObjPID(null);
                    }
                    this.newSDef.setbObjLabel(gp.getBObjectLabel());
                    this.newSDef.setbObjName(gp.getBObjectName());
                    this.newSDef.setDCRecord(gp.getDCElements());
                    continue;
                }
                return null;
            }
            if (element.getName().equalsIgnoreCase("MethodsTab")) {
                if (this.validMethodsTab((MethodsPane)element)) {
                    MethodsPane mp = (MethodsPane)element;
                    this.newSDef.setMethodsHashMap(mp.getMethodMap());
                    this.newSDef.setMethods(mp.getMethods());
                    continue;
                }
                return null;
            }
            if (!element.getName().equalsIgnoreCase("DocumentsTab")) continue;
            if (this.validDocsTab((DocumentsPane)element)) {
                DocumentsPane docp = (DocumentsPane)element;
                this.newSDef.setDocDatastreams(docp.getDocDatastreams());
                continue;
            }
            return null;
        }
        DCGenerator dcg = null;
        MethodMapGenerator mmg = null;
        try {
            dcg = new DCGenerator(this.newSDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.assertTabPaneMsg("SDefBuilder: error generating dc record.", null);
        }
        try {
            mmg = new MethodMapGenerator(this.newSDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.assertTabPaneMsg("SDefBuilder: error generating method map.", null);
        }
        ServiceDefinitionMETSSerializer mets = null;
        try {
            mets = new ServiceDefinitionMETSSerializer(this.newSDef, dcg.getRootElement(), mmg.getRootElement());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.assertTabPaneMsg("SDefBuilder: error in creating METS for sdef.", null);
        }
        return mets;
    }

    private JComponent createGeneralPane() {
        GeneralPane gpane = new GeneralPane(this);
        gpane.setName("GeneralTab");
        return gpane;
    }

    private JComponent createMethodsPane() {
        MethodsPane mpane = new MethodsPane(this);
        mpane.setName("MethodsTab");
        return mpane;
    }

    private JComponent createDocPane() {
        DocumentsPane docpane = new DocumentsPane();
        docpane.setName("DocumentsTab");
        return docpane;
    }

    private void print() {
        DCElement[] dcrecord;
        System.out.println("FROM GENERAL TAB===============================");
        System.out.println("sDefPID: " + this.newSDef.getbObjPID());
        System.out.println("sDefLabel: " + this.newSDef.getbObjLabel());
        System.out.println("DCRecord: ");
        for (DCElement element : dcrecord = this.newSDef.getDCRecord()) {
            System.out.println(">>> " + element.elementName + "=" + element.elementValue);
        }
        System.out.println("FROM METHODS TAB===============================");
        System.out.println("methods: ");
        HashMap m2 = this.newSDef.getMethodsHashMap();
        Collection methods = m2.values();
        for (Method method : methods) {
            System.out.println("  method name: " + method.methodName + "\n" + "  method desc: " + method.methodLabel + "\n" + "  method URL: " + method.methodProperties.methodFullURL + "\n" + "  method protocol" + method.methodProperties.protocolType + "\n");
            System.out.println("  method parms:");
            for (MethodParm mp : method.methodProperties.methodParms) {
                System.out.println(">>>parmName: " + mp.parmName + "\n" + ">>>parmType: " + mp.parmType + "\n" + ">>>parmLabel: " + mp.parmLabel + "\n" + ">>>parmDefaultValue: " + mp.parmDefaultValue + "\n" + ">>>parmPassBy: " + mp.parmPassBy + "\n" + ">>>parmRequired: " + mp.parmRequired + "\n" + ">>>parmDomainValues: " + mp.parmDomainValues + "\n");
            }
        }
    }

    private boolean validGeneralTab(GeneralPane gp) {
        if (gp.rb_chosen.equalsIgnoreCase("retainPID") && (gp.getBObjectPID() == null || gp.getBObjectPID().trim().equals(""))) {
            this.assertTabPaneMsg("The test PID value is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getBObjectLabel() == null || gp.getBObjectLabel().trim().equals("")) {
            this.assertTabPaneMsg("Service Deployment Label is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getBObjectName() == null || gp.getBObjectName().trim().equals("")) {
            this.assertTabPaneMsg("Service Deployment Nickname is missing on General Tab.", gp.getName());
            return false;
        }
        if (gp.getDCElements().length <= 0) {
            this.assertTabPaneMsg("You must enter at least one DC element on General Tab.", gp.getName());
            return false;
        }
        return true;
    }

    private boolean validMethodsTab(MethodsPane mp) {
        if (mp.getMethods().length <= 0) {
            this.assertTabPaneMsg("You must enter at least one method on AbstractMethods Tab.", mp.getName());
            return false;
        }
        return true;
    }

    private boolean validDocsTab(DocumentsPane docp) {
        Datastream[] docs = docp.getDocDatastreams();
        if (docs.length < 1) {
            this.assertTabPaneMsg(new String("You must enter at least one document that describes the service definition in the Documents Tab."), docp.getName());
            return false;
        }
        for (Datastream element : docs) {
            if (element.dsLabel == null) {
                this.assertTabPaneMsg(new String("You must enter a Label for all documentslisted on the Documents Tab."), docp.getName());
                return false;
            }
            if (element.dsMIMEType != null) continue;
            this.assertTabPaneMsg(new String("You must enter a MIME type for all documentslisted on the Documents Tab."), docp.getName());
            return false;
        }
        return true;
    }

    private void showGeneralHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("There are two sections to the General Tab that must be completed:\n\n Object Description:\n >>> Service Object PID: either select the button for the repository system to generate one, or enter your own with the prefix 'test:' or 'demo:'\n\n >>> Service Object Name:  enter a single word to name the object. This name is used in various places within inline metadata that is generated by the tool.\n\n >>> Service Object Label: enter a meaningful label for theobject.\n\n \n Dublin Core Metadata:\n>>> Enter at least one DC element to describe the Service Definition Object.");
        JOptionPane.showMessageDialog(this, helptxt, "Help for General Tab", 0);
    }

    private void showMethodsHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("The Methods Tab is used to define a 'Service contract' which is a set of abstract method definitions.  Define the method names and any user-supplied parameters to those methods.  Later you will create one or more Service Deployment Objects that define concrete service bindings to fulfill these methods.  Together the 'Service contract' of the Service Definition Object, and the service bindings of a Service Deployment Object will be used to create Disseminators on Fedora Data Objects.");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Abstract Methods Tab", 0);
    }

    private void showDocumentsHelp() {
        JTextArea helptxt = new JTextArea();
        helptxt.setLineWrap(true);
        helptxt.setWrapStyleWord(true);
        helptxt.setBounds(0, 0, 550, 20);
        helptxt.append("insert documents help\n\n");
        helptxt.append("\n\n");
        helptxt.append("\n\n");
        JOptionPane.showMessageDialog(this, helptxt, "Help for Documents Tab", 0);
    }

    private void assertTabPaneMsg(String msg, String tabpane) {
        JOptionPane.showMessageDialog(this, new String(msg), new String(tabpane + " Message"), 1);
    }
}

