/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.ingest;

import fedora.client.Administrator;
import fedora.client.ObjectFormatDialog;
import fedora.client.ingest.SourceRepoDialog;
import fedora.client.utility.ingest.Ingest;
import fedora.client.utility.ingest.IngestCounter;
import fedora.client.utility.ingest.IngestLogger;
import fedora.server.types.gen.RepositoryInfo;
import java.awt.Font;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class IngestDialog {
    public static int ONE_FROM_FILE = 0;
    public static int MULTI_FROM_DIR = 1;
    public static int ONE_FROM_REPOS = 2;
    public static int MULTI_FROM_REPOS = 3;
    private PrintStream log;
    private File logFile;
    private String logRootName;
    IngestCounter counter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IngestDialog(int kind) {
        block25: {
            boolean wasMultiple;
            block24: {
                this.counter = new IngestCounter();
                this.counter.failures = 0;
                this.counter.successes = 0;
                this.log = null;
                this.logFile = null;
                this.logRootName = null;
                wasMultiple = false;
                if (kind == ONE_FROM_FILE) {
                    JFileChooser browse = new JFileChooser(Administrator.getLastDir());
                    int returnVal = browse.showOpenDialog(Administrator.getDesktop());
                    if (returnVal == 0) {
                        File file = browse.getSelectedFile();
                        Administrator.setLastDir(file.getParentFile());
                        ObjectFormatDialog fmtDialog = new ObjectFormatDialog("Select XML Format of Ingest File(s)");
                        if (fmtDialog.getSelection() != null) {
                            String ingestFormat = fmtDialog.getSelection();
                            String pid = Ingest.oneFromFile(file, ingestFormat, Administrator.APIA, Administrator.APIM, null);
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), "Ingest succeeded.  PID='" + pid + "'.");
                        }
                    }
                    break block24;
                }
                if (kind == MULTI_FROM_DIR) {
                    wasMultiple = true;
                    JFileChooser browse = new JFileChooser(Administrator.getLastDir());
                    browse.setFileSelectionMode(1);
                    int returnVal = browse.showOpenDialog(Administrator.getDesktop());
                    if (returnVal == 0) {
                        File file = browse.getSelectedFile();
                        Administrator.setLastDir(file);
                        this.logRootName = "ingest-from-dir";
                        this.logFile = IngestLogger.newLogFile(this.logRootName);
                        this.log = new PrintStream((OutputStream)new FileOutputStream(this.logFile), true, "UTF-8");
                        IngestLogger.openLog(this.log, this.logRootName);
                        long st = System.currentTimeMillis();
                        ObjectFormatDialog fmtDialog = new ObjectFormatDialog("Select XML Format of Ingest File(s)");
                        if (fmtDialog.getSelection() != null) {
                            String ingestFormat = fmtDialog.getSelection();
                            Ingest.multiFromDirectory(file, ingestFormat, Administrator.APIA, Administrator.APIM, null, this.log, this.counter);
                            long et = System.currentTimeMillis();
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), this.counter.successes + " objects successfully ingested.\n" + this.counter.failures + " objects failed.\n" + "Time elapsed: " + Ingest.getDuration(et - st));
                        }
                    }
                    break block24;
                }
                if (kind == ONE_FROM_REPOS) {
                    SourceRepoDialog sdlg = new SourceRepoDialog();
                    if (sdlg.getAPIA() != null) {
                        RepositoryInfo repoinfo = sdlg.getAPIA().describeRepository();
                        String sourceExportFormat = Ingest.getExportFormat(repoinfo);
                        String pid = JOptionPane.showInputDialog("Enter the PID of the object to ingest.");
                        if (pid != null && !pid.equals("")) {
                            pid = Ingest.oneFromRepository(sdlg.getAPIA(), sdlg.getAPIM(), sourceExportFormat, pid, Administrator.APIA, Administrator.APIM, null);
                            JOptionPane.showMessageDialog(Administrator.getDesktop(), "Ingest succeeded.  PID=" + pid);
                        }
                    }
                    break block24;
                }
                if (kind != MULTI_FROM_REPOS) break block24;
                wasMultiple = true;
                SourceRepoDialog sdlg = new SourceRepoDialog();
                if (sdlg.getAPIA() == null) break block24;
                RepositoryInfo repoinfo = sdlg.getAPIA().describeRepository();
                String sourceExportFormat = Ingest.getExportFormat(repoinfo);
                long st = System.currentTimeMillis();
                this.logRootName = "ingest-from-repos";
                this.logFile = IngestLogger.newLogFile(this.logRootName);
                this.log = new PrintStream((OutputStream)new FileOutputStream(this.logFile), true, "UTF-8");
                IngestLogger.openLog(this.log, this.logRootName);
                Ingest.multiFromRepository(sdlg.getProtocol(), sdlg.getHost(), sdlg.getPort(), sdlg.getAPIA(), sdlg.getAPIM(), sourceExportFormat, Administrator.APIA, Administrator.APIM, null, this.log, this.counter);
                long et = System.currentTimeMillis();
                JOptionPane.showMessageDialog(Administrator.getDesktop(), this.counter.successes + " objects successfully ingested.\n" + this.counter.failures + " objects failed.\n" + "Time elapsed: " + Ingest.getDuration(et - st));
            }
            Object var13_27 = null;
            try {
                if (this.log == null || !wasMultiple) break block25;
                IngestLogger.closeLog(this.log, this.logRootName);
                String logPath = this.logFile.getPath();
                int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "A detailed log file was created at\n" + logPath + "\n\n" + "View it now?", "View Ingest Log?", 0);
                if (n != 0) break block25;
                JTextArea textEditor = new JTextArea();
                ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                textEditor.setText(IngestDialog.fileAsString(logPath));
                textEditor.setCaretPosition(0);
                textEditor.setEditable(false);
                JInternalFrame viewFrame = new JInternalFrame("Viewing " + logPath, true, true, true, true);
                viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                viewFrame.getContentPane().add(new JScrollPane(textEditor));
                viewFrame.setSize(720, 520);
                viewFrame.setVisible(true);
                Administrator.getDesktop().add(viewFrame);
                try {
                    viewFrame.setSelected(true);
                    break block25;
                }
                catch (PropertyVetoException pve) {
                }
            }
            catch (Exception ex) {
                Administrator.showErrorDialog(Administrator.getDesktop(), "Error", ex.getMessage(), ex);
            }
            break block25;
            {
                catch (Exception e) {
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.getClass().getName();
                    }
                    e.printStackTrace();
                    Administrator.showErrorDialog(Administrator.getDesktop(), "Ingest Failure", msg, e);
                    Object var13_28 = null;
                    try {
                        if (this.log == null || !wasMultiple) break block25;
                        IngestLogger.closeLog(this.log, this.logRootName);
                        String logPath = this.logFile.getPath();
                        int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "A detailed log file was created at\n" + logPath + "\n\n" + "View it now?", "View Ingest Log?", 0);
                        if (n != 0) break block25;
                        JTextArea textEditor = new JTextArea();
                        ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                        textEditor.setText(IngestDialog.fileAsString(logPath));
                        textEditor.setCaretPosition(0);
                        textEditor.setEditable(false);
                        JInternalFrame viewFrame = new JInternalFrame("Viewing " + logPath, true, true, true, true);
                        viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                        viewFrame.getContentPane().add(new JScrollPane(textEditor));
                        viewFrame.setSize(720, 520);
                        viewFrame.setVisible(true);
                        Administrator.getDesktop().add(viewFrame);
                        try {
                            viewFrame.setSelected(true);
                            break block25;
                        }
                        catch (PropertyVetoException pve) {
                        }
                    }
                    catch (Exception ex) {
                        Administrator.showErrorDialog(Administrator.getDesktop(), "Error", ex.getMessage(), ex);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_29 = null;
                try {
                    if (this.log != null && wasMultiple) {
                        IngestLogger.closeLog(this.log, this.logRootName);
                        String logPath = this.logFile.getPath();
                        int n = JOptionPane.showConfirmDialog(Administrator.getDesktop(), "A detailed log file was created at\n" + logPath + "\n\n" + "View it now?", "View Ingest Log?", 0);
                        if (n == 0) {
                            JTextArea textEditor = new JTextArea();
                            ((JComponent)textEditor).setFont(new Font("monospaced", 0, 12));
                            textEditor.setText(IngestDialog.fileAsString(logPath));
                            textEditor.setCaretPosition(0);
                            textEditor.setEditable(false);
                            JInternalFrame viewFrame = new JInternalFrame("Viewing " + logPath, true, true, true, true);
                            viewFrame.setFrameIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/standard/general/Edit16.gif")));
                            viewFrame.getContentPane().add(new JScrollPane(textEditor));
                            viewFrame.setSize(720, 520);
                            viewFrame.setVisible(true);
                            Administrator.getDesktop().add(viewFrame);
                            try {
                                viewFrame.setSelected(true);
                            }
                            catch (PropertyVetoException pve) {}
                        }
                    }
                }
                catch (Exception ex) {
                    Administrator.showErrorDialog(Administrator.getDesktop(), "Error", ex.getMessage(), ex);
                }
                throw throwable;
            }
        }
    }

    private static String fileAsString(String path) throws Exception {
        int ch;
        StringBuffer buffer = new StringBuffer();
        FileInputStream fis = new FileInputStream(path);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader in = new BufferedReader(isr);
        while ((ch = ((Reader)in).read()) > -1) {
            buffer.append((char)ch);
        }
        ((Reader)in).close();
        return buffer.toString();
    }
}

