/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import fedora.client.objecteditor.ContentHandlerFactory;
import fedora.client.objecteditor.ContentViewer;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class ImageContentViewer
extends ContentViewer {
    private JLabel m_label;
    private JScrollPane m_pane;
    private boolean s_registered;

    public ImageContentViewer() {
        if (!this.s_registered) {
            ContentHandlerFactory.register(this);
            this.s_registered = true;
        }
    }

    public JComponent getComponent() {
        return this.m_pane;
    }

    public String[] getTypes() {
        return new String[]{"image/gif", "image/jpeg", "image/tiff", "image/bmp", "image/x-ms-bmp", "image/x-bitmap", "image/png"};
    }

    public void init(String type, InputStream data, boolean viewOnly) throws IOException {
        this.setContent(data);
    }

    public void setContent(InputStream data) throws IOException {
        try {
            ImageIcon image = new ImageIcon(JAI.create((String)"stream", (Object)new MemoryCacheSeekableStream(data)).getAsBufferedImage());
            if (this.m_pane == null) {
                this.m_label = new JLabel(image);
                this.m_pane = new JScrollPane(this.m_label);
            } else {
                this.m_label.setIcon(image);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

