/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.Administrator;
import fedora.client.objecteditor.ContentEditor;
import fedora.client.objecteditor.ContentHandlerFactory;
import fedora.client.objecteditor.SpringUtilities;
import fedora.client.objecteditor.TupleArrayTripleIterator;
import fedora.common.Constants;
import fedora.common.PID;
import fedora.server.storage.types.RelationshipTuple;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.Triple;
import org.trippi.RDFFormat;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class RDFTupleEditor
extends ContentEditor
implements DocumentListener,
ActionListener,
PropertyChangeListener {
    public static String[] s_types = new String[]{"application/rdf+xml"};
    protected boolean m_dirty;
    protected ActionListener m_dataChangeListener;
    protected JTable m_editor;
    protected JScrollPane m_scrollPane;
    protected JPanel m_component;
    protected RDFDataModel m_origContent;
    protected RDFDataModel m_dataModel;
    protected boolean m_isEditable;
    protected JButton m_add;
    protected JButton m_edit;
    protected JButton m_delete;
    protected String pid;
    protected String dsid;
    protected HashMap<String, String> m_map;
    private static boolean s_registered = false;

    public RDFTupleEditor() {
        if (!s_registered) {
            ContentHandlerFactory.register(this);
            s_registered = true;
        }
    }

    public String[] getTypes() {
        return s_types;
    }

    public void setPIDAndDSID(String pid, String dsid) {
        this.pid = pid;
        this.dsid = dsid;
    }

    public void init(String type, InputStream data, boolean viewOnly) throws IOException {
        this.m_editor = new JTable(){
            private static final long serialVersionUID = 1L;

            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                this.firePropertyChange("selection", e.getFirstIndex(), -1);
            }
        };
        this.m_editor.setFont(new Font("monospaced", 0, 12));
        this.setContent(data);
        this.m_isEditable = !viewOnly;
        this.m_scrollPane = new JScrollPane(this.m_editor);
        this.m_component = new JPanel();
        this.m_component.setLayout(new BorderLayout());
        this.m_component.add((Component)this.m_scrollPane, "Center");
        this.m_editor.addPropertyChangeListener("selection", this);
        this.m_map = new HashMap();
        this.m_map.put(Constants.RELS_EXT.prefix, Constants.RELS_EXT.uri);
        this.m_map.put(Constants.MODEL.prefix, Constants.MODEL.uri);
        this.m_map.put(Constants.RDF.prefix, Constants.RDF.uri);
        if (!viewOnly) {
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 2));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            buttonPane.add(Box.createHorizontalGlue());
            this.m_add = RDFTupleEditor.MakeButton("Add...", this);
            buttonPane.add(this.m_add);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            this.m_edit = RDFTupleEditor.MakeButton("Edit...", this);
            buttonPane.add(this.m_edit);
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
            this.m_delete = RDFTupleEditor.MakeButton("Delete", this);
            buttonPane.add(this.m_delete);
            buttonPane.add(Box.createHorizontalGlue());
            this.m_edit.setEnabled(false);
            this.m_delete.setEnabled(false);
            this.m_component.add((Component)buttonPane, "South");
        }
    }

    private static JButton MakeButton(String label, ActionListener listener) {
        JButton button = new JButton(label);
        button.setActionCommand(label);
        button.addActionListener(listener);
        Administrator.constrainHeight(button);
        return button;
    }

    public void setContent(InputStream data) throws IOException {
        this.m_dataModel = new RDFDataModel(data);
        this.m_editor.setModel(this.m_dataModel);
        if (this.m_origContent == null) {
            this.m_origContent = this.m_dataModel.clone();
        }
    }

    public JComponent getComponent() {
        return this.m_component;
    }

    public void changesSaved() {
        this.m_origContent = this.m_dataModel.clone();
        this.dataChanged();
    }

    public void undoChanges() {
        this.m_dataModel = this.m_origContent.clone();
        this.m_editor.setModel(this.m_dataModel);
        this.dataChanged();
    }

    public boolean isDirty() {
        return !this.m_origContent.serializeAsString().equals(this.m_dataModel.serializeAsString());
    }

    public void setContentChangeListener(ActionListener listener) {
        this.m_dataChangeListener = listener;
    }

    public InputStream getContent() throws IOException {
        return this.m_dataModel.serializeAsStream();
    }

    public void changedUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    private void dataChanged() {
        if (this.m_dataChangeListener != null) {
            this.m_dataChangeListener.actionPerformed(new ActionEvent(this, 0, "dataChanged"));
        }
        this.m_editor.revalidate();
        this.m_editor.repaint();
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        boolean rowSelected = this.m_editor.getSelectedRow() >= 0;
        this.m_edit.setEnabled(rowSelected);
        this.m_delete.setEnabled(rowSelected);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Add...")) {
            TripleEditDialog dialog = new TripleEditDialog(null, this.m_map);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                String subject = dialog.getSubject();
                String predicate = dialog.getPredicate();
                String objectURI = dialog.getObjectURI();
                boolean literalValue = dialog.getIsLiteral();
                String literalType = dialog.getLiteralType();
                this.m_dataModel.addRow(subject, predicate, objectURI, literalValue, literalType);
            }
            dialog = null;
        } else if (e.getActionCommand().equals("Edit...")) {
            if (this.m_editor.getSelectedRow() != -1) {
                TripleEditDialog dialog = new TripleEditDialog(this.m_dataModel.entries.get(this.m_editor.getSelectedRow()), this.m_map);
                dialog.setVisible(true);
                if (!dialog.isCancelled()) {
                    String subject = dialog.getSubject();
                    String predicate = dialog.getPredicate();
                    String objectURI = dialog.getObjectURI();
                    boolean literalValue = dialog.getIsLiteral();
                    String literalType = dialog.getLiteralType();
                    this.m_dataModel.replaceRow(this.m_editor.getSelectedRow(), subject, predicate, objectURI, literalValue, literalType);
                }
                Object var2_3 = null;
            }
        } else if (e.getActionCommand().equals("Delete") && this.m_editor.getSelectedRow() != -1) {
            this.m_dataModel.deleteRow(this.m_editor.getSelectedRow());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TripleEditDialog
    extends JDialog
    implements ActionListener,
    DocumentListener {
        private static final long serialVersionUID = 1L;
        private JTextField m_subject;
        private final JComboBox m_predicate;
        private JTextField m_objectURI;
        private JCheckBox m_isLiteral;
        private JComboBox m_literalType;
        private JLabel lab1;
        private JLabel lab2;
        private JLabel lab3;
        private JLabel lab4;
        private JLabel lab5;
        private boolean cancelled;

        public TripleEditDialog(RelationshipTuple tuple, HashMap<String, String> map) {
            super(Administrator.getInstance(), tuple == null ? "Enter Relationship" : "Edit Relationship", true);
            this.cancelled = true;
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new SpringLayout());
            this.lab1 = new JLabel("Subject:", 4);
            mainPanel.add(this.lab1);
            this.m_subject = new JTextField(tuple != null ? tuple.subject : PID.toURI(RDFTupleEditor.this.pid));
            mainPanel.add(this.m_subject);
            this.m_subject.setBackground(Administrator.BACKGROUND_COLOR);
            this.m_subject.setEditable(false);
            this.lab2 = new JLabel("Predicate:", 4);
            mainPanel.add(this.lab2);
            String[] rels = new String[]{"", "fedora-model:" + Constants.MODEL.HAS_MODEL, "fedora-model:" + Constants.MODEL.HAS_SERVICE, "fedora-model:" + Constants.MODEL.IS_CONTRACTOR_OF, "fedora-model:" + Constants.MODEL.IS_DEPLOYMENT_OF, "rel:" + Constants.RELS_EXT.IS_MEMBER_OF};
            this.m_predicate = new JComboBox<String>(rels);
            this.m_predicate.setEditable(true);
            Administrator.constrainHeight(this.m_predicate);
            mainPanel.add(this.m_predicate);
            this.lab3 = new JLabel("Object:", 4);
            mainPanel.add(this.lab3);
            this.m_objectURI = new JTextField("");
            mainPanel.add(this.m_objectURI);
            this.m_objectURI.getDocument().addDocumentListener(this);
            this.lab4 = new JLabel("isLiteral:", 4);
            mainPanel.add(this.lab4);
            this.m_isLiteral = new JCheckBox();
            mainPanel.add(this.m_isLiteral);
            this.m_isLiteral.setSelected(false);
            this.m_isLiteral.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TripleEditDialog.this.updateFields();
                }
            });
            this.lab5 = new JLabel("      Type:", 4);
            mainPanel.add(this.lab5);
            String[] types = new String[]{"<untyped>", "long", "int", "float", "double", "dateTime"};
            this.m_literalType = new JComboBox<String>(types);
            mainPanel.add(this.m_literalType);
            this.m_literalType.setEditable(false);
            Administrator.constrainHeight(this.m_literalType);
            this.lab3.setLabelFor(this.m_objectURI);
            this.lab4.setLabelFor(this.m_isLiteral);
            this.lab5.setLabelFor(this.m_literalType);
            SpringUtilities.makeCompactGrid(mainPanel, 5, 2, 6, 6, 6, 6);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)mainPanel, "Center");
            JPanel buttonPanel = new JPanel();
            JButton save = RDFTupleEditor.MakeButton("OK", this);
            buttonPanel.add(save);
            save.setDefaultCapable(true);
            this.getRootPane().setDefaultButton(save);
            buttonPanel.add(RDFTupleEditor.MakeButton("Cancel", this));
            this.getContentPane().add((Component)buttonPanel, "South");
            if (tuple != null) {
                this.m_subject.setText(tuple.subject);
                this.m_predicate.setSelectedItem(tuple.getRelationship());
                this.m_objectURI.setText(tuple.object == null ? "" : tuple.object);
                this.m_isLiteral.setSelected(tuple.isLiteral);
                String trimmedDataType = null;
                trimmedDataType = tuple.datatype == null ? "<untyped>" : (tuple.datatype.startsWith(Constants.XML_XSD.uri + "#") ? tuple.datatype.substring(Constants.XML_XSD.uri.length() + 1) : tuple.datatype);
                this.m_literalType.setSelectedItem(trimmedDataType);
                if (this.m_isLiteral.isSelected()) {
                    this.m_literalType.setEnabled(true);
                } else {
                    this.m_literalType.setEnabled(false);
                }
            }
            this.validate();
            this.pack();
            this.setLocationRelativeTo(Administrator.getInstance());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand().equals("OK")) {
                String msg = "predicate";
                try {
                    URI uriSub = new URI(this.m_subject.getText());
                    TupleArrayTripleIterator.makePredicateResourceFromRel(this.getPredicate(), RDFTupleEditor.this.m_map);
                    msg = "object";
                    TupleArrayTripleIterator.makeObjectFromURIandLiteral(this.getObjectURI(), this.getIsLiteral(), this.getLiteralType());
                }
                catch (URISyntaxException e) {
                    JOptionPane.showMessageDialog(this, "Error: Invalid URI in " + msg);
                    return;
                }
                catch (IllegalArgumentException e) {
                    JOptionPane.showMessageDialog(this, "Error: Invalid URI in " + msg);
                    return;
                }
                this.cancelled = false;
                this.setVisible(false);
            }
            if (arg0.getActionCommand().equals("Cancel")) {
                this.cancelled = true;
                this.setVisible(false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.updateFields();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.updateFields();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.updateFields();
        }

        public void updateFields() {
            if (this.m_isLiteral.isSelected()) {
                this.m_literalType.setEnabled(true);
            } else {
                this.m_literalType.setEnabled(false);
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public String getLiteralType() {
            if (!this.getIsLiteral()) {
                return null;
            }
            if (this.m_literalType.getSelectedItem().toString().equals("<untyped>")) {
                return null;
            }
            String litType = this.m_literalType.getSelectedItem().toString();
            if (litType.startsWith(Constants.XML_XSD.uri)) {
                return litType;
            }
            return Constants.XML_XSD.uri + "#" + litType;
        }

        public boolean getIsLiteral() {
            return this.m_isLiteral.isSelected();
        }

        public String getObjectURI() {
            if (this.m_objectURI.getText().length() == 0) {
                return null;
            }
            return this.m_objectURI.getText();
        }

        public String getPredicate() {
            String predicate = this.m_predicate.getSelectedItem().toString();
            if (predicate.startsWith(Constants.RELS_EXT.prefix)) {
                predicate = Constants.RELS_EXT.uri + predicate.substring(Constants.RELS_EXT.prefix.length() + 1);
            } else if (predicate.startsWith(Constants.MODEL.prefix)) {
                predicate = Constants.MODEL.uri + predicate.substring(Constants.MODEL.prefix.length() + 1);
            }
            return predicate;
        }

        public String getSubject() {
            return this.m_subject.getText();
        }
    }

    class RDFDataModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] columnNames = new String[]{"Subject", "Predicate", "Object"};
        ArrayList<RelationshipTuple> entries = null;

        private RDFDataModel() {
        }

        public RDFDataModel(InputStream data) {
            try {
                TripleIterator iter = TripleIterator.fromStream((InputStream)data, (RDFFormat)RDFFormat.RDF_XML);
                this.entries = new ArrayList();
                int i = 0;
                while (iter.hasNext()) {
                    Triple triple = iter.next();
                    String object = null;
                    boolean isLiteral = false;
                    String datatype = null;
                    ObjectNode oNode = triple.getObject();
                    if (oNode instanceof Literal) {
                        isLiteral = true;
                        URI typeURI = ((Literal)oNode).getDatatypeURI();
                        datatype = typeURI == null ? null : typeURI.toString();
                    }
                    object = oNode.toString();
                    this.entries.add(new RelationshipTuple(triple.getSubject().toString(), triple.getPredicate().toString(), object, isLiteral, datatype));
                    ++i;
                }
            }
            catch (TrippiException e) {
                e.printStackTrace();
            }
        }

        public RDFDataModel clone() {
            RDFDataModel clone = new RDFDataModel();
            clone.entries = (ArrayList)this.entries.clone();
            return clone;
        }

        public void deleteRow(int i) {
            this.entries.remove(i);
            RDFTupleEditor.this.dataChanged();
        }

        public void addRow(String subject, String predicate, String object, boolean isLiteral, String datatype) {
            this.entries.add(new RelationshipTuple(subject, predicate, object, isLiteral, datatype));
            RDFTupleEditor.this.dataChanged();
        }

        public void replaceRow(int selectedRow, String subject, String predicate, String object, boolean isLiteral, String datatype) {
            this.entries.set(selectedRow, new RelationshipTuple(subject, predicate, object, isLiteral, datatype));
            RDFTupleEditor.this.dataChanged();
        }

        public InputStream serializeAsStream() {
            TupleArrayTripleIterator iter = new TupleArrayTripleIterator(this.entries);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                iter.toStream(os, RDFFormat.RDF_XML, false);
            }
            catch (TrippiException e) {
                e.printStackTrace();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            return is;
        }

        public String serializeAsString() {
            TupleArrayTripleIterator iter = new TupleArrayTripleIterator(this.entries);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                iter.toStream(os, RDFFormat.RDF_XML, false);
            }
            catch (TrippiException e) {
                e.printStackTrace();
            }
            String results = new String(os.toByteArray());
            return results;
        }

        public Object getValueAt(int iRowIndex, int iColumnIndex) {
            RelationshipTuple tuple = this.entries.get(iRowIndex);
            switch (iColumnIndex) {
                case 0: {
                    return tuple.subject;
                }
                case 1: {
                    return tuple.getRelationship();
                }
                case 2: {
                    if (tuple.isLiteral) {
                        if (tuple.datatype == null) {
                            return String.format("\"%s\"", tuple.object);
                        }
                        String trimmedDataType = tuple.datatype;
                        if (tuple.datatype.startsWith(Constants.XML_XSD.uri + "#")) {
                            trimmedDataType = tuple.datatype.substring(Constants.XML_XSD.uri.length() + 1);
                        }
                        return String.format("\"%s\"^^<%s>", tuple.object, trimmedDataType);
                    }
                    return tuple.object;
                }
            }
            return "";
        }

        public void setValueAt(Object aValue, int iRowIndex, int iColumnIndex) {
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int i) {
            return this.columnNames[i];
        }

        public int getRowCount() {
            return this.entries.size();
        }
    }
}

