/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.objecteditor.ContentHandlerFactory;
import fedora.client.objecteditor.ContentViewer;
import fedora.server.utilities.StreamUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import org.apache.batik.swing.JSVGCanvas;

public class SVGContentViewer
extends ContentViewer {
    private JSVGCanvas m_svgCanvas;
    private boolean s_registered;

    public SVGContentViewer() {
        if (!this.s_registered) {
            ContentHandlerFactory.register(this);
            this.s_registered = true;
        }
    }

    public JComponent getComponent() {
        return this.m_svgCanvas;
    }

    public String[] getTypes() {
        return new String[]{"image/svg+xml"};
    }

    public void init(String type, InputStream data, boolean viewOnly) throws IOException {
        this.setContent(data);
    }

    public void setContent(InputStream data) throws IOException {
        try {
            File tempFile = File.createTempFile("fedora-view-svg-", null);
            tempFile.deleteOnExit();
            StreamUtility.pipeStream(data, new FileOutputStream(tempFile), 4096);
            if (this.m_svgCanvas == null) {
                this.m_svgCanvas = new JSVGCanvas();
                this.m_svgCanvas.setDocumentState(1);
                this.m_svgCanvas.setURI(tempFile.toURL().toString());
            } else {
                this.m_svgCanvas.setURI(tempFile.toURL().toString());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }
}

