/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.objecteditor;

import fedora.client.objecteditor.ContentEditor;
import fedora.client.objecteditor.ContentHandlerFactory;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TextContentEditor
extends ContentEditor
implements DocumentListener {
    public static String[] s_types = new String[]{"text/xml", "text/plain", "text/html", "text/css", "text/html", "text/sgml", "text/tab-separated-values", "text/xml-external-parsed-entity", "application/xml"};
    protected boolean m_dirty;
    protected ActionListener m_dataChangeListener;
    protected JTextComponent m_editor;
    protected JScrollPane m_component;
    protected boolean m_xml = false;
    protected String m_origContent;
    private static boolean s_registered = false;

    public TextContentEditor() {
        if (!s_registered) {
            ContentHandlerFactory.register(this);
            s_registered = true;
        }
    }

    public String[] getTypes() {
        return s_types;
    }

    public void init(String type, InputStream data, boolean viewOnly) throws IOException {
        if (type.endsWith("xml")) {
            this.m_xml = true;
        }
        this.m_editor = new JTextArea();
        this.m_editor.setFont(new Font("monospaced", 0, 12));
        this.setContent(data);
        this.m_editor.setEditable(!viewOnly);
        this.m_component = new JScrollPane(this.m_editor);
    }

    public void setXML(boolean isXML) {
        this.m_xml = isXML;
    }

    public void setContent(InputStream data) throws IOException {
        String content;
        if (this.m_xml) {
            try {
                OutputFormat fmt = new OutputFormat("XML", "UTF-8", true);
                fmt.setOmitXMLDeclaration(true);
                fmt.setIndent(2);
                fmt.setLineWidth(120);
                fmt.setPreserveSpace(false);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                XMLSerializer ser = new XMLSerializer((OutputStream)buf, fmt);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(data);
                ser.serialize(doc);
                content = new String(buf.toByteArray(), "UTF-8");
            }
            catch (Exception e) {
                throw new IOException("Error parsing as XML: " + e.getMessage());
            }
        } else {
            String thisLine;
            StringBuffer out = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(data));
            while ((thisLine = in.readLine()) != null) {
                out.append(thisLine + "\n");
            }
            in.close();
            content = out.toString();
        }
        this.m_editor.setText(content);
        this.m_editor.setCaretPosition(0);
        if (this.m_origContent == null) {
            this.m_origContent = content;
        }
    }

    public JComponent getComponent() {
        return this.m_component;
    }

    public void changesSaved() {
        this.m_origContent = this.m_editor.getText();
        this.dataChanged();
    }

    public void undoChanges() {
        this.m_editor.setText(this.m_origContent);
        this.m_editor.setCaretPosition(0);
        this.dataChanged();
    }

    public boolean isDirty() {
        return !this.m_origContent.equals(this.m_editor.getText());
    }

    public void setContentChangeListener(ActionListener listener) {
        this.m_dataChangeListener = listener;
        this.m_editor.getDocument().addDocumentListener(this);
    }

    public InputStream getContent() throws IOException {
        try {
            if (this.m_xml) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(new InputSource(new StringReader(this.m_editor.getText())));
            }
            return new ByteArrayInputStream(this.m_editor.getText().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void insertUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.dataChanged();
    }

    private void dataChanged() {
        if (this.m_dataChangeListener != null) {
            this.m_dataChangeListener.actionPerformed(new ActionEvent(this, 0, "dataChanged"));
        }
    }
}

