/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultParser
extends DefaultHandler {
    private boolean READING_PID;
    private boolean READING_TOKEN;
    private StringBuffer m_currentPID;
    private StringBuffer m_sessionToken;
    private final Set<String> m_pids = new HashSet<String>();

    public SearchResultParser(InputStream xml) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(xml, (DefaultHandler)this);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                throw new IOException(e.getMessage());
            }
            throw new IOException("Error parsing search result xml: " + e.getClass().getName());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes a) {
        if (localName.equals("pid")) {
            this.READING_PID = true;
            this.m_currentPID = new StringBuffer();
        } else if (localName.equals("token")) {
            this.READING_TOKEN = true;
            this.m_sessionToken = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.READING_PID) {
            this.m_currentPID.append(ch, start, length);
        } else if (this.READING_TOKEN) {
            this.m_sessionToken.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("pid")) {
            this.READING_PID = false;
            this.m_pids.add(this.m_currentPID.toString());
        } else if (localName.equals("token")) {
            this.READING_TOKEN = false;
        }
    }

    public Set<String> getPIDs() {
        return this.m_pids;
    }

    public String getToken() {
        if (this.m_sessionToken == null) {
            return null;
        }
        return this.m_sessionToken.toString();
    }
}

