/*
 * Decompiled with CFR 0.152.
 */
package fedora.client.test;

import fedora.client.FedoraClient;
import fedora.client.utility.ingest.AutoIngestor;
import fedora.oai.sample.RandomDCMetadataFactory;
import fedora.server.access.FedoraAPIA;
import fedora.server.management.FedoraAPIM;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;

public class MassIngest {
    public static FedoraAPIA APIA = null;
    public static FedoraAPIM APIM = null;

    public MassIngest(AutoIngestor ingestor, File templateFile, File dictFile, String format, int numTimes) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(templateFile));
        String nextLine = "";
        StringBuffer startBuffer = new StringBuffer();
        StringBuffer endBuffer = new StringBuffer();
        boolean seenSplitter = false;
        while (nextLine != null) {
            nextLine = in.readLine();
            if (nextLine == null) continue;
            if (!seenSplitter) {
                if (nextLine.startsWith("##SPLITTER##")) {
                    seenSplitter = true;
                    continue;
                }
                startBuffer.append(nextLine + "\n");
                continue;
            }
            endBuffer.append(nextLine + "\n");
        }
        in.close();
        String start = startBuffer.toString();
        String end = endBuffer.toString();
        RandomDCMetadataFactory dcFactory = new RandomDCMetadataFactory(dictFile);
        for (int i = 0; i < numTimes; ++i) {
            String xml = start + dcFactory.get(2, 13) + end;
            String pid = ingestor.ingestAndCommit(new ByteArrayInputStream(xml.getBytes("UTF-8")), format, "part of massingest of " + numTimes + " auto-generated objects.");
            int t = i + 1;
            System.out.println(pid + " " + t + "/" + numTimes);
        }
    }

    public static void showUsage(String message) {
        System.out.println("ERROR: " + message);
        System.out.println("Usage: MassIngest host port username password templateFile dictionaryFile format numTimes protocol");
    }

    public static void main(String[] args) throws Exception {
        try {
            if (args.length != 9) {
                MassIngest.showUsage("You must provide nine arguments.");
            } else {
                String hostName = args[0];
                int portNum = Integer.parseInt(args[1]);
                String username = args[2];
                String password = args[3];
                File dictFile = new File(args[5]);
                String format = args[6];
                File f = new File(args[4]);
                String protocol = args[8];
                String baseURL = protocol + "://" + hostName + ":" + portNum + "/fedora";
                FedoraClient fc = new FedoraClient(baseURL, username, password);
                APIA = fc.getAPIA();
                APIM = fc.getAPIM();
                AutoIngestor autoIngestor = new AutoIngestor(APIA, APIM);
                MassIngest m = new MassIngest(autoIngestor, f, dictFile, format, Integer.parseInt(args[7]));
            }
        }
        catch (Exception e) {
            MassIngest.showUsage(e.getClass().getName() + " - " + (e.getMessage() == null ? "(no detail provided)" : e.getMessage()));
        }
    }
}

