/*
 * Decompiled with CFR 0.152.
 */
package fedora.common;

import fedora.common.Constants;
import fedora.common.MalformedPIDException;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class PID {
    public static final int MAX_LENGTH = 64;
    public static final String NS_HANDLE = "hdl";
    private final String m_normalized;
    private final String m_namespaceId;
    private final String m_objectId;
    private String m_filename;

    public PID(String pidString) throws MalformedPIDException {
        if (pidString.startsWith(Constants.FEDORA.uri)) {
            pidString = pidString.substring(Constants.FEDORA.uri.length());
        }
        this.m_normalized = PID.normalize(pidString);
        String[] split = this.m_normalized.split(":");
        this.m_namespaceId = split[0];
        this.m_objectId = split[1];
    }

    public static PID getInstance(String pidString) {
        try {
            return new PID(pidString);
        }
        catch (MalformedPIDException e) {
            throw new RuntimeException("Malformed PID: " + e.getMessage(), e);
        }
    }

    public static PID fromFilename(String filenameString) throws MalformedPIDException {
        String decoded = filenameString.replaceFirst("_", ":");
        if (decoded.endsWith("%")) {
            decoded = decoded.substring(0, decoded.length() - 1) + ".";
        }
        return new PID(decoded);
    }

    public static String normalize(String pidString) throws MalformedPIDException {
        if (pidString == null) {
            throw new MalformedPIDException("PID is null.");
        }
        StringBuffer out = new StringBuffer();
        boolean inObjectID = false;
        for (int i = 0; i < pidString.length(); ++i) {
            char c = pidString.charAt(i);
            if (!inObjectID) {
                if (c == ':') {
                    out.append(':');
                    inObjectID = true;
                    continue;
                }
                if (c == '%') {
                    if (pidString.length() >= i + 3) {
                        if (pidString.charAt(++i) == '3') {
                            if ((c = pidString.charAt(++i)) == 'a' || c == 'A') {
                                out.append(":");
                                inObjectID = true;
                                continue;
                            }
                            throw new MalformedPIDException("Error in PID after first '%': expected '3a' or '3A', but saw '3" + c + "'.");
                        }
                        throw new MalformedPIDException("Error in PID after first '%': expected '3a' or '3A', but saw '" + pidString.substring(i, i + 2) + "'.");
                    }
                    throw new MalformedPIDException("Error in PID after first '%': expected '3a' or '3A', but saw '" + pidString.substring(i + 1) + "'.");
                }
                if (PID.isAlphaNum(c) || c == '-' || c == '.') {
                    out.append(c);
                    continue;
                }
                throw new MalformedPIDException("PID namespace-id cannot contain '" + c + "' character.");
            }
            if (PID.isAlphaNum(c) || c == '-' || c == '.' || c == '~' || c == '_') {
                out.append(c);
                continue;
            }
            if (c == '%') {
                if (pidString.length() >= i + 3) {
                    char h1 = PID.getNormalizedHexChar(pidString.charAt(++i));
                    char h2 = PID.getNormalizedHexChar(pidString.charAt(++i));
                    out.append("%" + h1 + h2);
                    continue;
                }
                throw new MalformedPIDException("PID object-id ended early: need at least 2 chars after '%'.");
            }
            throw new MalformedPIDException("PID object-id cannot contain '" + c + "' character.");
        }
        if (!inObjectID) {
            throw new MalformedPIDException("PID delimiter (:) is missing.");
        }
        String outString = out.toString();
        if (outString.startsWith(":")) {
            throw new MalformedPIDException("PID namespace-id cannot be empty.");
        }
        if (outString.length() < 3) {
            throw new MalformedPIDException("PID object-id cannot be empty.");
        }
        if (outString.length() > 64) {
            throw new MalformedPIDException("PID length exceeds 64.");
        }
        return outString;
    }

    private static boolean isAlphaNum(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static char getNormalizedHexChar(char c) throws MalformedPIDException {
        if (c >= '0' && c <= '9') {
            return c;
        }
        c = ("" + c).toUpperCase().charAt(0);
        if (c >= 'A' && c <= 'F') {
            return c;
        }
        throw new MalformedPIDException("Bad hex-digit in PID object-id: " + c);
    }

    public String toString() {
        return this.m_normalized;
    }

    public String toURI() {
        return Constants.FEDORA.uri + this.m_normalized;
    }

    public static String toURI(String pidString) {
        return Constants.FEDORA.uri + pidString;
    }

    public String toFilename() {
        if (this.m_filename == null) {
            this.m_filename = this.m_normalized.replaceAll(":", "_");
            if (this.m_filename.endsWith(".")) {
                this.m_filename = this.m_filename.substring(0, this.m_filename.length() - 1) + "%";
            }
        }
        return this.m_filename;
    }

    public String getNamespaceId() {
        return this.m_namespaceId;
    }

    public String getObjectId() {
        return this.m_objectId;
    }

    public boolean equals(Object o) {
        return o instanceof PID && this.m_normalized.equals(((PID)o).toString());
    }

    public int hashCode() {
        return this.m_normalized.hashCode();
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            PID p = new PID(args[0]);
            System.out.println("Normalized    : " + p.toString());
            System.out.println("To filename   : " + p.toFilename());
            System.out.println("From filename : " + PID.fromFilename(p.toFilename()).toString());
        } else {
            System.out.println("--------------------------------------");
            System.out.println("PID Syntax Checker - Interactive mode");
            System.out.println("--------------------------------------");
            boolean done = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (!done) {
                try {
                    System.out.print("Enter a PID (ENTER to exit): ");
                    String line = reader.readLine();
                    if (line.equals("")) {
                        done = true;
                        continue;
                    }
                    PID p = new PID(line);
                    System.out.println("Normalized    : " + p.toString());
                    System.out.println("To filename   : " + p.toFilename());
                    System.out.println("From filename : " + PID.fromFilename(p.toFilename()).toString());
                }
                catch (MalformedPIDException e) {
                    System.out.println("ERROR: " + e.getMessage());
                }
            }
        }
    }
}

