/*
 * Decompiled with CFR 0.152.
 */
package fedora.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Log4J {
    public static void force() {
        System.setProperty("org.apache.commons.logging.LogFactory", "org.apache.commons.logging.impl.Log4jFactory");
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
    }

    public static void initFromPropFile(File propFile, Map<String, String> options) throws IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propFile));
        if (options != null) {
            for (String name : options.keySet()) {
                String value = options.get(name);
                if (props.containsKey(name)) continue;
                props.setProperty(name, value);
            }
        }
        PropertyConfigurator.configure((Properties)props);
    }

    public static void initFromXMLFile(File xmlFile) throws IOException {
        if (!xmlFile.exists()) {
            throw new FileNotFoundException(xmlFile.getPath());
        }
        DOMConfigurator.configure((String)xmlFile.getPath());
    }
}

