/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestCase;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.Graph;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.jrdf.util.ClosableIterator;

public abstract class AbstractGraphElementFactoryUnitTest
extends TestCase {
    private GraphElementFactory elementFactory;
    private Graph graph;

    public AbstractGraphElementFactoryUnitTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        this.graph = this.newGraph();
        this.elementFactory = this.graph.getElementFactory();
    }

    public static Test suite() {
        return null;
    }

    public abstract Graph newGraph() throws Exception;

    public abstract URI getDefaultLiteralType();

    public abstract String getDefaultLiteralLanguage();

    public void testCreateLiterals() throws Exception {
        Literal literal = this.elementFactory.createLiteral("A test string");
        Literal literal2 = this.elementFactory.createLiteral("Another test string");
        Literal literal3 = this.elementFactory.createLiteral("A test string");
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)literal).equals(literal2));
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)literal, (Object)literal3);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)this.getDefaultLiteralType(), (Object)literal.getDatatypeURI());
        AbstractGraphElementFactoryUnitTest.assertEquals((String)this.getDefaultLiteralLanguage(), (String)literal.getLanguage());
        AbstractGraphElementFactoryUnitTest.assertEquals((String)"A test string", (String)literal.getLexicalForm());
        literal = this.elementFactory.createLiteral("A test string", "it");
        literal2 = this.elementFactory.createLiteral("Another test string", "it");
        literal3 = this.elementFactory.createLiteral("A test string", "it");
        Literal literal4 = this.elementFactory.createLiteral("A test string");
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)literal).equals(literal2));
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)literal).equals(literal4));
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)literal, (Object)literal3);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)this.getDefaultLiteralType(), (Object)literal.getDatatypeURI());
        AbstractGraphElementFactoryUnitTest.assertEquals((String)"it", (String)literal.getLanguage());
        AbstractGraphElementFactoryUnitTest.assertEquals((String)"A test string", (String)literal.getLexicalForm());
        URI uRI = new URI("xsd:long");
        literal = this.elementFactory.createLiteral("42", uRI);
        literal2 = this.elementFactory.createLiteral("0", uRI);
        literal3 = this.elementFactory.createLiteral("42", uRI);
        literal4 = this.elementFactory.createLiteral("42");
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)literal).equals(literal2));
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)literal).equals(literal4));
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)literal, (Object)literal3);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)uRI, (Object)literal.getDatatypeURI());
        AbstractGraphElementFactoryUnitTest.assertEquals((String)this.getDefaultLiteralLanguage(), (String)literal.getLanguage());
        AbstractGraphElementFactoryUnitTest.assertEquals((String)"42", (String)literal.getLexicalForm());
    }

    public void testCreateResources() throws Exception {
        BlankNode blankNode = this.elementFactory.createResource();
        BlankNode blankNode2 = this.elementFactory.createResource();
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)blankNode).equals(blankNode2));
        URI uRI = new URI("http://namespace#somevalue");
        URI uRI2 = new URI("http://namespace#someothervalue");
        URIReference uRIReference = this.elementFactory.createResource(uRI);
        URIReference uRIReference2 = this.elementFactory.createResource(uRI2);
        URIReference uRIReference3 = this.elementFactory.createResource(uRI);
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)uRIReference).equals(uRIReference2));
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)uRIReference, (Object)uRIReference3);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)uRIReference.getURI(), (Object)uRI);
    }

    public void testCreateTriples() throws Exception {
        BlankNode blankNode = this.elementFactory.createResource();
        BlankNode blankNode2 = this.elementFactory.createResource();
        URI uRI = new URI("http://namespace#somevalue");
        URI uRI2 = new URI("http://namespace#someothervalue");
        URI uRI3 = new URI("http://namespace#yetanothervalue");
        URIReference uRIReference = this.elementFactory.createResource(uRI);
        URIReference uRIReference2 = this.elementFactory.createResource(uRI2);
        URIReference uRIReference3 = this.elementFactory.createResource(uRI3);
        Literal literal = this.elementFactory.createLiteral("A test string");
        Literal literal2 = this.elementFactory.createLiteral("Another test string");
        Triple triple = this.elementFactory.createTriple(blankNode, uRIReference, blankNode2);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)blankNode, (Object)triple.getSubject());
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)uRIReference, (Object)triple.getPredicate());
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)blankNode2, (Object)triple.getObject());
        Triple triple2 = this.elementFactory.createTriple(blankNode2, uRIReference, blankNode2);
        AbstractGraphElementFactoryUnitTest.assertFalse((boolean)((Object)triple).equals(triple2));
        triple2 = this.elementFactory.createTriple(blankNode, uRIReference, blankNode2);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)triple, (Object)triple2);
        triple = this.elementFactory.createTriple(blankNode, uRIReference, literal);
        triple = this.elementFactory.createTriple(blankNode, uRIReference, literal);
        triple = this.elementFactory.createTriple(uRIReference, uRIReference2, literal);
        triple = this.elementFactory.createTriple(uRIReference, uRIReference2, blankNode);
        this.graph.add(triple);
        this.graph.add(uRIReference2, uRIReference, literal);
        URIReference uRIReference4 = this.elementFactory.createResource(uRI);
        URIReference uRIReference5 = this.elementFactory.createResource(uRI2);
        Literal literal3 = this.elementFactory.createLiteral("A test string");
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)uRIReference4, (Object)uRIReference);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)uRIReference5, (Object)uRIReference2);
        AbstractGraphElementFactoryUnitTest.assertEquals((Object)literal, (Object)literal3);
        AbstractGraphElementFactoryUnitTest.assertEquals((String)literal.getEscapedForm(), (String)literal3.getEscapedForm());
        AbstractGraphElementFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference4, uRIReference5, blankNode));
        ClosableIterator closableIterator = this.graph.find(uRIReference2, uRIReference, null);
        while (closableIterator.hasNext()) {
            triple = (Triple)closableIterator.next();
            AbstractGraphElementFactoryUnitTest.assertEquals((Object)literal, (Object)triple.getObject());
            AbstractGraphElementFactoryUnitTest.assertTrue((((Object)literal).hashCode() == triple.getObject().hashCode() ? 1 : 0) != 0);
            AbstractGraphElementFactoryUnitTest.assertEquals((Object)literal3, (Object)triple.getObject());
            AbstractGraphElementFactoryUnitTest.assertTrue((((Object)literal3).hashCode() == triple.getObject().hashCode() ? 1 : 0) != 0);
        }
        AbstractGraphElementFactoryUnitTest.assertTrue((boolean)this.graph.find(uRIReference2, uRIReference, literal).hasNext());
        AbstractGraphElementFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference2, uRIReference, literal));
        AbstractGraphElementFactoryUnitTest.assertTrue((boolean)this.graph.find(uRIReference5, uRIReference4, literal3).hasNext());
        AbstractGraphElementFactoryUnitTest.assertTrue((boolean)this.graph.contains(uRIReference5, uRIReference4, literal3));
    }

    public void testTwoGraphs() throws Exception {
        Graph graph = this.newGraph();
        Graph graph2 = this.newGraph();
        URI uRI = new URI("http://namespace#somevalue1");
        URI uRI2 = new URI("http://namespace#somevalue2");
        URI uRI3 = new URI("http://namespace#foo");
        GraphElementFactory graphElementFactory = graph.getElementFactory();
        URIReference uRIReference = graphElementFactory.createResource(uRI);
        URIReference uRIReference2 = graphElementFactory.createResource(uRI2);
        URIReference uRIReference3 = graphElementFactory.createResource(uRI3);
        GraphElementFactory graphElementFactory2 = graph2.getElementFactory();
        Literal literal = graphElementFactory2.createLiteral("A test string");
        Literal literal2 = graphElementFactory2.createLiteral("Foo 2");
        URIReference uRIReference4 = graphElementFactory2.createResource(uRI2);
        boolean bl = false;
        try {
            graph2.add(uRIReference, uRIReference, literal);
        }
        catch (GraphException graphException) {
            bl = true;
        }
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Should fail to insert node", (boolean)bl);
        bl = false;
        try {
            graph2.add(uRIReference4, uRIReference, literal);
        }
        catch (GraphException graphException) {
            bl = true;
        }
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Should fail to insert node", (boolean)bl);
        bl = false;
        try {
            graph2.add(uRIReference4, uRIReference, literal2);
        }
        catch (GraphException graphException) {
            bl = true;
        }
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Should fail to insert node", (boolean)bl);
        try {
            graph2.add(uRIReference4, uRIReference2, uRIReference2);
            AbstractGraphElementFactoryUnitTest.assertTrue((String)"Should contain the statemet", (boolean)graph2.contains(uRIReference4, uRIReference4, uRIReference4));
        }
        catch (GraphException graphException) {
            AbstractGraphElementFactoryUnitTest.fail((String)"Should allow nodes to be inserted from other graphs which have the same value but different node ids");
        }
        URIReference uRIReference5 = graphElementFactory2.createResource(uRI3);
        graph2.add(uRIReference5, uRIReference5, uRIReference5);
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Contains should work by value", (boolean)graph2.contains(uRIReference3, uRIReference3, uRIReference3));
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Find should work by value", (boolean)graph2.find(uRIReference3, uRIReference3, uRIReference3).hasNext());
        ClosableIterator closableIterator = graph2.find(uRIReference5, null, null);
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Should get back at least one result", (boolean)closableIterator.hasNext());
        closableIterator = graph2.find(null, null, null);
        AbstractGraphElementFactoryUnitTest.assertTrue((String)"Should get back at least one result", (boolean)closableIterator.hasNext());
    }
}

