/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph;

import java.net.URI;
import org.jrdf.graph.TypedNodeVisitor;
import org.jrdf.graph.URIReference;

public abstract class AbstractURIReference
implements URIReference {
    protected URI uri;

    protected AbstractURIReference(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("Null \"uri\" parameter");
        }
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("\"" + uRI + "\" is not absolute");
        }
        this.uri = uRI;
    }

    protected AbstractURIReference(URI uRI, boolean bl) {
        if (uRI == null) {
            throw new IllegalArgumentException("Null \"uri\" parameter");
        }
        if (bl && !uRI.isAbsolute()) {
            throw new IllegalArgumentException("\"" + uRI + "\" is not absolute");
        }
        this.uri = uRI;
    }

    public URI getURI() {
        return this.uri;
    }

    public void accept(TypedNodeVisitor typedNodeVisitor) {
        typedNodeVisitor.visitURIReference(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object != null) {
            try {
                URIReference uRIReference = (URIReference)object;
                bl = this.getURI().equals(uRIReference.getURI());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.uri.toString();
    }
}

