/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.mem.GraphElementFactoryImpl;
import org.jrdf.graph.mem.GraphImpl;
import org.jrdf.graph.mem.TripleImpl;
import org.jrdf.util.ClosableIterator;

public class GraphIterator
implements ClosableIterator {
    private Iterator iterator;
    private Iterator subIterator;
    private Iterator itemIterator;
    private Map.Entry firstEntry;
    private Map.Entry secondEntry;
    private GraphImpl graph;
    private Map index;
    private Long[] currentNodes;
    private GraphElementFactoryImpl nodeFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    GraphIterator(Map map, GraphElementFactoryImpl graphElementFactoryImpl, GraphImpl graphImpl) {
        this.nodeFactory = graphElementFactoryImpl;
        this.graph = graphImpl;
        this.index = map;
        this.currentNodes = null;
        this.itemIterator = null;
        this.subIterator = null;
        this.iterator = map.entrySet().iterator();
    }

    public boolean hasNext() {
        return this.itemIterator != null && this.itemIterator.hasNext() || this.subIterator != null && this.subIterator.hasNext() || this.iterator != null && this.iterator.hasNext();
    }

    public Object next() throws NoSuchElementException {
        if (this.iterator == null) {
            throw new NoSuchElementException();
        }
        this.updatePosition();
        if (this.iterator == null) {
            throw new NoSuchElementException();
        }
        Long l = (Long)this.itemIterator.next();
        Long l2 = (Long)this.secondEntry.getKey();
        Long l3 = (Long)this.firstEntry.getKey();
        this.currentNodes = new Long[]{l3, l2, l};
        return new TripleImpl(this.nodeFactory, l3, l2, l);
    }

    private void updatePosition() {
        if (this.itemIterator == null || !this.itemIterator.hasNext()) {
            if (this.subIterator == null || !this.subIterator.hasNext()) {
                if (!this.iterator.hasNext()) {
                    this.iterator = null;
                    return;
                }
                this.firstEntry = (Map.Entry)this.iterator.next();
                this.subIterator = ((Map)this.firstEntry.getValue()).entrySet().iterator();
                if (!$assertionsDisabled && !this.subIterator.hasNext()) {
                    throw new AssertionError();
                }
            }
            this.secondEntry = (Map.Entry)this.subIterator.next();
            this.itemIterator = ((Set)this.secondEntry.getValue()).iterator();
            if (!$assertionsDisabled && !this.itemIterator.hasNext()) {
                throw new AssertionError();
            }
        }
    }

    public void remove() {
        if (this.itemIterator == null) {
            throw new IllegalStateException("Beyond end of data");
        }
        this.itemIterator.remove();
        this.cleanIndex();
        this.removeFromNonCurrentIndex();
    }

    private void cleanIndex() {
        Set set = (Set)this.secondEntry.getValue();
        if (set.isEmpty()) {
            this.subIterator.remove();
            Map map = (Map)this.firstEntry.getValue();
            if (map.isEmpty()) {
                this.iterator.remove();
            }
        }
    }

    private void removeFromNonCurrentIndex() {
        try {
            if (this.index == this.graph.index012) {
                this.graph.remove(this.graph.index120, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
                this.graph.remove(this.graph.index201, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
            }
            if (this.index == this.graph.index120) {
                this.graph.remove(this.graph.index012, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
                this.graph.remove(this.graph.index201, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
            }
            if (this.index == this.graph.index201) {
                this.graph.remove(this.graph.index012, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
                this.graph.remove(this.graph.index120, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
            }
        }
        catch (GraphException graphException) {
            throw new IllegalStateException(graphException.getMessage());
        }
    }

    public boolean close() {
        return true;
    }

    static {
        $assertionsDisabled = !GraphIterator.class.desiredAssertionStatus();
    }
}

