/*
 * Decompiled with CFR 0.152.
 */
package org.jrdf.graph.mem;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jrdf.graph.GraphException;
import org.jrdf.graph.mem.GraphElementFactoryImpl;
import org.jrdf.graph.mem.GraphImpl;
import org.jrdf.graph.mem.TripleImpl;
import org.jrdf.util.ClosableIterator;

public class TwoFixedIterator
implements ClosableIterator {
    private Iterator itemIterator;
    private GraphElementFactoryImpl nodeFactory;
    private GraphImpl graph;
    private Map index;
    private Map subIndex;
    private Set subGroup;
    private Long[] currentNodes;
    private Long first;
    private Long second;
    private int var;

    TwoFixedIterator(Map map, int n, Long l, Long l2, GraphElementFactoryImpl graphElementFactoryImpl, GraphImpl graphImpl) {
        this.nodeFactory = graphElementFactoryImpl;
        this.graph = graphImpl;
        this.index = map;
        this.first = l;
        this.second = l2;
        this.var = n;
        this.currentNodes = null;
        this.itemIterator = null;
        this.subIndex = (Map)map.get(this.first);
        if (this.subIndex != null) {
            this.subGroup = (Set)this.subIndex.get(this.second);
            if (this.subGroup != null) {
                this.itemIterator = this.subGroup.iterator();
            }
        }
    }

    public boolean hasNext() {
        return this.itemIterator != null && this.itemIterator.hasNext();
    }

    public Object next() throws NoSuchElementException {
        if (this.itemIterator == null) {
            throw new NoSuchElementException();
        }
        Long l = (Long)this.itemIterator.next();
        this.currentNodes = new Long[]{this.first, this.second, l};
        return new TripleImpl(this.nodeFactory, this.var, this.first, this.second, l);
    }

    public void remove() {
        if (this.itemIterator != null) {
            this.itemIterator.remove();
            this.cleanIndex();
            this.removeFromNonCurrentIndex();
        }
    }

    private void cleanIndex() {
        if (this.subGroup.isEmpty()) {
            this.subIndex.remove(this.second);
            if (this.subIndex.isEmpty()) {
                this.index.remove(this.first);
            }
        }
    }

    private void removeFromNonCurrentIndex() {
        try {
            if (this.index == this.graph.index012) {
                this.graph.remove(this.graph.index120, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
                this.graph.remove(this.graph.index201, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
            }
            if (this.index == this.graph.index120) {
                this.graph.remove(this.graph.index012, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
                this.graph.remove(this.graph.index201, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
            }
            if (this.index == this.graph.index201) {
                this.graph.remove(this.graph.index012, this.currentNodes[1], this.currentNodes[2], this.currentNodes[0]);
                this.graph.remove(this.graph.index120, this.currentNodes[2], this.currentNodes[0], this.currentNodes[1]);
            }
        }
        catch (GraphException graphException) {
            throw new IllegalStateException(graphException.getMessage());
        }
    }

    public boolean close() {
        return true;
    }
}

