/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.nsdl.mptstore.query.QueryException;
import org.nsdl.mptstore.query.QueryResults;
import org.nsdl.mptstore.query.RuntimeQueryException;
import org.nsdl.mptstore.query.provider.SQLProvider;
import org.nsdl.mptstore.rdf.Node;
import org.nsdl.mptstore.util.DBUtil;
import org.nsdl.mptstore.util.NTriplesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLUnionQueryResults
implements QueryResults {
    private static final Logger LOG = Logger.getLogger((String)SQLUnionQueryResults.class.getName());
    private Connection _conn;
    private SQLProvider _sqlProvider;
    private int _fetchSize;
    private boolean _autoReleaseConnection;
    private Iterator<String> _queries;
    private boolean _closed;
    private ResultSet _results;
    private Statement _statement;
    private List<Node> _nextTuple;

    public SQLUnionQueryResults(Connection conn, SQLProvider sqlProvider, int fetchSize, boolean autoReleaseConnection) throws QueryException {
        this._conn = conn;
        this._sqlProvider = sqlProvider;
        this._fetchSize = fetchSize;
        this._autoReleaseConnection = autoReleaseConnection;
        this._closed = false;
        try {
            this._queries = sqlProvider.getSQL().iterator();
            try {
                this.startNextQuery();
            }
            catch (SQLException e) {
                throw new QueryException("Error querying database", e);
            }
            this.readNextTuple();
        }
        catch (QueryException e) {
            this.close();
            throw e;
        }
    }

    private void readNextTuple() throws QueryException {
        try {
            while (this._results != null && !this._results.next()) {
                this.startNextQuery();
            }
            if (this._results == null) {
                this._nextTuple = null;
            } else {
                int tupleSize = this._sqlProvider.getTargets().size();
                this._nextTuple = new ArrayList<Node>(tupleSize);
                for (int i = 1; i <= tupleSize; ++i) {
                    String nodeString = DBUtil.getLongString(this._results, i);
                    try {
                        if (nodeString != null) {
                            this._nextTuple.add(NTriplesUtil.parseNode(nodeString));
                            continue;
                        }
                        this._nextTuple.add(null);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new QueryException("Error parsing RDF node (" + nodeString + ") from database: " + e.getMessage(), e);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new QueryException("Error querying database", e);
        }
    }

    private void startNextQuery() throws SQLException {
        if (this._queries.hasNext()) {
            if (this._results != null) {
                this._results.close();
                this._statement.close();
            }
            this._statement = this._conn.createStatement();
            this._statement.setFetchSize(this._fetchSize);
            this._statement.setFetchDirection(1000);
            String query = this._queries.next();
            LOG.info((Object)("Executing query:\n" + query));
            this._results = this._statement.executeQuery(query);
        } else {
            LOG.info((Object)"Finished executing all queries");
            this.close();
            this._results = null;
        }
    }

    @Override
    public List<String> getTargets() {
        return this._sqlProvider.getTargets();
    }

    @Override
    public boolean hasNext() {
        return this._nextTuple != null;
    }

    @Override
    public List<Node> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<Node> thisTuple = this._nextTuple;
        try {
            this.readNextTuple();
            return thisTuple;
        }
        catch (QueryException e) {
            this.close();
            LOG.error((Object)e);
            throw new RuntimeQueryException(e);
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (!this._closed) {
            if (this._results != null) {
                try {
                    this._results.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error closing result set", (Throwable)e);
                }
            }
            if (this._statement != null) {
                try {
                    this._statement.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error closing statement", (Throwable)e);
                }
            }
            if (this._autoReleaseConnection) {
                DBUtil.release(this._conn);
            }
            this._closed = true;
        }
    }

    public void finalize() {
        this.close();
    }
}

