/*
 * Decompiled with CFR 0.152.
 */
package org.nsdl.mptstore.query.component;

import java.util.HashSet;
import java.util.Set;
import org.nsdl.mptstore.query.component.MPTable;
import org.nsdl.mptstore.query.component.MappableNodePattern;
import org.nsdl.mptstore.query.component.TriplePattern;
import org.nsdl.mptstore.rdf.Node;
import org.nsdl.mptstore.rdf.ObjectNode;
import org.nsdl.mptstore.rdf.PredicateNode;
import org.nsdl.mptstore.rdf.SubjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappableTriplePattern
implements TriplePattern {
    private final MappableNodePattern<SubjectNode> subject;
    private final MappableNodePattern<PredicateNode> predicate;
    private final MappableNodePattern<ObjectNode> object;

    public MappableTriplePattern(MappableNodePattern<SubjectNode> s, MappableNodePattern<PredicateNode> p, MappableNodePattern<ObjectNode> o) {
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public MappableTriplePattern(TriplePattern pattern) {
        this.subject = new MappableNodePattern<SubjectNode>(pattern.getSubject(), SubjectNode.class);
        this.predicate = new MappableNodePattern<PredicateNode>(pattern.getPredicate(), PredicateNode.class);
        this.object = new MappableNodePattern<ObjectNode>(pattern.getObject(), ObjectNode.class);
    }

    public MappableNodePattern<SubjectNode> getSubject() {
        return this.subject;
    }

    public MappableNodePattern<PredicateNode> getPredicate() {
        return this.predicate;
    }

    public MappableNodePattern<ObjectNode> getObject() {
        return this.object;
    }

    public void bindTo(MPTable t) {
        this.subject.bindTo(t, "s");
        this.predicate.bindTo(t);
        this.object.bindTo(t, "o");
    }

    public Set<MappableNodePattern<? extends Node>> getNodes() {
        HashSet<MappableNodePattern<? extends Node>> parts = new HashSet<MappableNodePattern<? extends Node>>();
        parts.add(this.subject);
        parts.add(this.object);
        return parts;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(MappableTriplePattern.class)) {
            return false;
        }
        MappableTriplePattern pattern = (MappableTriplePattern)o;
        return this.subject.equals(pattern.subject) && this.predicate.equals(pattern.predicate) && this.object.equals(pattern.object);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object;
    }
}

