/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import proai.Writable;
import proai.error.ServerException;

public class CachedContent
implements Writable {
    private File m_file;
    private String m_dateStamp;
    private boolean m_headerOnly;
    private String m_string;

    public CachedContent(File file) {
        this.m_file = file;
    }

    public CachedContent(File file, String dateStamp, boolean headerOnly) {
        this.m_file = file;
        this.m_dateStamp = dateStamp;
        this.m_headerOnly = headerOnly;
    }

    public CachedContent(String content) {
        this.m_string = content;
    }

    public void write(PrintWriter out) throws ServerException {
        if (this.m_file != null) {
            if (this.m_dateStamp == null) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_file), "UTF-8"));
                    String line = reader.readLine();
                    while (line != null) {
                        out.println(line);
                        line = reader.readLine();
                    }
                }
                catch (Exception e) {
                    throw new ServerException("Error reading from file: " + this.m_file.getPath(), e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            this.writeChanged(out);
        } else {
            out.println(this.m_string);
        }
    }

    private void writeChanged(PrintWriter out) throws ServerException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_file), "UTF-8"));
            StringBuffer upToHeaderEnd = new StringBuffer();
            String line = reader.readLine();
            boolean sawHeaderEnd = false;
            while (line != null && !sawHeaderEnd) {
                upToHeaderEnd.append(line + "\n");
                if (line.indexOf("</h") != -1) {
                    sawHeaderEnd = true;
                }
                line = reader.readLine();
            }
            if (!sawHeaderEnd) {
                throw new ServerException("While parsing, never saw </header>");
            }
            String fixed = upToHeaderEnd.toString().replaceFirst("p>[^<]+<", "p>" + this.m_dateStamp + "<");
            if (this.m_headerOnly) {
                int headerStart = fixed.indexOf("<h");
                if (headerStart == -1) {
                    throw new ServerException("While parsing, never saw <header...");
                }
                fixed = fixed.substring(headerStart);
                int headerEnd = fixed.indexOf("</h");
                fixed = fixed.substring(0, headerEnd) + "</header>";
                out.println(fixed);
            } else {
                out.print(fixed);
                out.println(line);
                line = reader.readLine();
                while (line != null) {
                    out.println(line);
                    line = reader.readLine();
                }
            }
        }
        catch (Exception e) {
            throw new ServerException("Error reading/transforming file: " + this.m_file.getPath(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

