/*
 * Decompiled with CFR 0.152.
 */
package proai.cache;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.sf.bvalid.Validator;
import org.apache.log4j.Logger;
import proai.cache.ParsedRecord;
import proai.cache.QueueItem;
import proai.cache.RCDisk;
import proai.cache.RCDiskWriter;
import proai.cache.Updater;
import proai.driver.OAIDriver;
import proai.util.StreamUtil;

public class Worker
extends Thread {
    private static Logger _LOG = Logger.getLogger((String)Worker.class.getName());
    private Updater _updater;
    private OAIDriver _driver;
    private RCDisk _disk;
    private Validator _validator;
    private int _attemptedCount;
    private int _failedCount;
    private long _totalFetchTime;
    private long _totalValidationTime;

    public Worker(int num, int of, Updater updater, OAIDriver driver, RCDisk disk, Validator validator) {
        super("Worker-" + num + "of" + of);
        this._updater = updater;
        this._driver = driver;
        this._disk = disk;
        this._validator = validator;
    }

    public void run() {
        _LOG.info((Object)"Worker started");
        List<QueueItem> queueItems = this._updater.getNextBatch(null);
        while (queueItems != null && !this._updater.processingShouldStop()) {
            Iterator<QueueItem> iter = queueItems.iterator();
            while (iter.hasNext() && !this._updater.processingShouldStop()) {
                this.attempt(iter.next());
            }
            if (!this._updater.processingShouldStop()) {
                queueItems = this._updater.getNextBatch(queueItems);
                continue;
            }
            _LOG.debug((Object)"About to finish prematurely because processing should stop");
        }
        _LOG.info((Object)"Worker finished");
    }

    private InputStream getRecordStreamForValidation(File recordFile) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        builder.append("<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\">\n");
        builder.append("<responseDate>2002-02-08T08:55:46Z</responseDate>\n");
        builder.append("<request verb=\"GetRecord\" identifier=\"oai:arXiv.org:cs/0112017\" ");
        builder.append("metadataPrefix=\"oai_dc\">http://arXiv.org/oai2</request>\n");
        builder.append("<GetRecord>\n");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(recordFile)));
        String line = reader.readLine();
        while (line != null) {
            builder.append(line + "\n");
            line = reader.readLine();
        }
        builder.append("</GetRecord>\n");
        builder.append("</OAI-PMH>");
        return new ByteArrayInputStream(builder.toString().getBytes("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attempt(QueueItem qi) {
        RCDiskWriter diskWriter = null;
        long retrievalDelay = 0L;
        long validationDelay = 0L;
        try {
            diskWriter = this._disk.getNewWriter();
            long startFetchTime = System.currentTimeMillis();
            this._driver.writeRecordXML(qi.getIdentifier(), qi.getMDPrefix(), qi.getSourceInfo(), diskWriter);
            diskWriter.flush();
            diskWriter.close();
            long endFetchTime = System.currentTimeMillis();
            retrievalDelay = endFetchTime - startFetchTime;
            if (this._validator != null) {
                this._validator.validate(this.getRecordStreamForValidation(diskWriter.getFile()), "http://proai.sourceforge.net/schemas/OAI-PMH-record.xsd");
                validationDelay = System.currentTimeMillis() - endFetchTime;
            }
            qi.setParsedRecord(new ParsedRecord(qi.getIdentifier(), qi.getMDPrefix(), diskWriter.getPath(), diskWriter.getFile()));
            qi.setSucceeded(true);
            _LOG.info((Object)"Successfully processed record");
        }
        catch (Throwable th) {
            _LOG.warn((Object)"Failed to process record", th);
            if (diskWriter != null) {
                diskWriter.close();
                diskWriter.getFile().delete();
            }
            StringWriter failReason = new StringWriter();
            th.printStackTrace(new PrintWriter((Writer)failReason, true));
            qi.setFailReason(failReason.toString());
            qi.setFailDate(StreamUtil.nowUTCString());
            ++this._failedCount;
        }
        finally {
            ++this._attemptedCount;
            this._totalFetchTime += retrievalDelay;
            this._totalValidationTime += validationDelay;
        }
    }

    public int getAttemptedCount() {
        return this._attemptedCount;
    }

    public int getFailedCount() {
        return this._failedCount;
    }

    public long getTotalFetchTime() {
        return this._totalFetchTime;
    }

    public long getTotalValidationTime() {
        return this._totalValidationTime;
    }
}

