/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import proai.Writable;
import proai.cache.RecordCache;
import proai.error.BadArgumentException;
import proai.error.BadResumptionTokenException;
import proai.error.CannotDisseminateFormatException;
import proai.error.IdDoesNotExistException;
import proai.error.NoMetadataFormatsException;
import proai.error.NoRecordsMatchException;
import proai.error.NoSetHierarchyException;
import proai.error.ServerException;
import proai.service.RecordListProvider;
import proai.service.ResponseData;
import proai.service.ResponseDataImpl;
import proai.service.SessionManager;
import proai.service.SetListProvider;

public class Responder {
    private static final String _PFX = "proai.";
    public static final String PROP_INCOMPLETESETLISTSIZE = "proai.incompleteSetListSize";
    public static final String PROP_INCOMPLETERECORDLISTSIZE = "proai.incompleteRecordListSize";
    public static final String PROP_INCOMPLETEIDENTIFIERLISTSIZE = "proai.incompleteRecordListSize";
    public static final String ERR_MISSING_IDENTIFIER = "identifier must be specified";
    public static final String ERR_MISSING_PREFIX = "metadataPrefix must be specified";
    public static final String ERR_ITEM_DOESNT_EXIST = "the indicated item does not exist";
    public static final String ERR_BAD_FORMAT_FOR_ITEM = "the indicated item does not support that metadata format";
    public static final String ERR_NO_FORMATS_FOR_ITEM = "the indicated item has no metadata formats";
    public static final String ERR_NO_SET_HIERARCHY = "there are no sets in the repository";
    public static final String ERR_RESUMPTION_EXCLUSIVE = "the resumptionToken argument may only be specified by itself";
    public static final String ERR_DATE_FORMAT = "specified date is not syntactically valid";
    public static final String ERR_FROM_UNTIL = "from date cannot be greater than until date";
    public static final String ERR_NO_SUCH_FORMAT = "the metadataPrefix is unrecognized";
    public static final String ERR_NO_RECORDS_MATCH = "no records match your selection criteria";
    private static final Logger logger = Logger.getLogger((String)Responder.class.getName());
    private RecordCache m_cache;
    private int m_incompleteIdentifierListSize;
    private int m_incompleteRecordListSize;
    private int m_incompleteSetListSize;
    private SessionManager m_sessionManager;

    public Responder(Properties props) throws ServerException {
        this.init(new RecordCache(props), new SessionManager(props), this.nonNegativeValue(props, "proai.incompleteRecordListSize", true), this.nonNegativeValue(props, "proai.incompleteRecordListSize", true), this.nonNegativeValue(props, PROP_INCOMPLETESETLISTSIZE, true));
    }

    private int nonNegativeValue(Properties props, String name, boolean nonZero) throws ServerException {
        String v = props.getProperty(name);
        if (v == null) {
            throw new ServerException("Required property missing: " + name);
        }
        try {
            int val = Integer.parseInt(v);
            if (val < 0) {
                throw new ServerException("Property value cannot be negative: " + name);
            }
            if (nonZero && val == 0) {
                throw new ServerException("Property value cannot be zero: " + name);
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new ServerException("Bad integer '" + v + "' specified for property: " + name);
        }
    }

    public Responder(RecordCache cache, SessionManager sessionManager, int incompleteIdentifierListSize, int incompleteRecordListSize, int incompleteSetListSize) throws ServerException {
        this.init(cache, sessionManager, incompleteIdentifierListSize, incompleteRecordListSize, incompleteSetListSize);
    }

    private void init(RecordCache cache, SessionManager sessionManager, int incompleteIdentifierListSize, int incompleteRecordListSize, int incompleteSetListSize) {
        this.m_cache = cache;
        this.m_sessionManager = sessionManager;
        this.m_incompleteIdentifierListSize = incompleteIdentifierListSize;
        this.m_incompleteRecordListSize = incompleteRecordListSize;
        this.m_incompleteSetListSize = incompleteSetListSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData getRecord(String identifier, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, IdDoesNotExistException, ServerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entered getRecord(" + Responder.q(identifier) + ", " + Responder.q(metadataPrefix) + ")"));
        }
        try {
            ResponseDataImpl data;
            Responder.checkIdentifier(identifier);
            Responder.checkMetadataPrefix(metadataPrefix);
            Writable content = this.m_cache.getRecordContent(identifier, metadataPrefix);
            if (content == null) {
                this.checkItemExists(identifier);
                throw new CannotDisseminateFormatException(ERR_BAD_FORMAT_FOR_ITEM);
            }
            ResponseDataImpl responseDataImpl = data = new ResponseDataImpl(content);
            return responseDataImpl;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exiting getRecord(" + Responder.q(identifier) + ", " + Responder.q(metadataPrefix) + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData identify() throws ServerException {
        logger.debug((Object)"Entered identify()");
        try {
            ResponseDataImpl data;
            ResponseDataImpl responseDataImpl = data = new ResponseDataImpl(this.m_cache.getIdentifyContent());
            return responseDataImpl;
        }
        finally {
            logger.debug((Object)"Exiting identify()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData listIdentifiers(String from, String until, String metadataPrefix, String set, String resumptionToken) throws BadArgumentException, BadResumptionTokenException, CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, ServerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entered listIdentifiers(" + Responder.q(from) + ", " + Responder.q(until) + ", " + Responder.q(metadataPrefix) + ", " + Responder.q(set) + ", " + Responder.q(resumptionToken) + ")"));
        }
        try {
            ResponseData responseData = this.listRecords(from, until, metadataPrefix, set, resumptionToken, true, this.m_incompleteIdentifierListSize);
            return responseData;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exiting listIdentifiers(" + Responder.q(from) + ", " + Responder.q(until) + ", " + Responder.q(metadataPrefix) + ", " + Responder.q(set) + ", " + Responder.q(resumptionToken) + ")"));
            }
        }
    }

    private ResponseData listRecords(String from, String until, String metadataPrefix, String set, String resumptionToken, boolean identifiersOnly, int incompleteListSize) throws BadArgumentException, BadResumptionTokenException, CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, ServerException {
        if (resumptionToken == null) {
            Date fromDate = Responder.validDate(from);
            Date untilDate = Responder.validDate(until);
            Responder.checkGranularity(from, until);
            Responder.checkFromUntil(fromDate, untilDate);
            Responder.checkMetadataPrefix(metadataPrefix);
            RecordListProvider provider = new RecordListProvider(this.m_cache, incompleteListSize, identifiersOnly, fromDate, untilDate, metadataPrefix, set);
            return this.m_sessionManager.list(provider);
        }
        if (from != null || until != null || metadataPrefix != null || set != null) {
            throw new BadArgumentException(ERR_RESUMPTION_EXCLUSIVE);
        }
        return this.m_sessionManager.getResponseData(resumptionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData listMetadataFormats(String identifier) throws IdDoesNotExistException, NoMetadataFormatsException, ServerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entered listMetadataFormats(" + Responder.q(identifier) + ")"));
        }
        try {
            ResponseDataImpl data;
            Writable content = null;
            content = this.m_cache.getMetadataFormatsContent(identifier);
            if (content == null && identifier != null) {
                this.checkItemExists(identifier);
                throw new NoMetadataFormatsException(ERR_NO_FORMATS_FOR_ITEM);
            }
            ResponseDataImpl responseDataImpl = data = new ResponseDataImpl(content);
            return responseDataImpl;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exiting listMetadataFormats(" + Responder.q(identifier) + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData listRecords(String from, String until, String metadataPrefix, String set, String resumptionToken) throws BadArgumentException, BadResumptionTokenException, CannotDisseminateFormatException, NoRecordsMatchException, NoSetHierarchyException, ServerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entered listRecords(" + Responder.q(from) + ", " + Responder.q(until) + ", " + Responder.q(metadataPrefix) + ", " + Responder.q(set) + ", " + Responder.q(resumptionToken) + ")"));
        }
        try {
            ResponseData responseData = this.listRecords(from, until, metadataPrefix, set, resumptionToken, false, this.m_incompleteRecordListSize);
            return responseData;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exiting listRecords(" + Responder.q(from) + ", " + Responder.q(until) + ", " + Responder.q(metadataPrefix) + ", " + Responder.q(set) + ", " + Responder.q(resumptionToken) + ")"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData listSets(String resumptionToken) throws BadResumptionTokenException, NoSetHierarchyException, ServerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entered listSets(" + Responder.q(resumptionToken) + ")"));
        }
        try {
            if (resumptionToken == null) {
                SetListProvider provider = new SetListProvider(this.m_cache, this.m_incompleteSetListSize);
                ResponseData responseData = this.m_sessionManager.list(provider);
                return responseData;
            }
            ResponseData responseData = this.m_sessionManager.getResponseData(resumptionToken);
            return responseData;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exiting listSets(" + Responder.q(resumptionToken) + ")"));
            }
        }
    }

    private static String q(String s) {
        if (s == null) {
            return null;
        }
        return "\"" + s + "\"";
    }

    public void close() throws ServerException {
        this.m_sessionManager.close();
        this.m_cache.close();
    }

    private static void checkIdentifier(String identifier) throws BadArgumentException {
        if (identifier == null || identifier.length() == 0) {
            throw new BadArgumentException(ERR_MISSING_IDENTIFIER);
        }
    }

    private static void checkMetadataPrefix(String metadataPrefix) throws BadArgumentException {
        if (metadataPrefix == null || metadataPrefix.length() == 0) {
            throw new BadArgumentException(ERR_MISSING_PREFIX);
        }
    }

    private static Date validDate(String dateString) throws BadArgumentException {
        if (dateString == null) {
            return null;
        }
        SimpleDateFormat parser = dateString.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        try {
            return parser.parse(dateString);
        }
        catch (Exception e) {
            throw new BadArgumentException(ERR_DATE_FORMAT);
        }
    }

    private static void checkGranularity(String from, String until) throws BadArgumentException {
        if (from != null && until != null && (from.endsWith("Z") && !until.endsWith("Z") || until.endsWith("Z") && !from.endsWith("Z"))) {
            throw new BadArgumentException("Date granularities of from and until arguments do not match.");
        }
    }

    private static void checkFromUntil(Date from, Date until) throws BadArgumentException {
        if (from != null && until != null && from.getTime() > until.getTime()) {
            throw new BadArgumentException(ERR_FROM_UNTIL);
        }
    }

    private void checkItemExists(String identifier) throws IdDoesNotExistException, ServerException {
        if (!this.m_cache.itemExists(identifier)) {
            throw new IdDoesNotExistException(ERR_ITEM_DOESNT_EXIST);
        }
    }
}

