/*
 * Decompiled with CFR 0.152.
 */
package proai.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.log4j.Logger;
import proai.CloseableIterator;
import proai.Writable;
import proai.cache.CachedContent;
import proai.error.BadResumptionTokenException;
import proai.error.ServerException;
import proai.service.ListProvider;
import proai.service.ResponseData;
import proai.service.ResponseDataImpl;
import proai.service.Session;
import proai.service.SessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotSession<T>
extends Thread
implements Session {
    private static final Logger logger = Logger.getLogger((String)SnapshotSession.class.getName());
    private SessionManager m_manager;
    private File m_baseDir;
    private int m_secondsBetweenRequests;
    private ListProvider<T> m_provider;
    private String m_sessionKey;
    private int m_threadWorkingPart;
    private int m_lastGeneratedPart;
    private int m_lastSentPart;
    private long m_expirationTime;
    private ServerException m_exception;
    private boolean m_threadNeedsToFinish;
    private boolean m_threadWorking;

    public SnapshotSession(SessionManager manager, File baseDir, int secondsBetweenRequests, ListProvider<T> provider) {
        this.m_manager = manager;
        this.m_baseDir = baseDir;
        this.m_secondsBetweenRequests = secondsBetweenRequests;
        this.m_provider = provider;
        String s = "" + this.hashCode();
        this.m_sessionKey = s.startsWith("-") ? "Z" + s.substring(1) : "X" + s;
        this.m_threadWorkingPart = 0;
        this.m_lastGeneratedPart = -1;
        this.m_lastSentPart = -1;
        this.m_threadWorking = true;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)(this.m_sessionKey + " retrieval thread started"));
        int incompleteListSize = this.m_provider.getIncompleteListSize();
        CloseableIterator<T> iter = null;
        PrintWriter out = null;
        try {
            iter = this.m_provider.getList();
            this.m_manager.addSession(this.m_sessionKey, this);
            File sessionDir = new File(this.m_baseDir, this.m_sessionKey);
            sessionDir.mkdirs();
            int cursor = 0;
            while (iter.hasNext() && !this.m_threadNeedsToFinish) {
                File partFile = new File(sessionDir, this.m_threadWorkingPart + ".xml");
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(partFile), "UTF-8"));
                out.println("<" + this.m_provider.getVerb() + ">");
                for (int i = 0; i < incompleteListSize && iter.hasNext(); ++i) {
                    Writable writable = (Writable)iter.next();
                    writable.write(out);
                }
                if (iter.hasNext()) {
                    int nextPartNum = this.m_threadWorkingPart + 1;
                    String token = this.m_sessionKey + "/" + nextPartNum;
                    out.println("<resumptionToken cursor=\"" + cursor + "\">" + token + "</resumptionToken>");
                    cursor += incompleteListSize;
                } else if (cursor > 0) {
                    out.println("<resumptionToken cursor=\"" + cursor + "\"/>");
                }
                out.println("</" + this.m_provider.getVerb() + ">");
                out.close();
                ++this.m_lastGeneratedPart;
                if (!iter.hasNext()) continue;
                ++this.m_threadWorkingPart;
            }
        }
        catch (ServerException e) {
            this.m_exception = e;
        }
        catch (Throwable th) {
            this.m_exception = new ServerException("Unexpected error in session thread", th);
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
            this.m_threadWorking = false;
            logger.info((Object)(this.m_sessionKey + " retrieval thread finished"));
        }
    }

    @Override
    public boolean hasExpired() {
        if (this.m_exception != null) {
            return true;
        }
        if (this.m_lastGeneratedPart >= 0) {
            return this.m_expirationTime < System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public void clean() {
        this.m_threadNeedsToFinish = true;
        while (this.m_threadWorking) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception e) {}
        }
        File sessionDir = new File(this.m_baseDir, this.m_sessionKey);
        File[] files = sessionDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
        sessionDir.delete();
    }

    @Override
    public ResponseData getResponseData(int partNum) throws ServerException, BadResumptionTokenException {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        int nextPart = this.m_lastSentPart + 1;
        if (partNum == this.m_lastSentPart || partNum == nextPart) {
            while (this.m_threadWorking && this.m_lastGeneratedPart < partNum) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {}
            }
            if (this.m_exception != null) {
                throw this.m_exception;
            }
            File partFile = new File(this.m_baseDir, this.m_sessionKey + "/" + partNum + ".xml");
            if (!partFile.exists()) {
                throw new BadResumptionTokenException("the indicated part does not exist");
            }
            String token = this.getResumptionToken(partNum + 1);
            ResponseDataImpl response = new ResponseDataImpl(new CachedContent(partFile), token);
            if (partNum > 0) {
                int previousPart = partNum - 1;
                new File(this.m_baseDir, this.m_sessionKey + "/" + previousPart + ".xml").delete();
            }
            this.m_lastSentPart = partNum;
            this.m_expirationTime = new Date().getTime() + (long)(1000 * this.m_secondsBetweenRequests);
            logger.info((Object)(this.m_sessionKey + " returning part " + partNum));
            return response;
        }
        throw new BadResumptionTokenException("the indicated part either doesn't exist yet or has expired");
    }

    private String getResumptionToken(int partNum) {
        if (this.m_threadWorking) {
            if (this.m_threadWorkingPart >= partNum) {
                return this.m_sessionKey + "/" + partNum;
            }
            return null;
        }
        if (partNum <= this.m_lastGeneratedPart) {
            return this.m_sessionKey + "/" + partNum;
        }
        return null;
    }

    public void finalize() {
        this.clean();
    }
}

