/*
 * Decompiled with CFR 0.152.
 */
package proai.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import proai.error.ProtocolException;
import proai.error.ServerException;
import proai.service.Responder;
import proai.service.ResponseData;

public class ResponderTest
extends TestCase {
    private static int initCount = 0;
    private Responder m_responder;
    private boolean m_print;

    public void setUp() {
        this.m_responder = new Responder(System.getProperties());
        this.m_print = false;
        try {
            if (initCount == 0) {
                System.out.println("Allowing 10 seconds for initial update.");
                Thread.sleep(10000L);
            }
            ++initCount;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAll() throws Exception {
        System.out.println("Running testAll()...");
        this.doListMetadataFormatsTest(null);
        this.doListMetadataFormatsTest("oai:example.org:item1");
        this.doListMetadataFormatsTest("oai:example.org:item4");
        this.doListSetsTest();
        this.doListRecordsTest(null, null, "oai_dc", null);
        this.doListRecordsTest(null, null, "test_format", null);
        this.doListRecordsTest("2005-01-01T08:53:00Z", null, "test_format", "prime");
        this.doListRecordsTest(null, "2005-01-01T08:53:00Z", "oai_dc", "prime");
        this.doListIdentifiersTest(null, null, "oai_dc", null);
        this.doListIdentifiersTest(null, null, "test_format", null);
        this.doListIdentifiersTest("2005-01-01T08:53:00Z", null, "test_format", "prime");
        this.doListIdentifiersTest(null, "2005-01-01T08:53:00Z", "oai_dc", "prime");
    }

    public void testGetGoodRecords() throws Exception {
        System.out.println("Running testGetGoodRecords()...");
        this.doGetGoodRecord("oai:example.org:item1", "oai_dc");
        this.doGetGoodRecord("oai:example.org:item1", "test_format");
        this.doGetGoodRecord("oai:example.org:item2", "oai_dc");
        this.doGetGoodRecord("oai:example.org:item2", "test_format");
        this.doGetGoodRecord("oai:example.org:item3", "oai_dc");
        this.doGetGoodRecord("oai:example.org:item3", "test_format");
        this.doGetGoodRecord("oai:example.org:item4", "oai_dc");
        this.doGetGoodRecord("oai:example.org:item5", "oai_dc");
    }

    private void doGetGoodRecord(String item, String prefix) throws Exception {
        try {
            this.tryGetRecord(item, prefix);
            System.out.println("doGetGoodRecord success for " + item + "/" + prefix);
        }
        catch (ServerException e) {
            ResponderTest.assertEquals((String)("Failed to get " + prefix + " record of item: " + item + " (Error message was: " + e.getMessage() + ")"), (boolean)true, (boolean)false);
        }
    }

    public void testGetBadRecords() throws Exception {
        System.out.println("Running testGetBadRecords()...");
        this.doGetBadRecord("oai:example.org:item1", "nonexisting_format");
        this.doGetBadRecord("oai:example.org:nonexisting_item", "oai_dc");
        this.doGetBadRecord("oai:example.org:nonexisting_item", "nonexisting_format");
    }

    private void doGetBadRecord(String item, String prefix) throws Exception {
        try {
            this.tryGetRecord(item, prefix);
            ResponderTest.assertEquals((String)("Expected failure to get " + prefix + " record for item: " + item), (boolean)true, (boolean)false);
        }
        catch (ServerException e) {
            System.out.println("doGetBadRecord success for " + item + "/" + prefix + " : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryGetRecord(String item, String prefix) throws Exception {
        ResponseData data = null;
        try {
            data = this.m_responder.getRecord(item, prefix);
            if (this.m_print) {
                this.printResult("getRecord(" + item + ", " + prefix + ")", data);
            }
        }
        finally {
            if (data != null) {
                try {
                    data.release();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIdentify() throws Exception {
        ResponseData data = null;
        try {
            data = this.m_responder.identify();
            if (this.m_print) {
                this.printResult("identify()", data);
            }
        }
        finally {
            if (data != null) {
                try {
                    data.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doListMetadataFormatsTest(String item) throws Exception {
        ResponseData data = null;
        try {
            data = this.m_responder.listMetadataFormats(item);
            if (this.m_print) {
                this.printResult("listMetadataFormats(" + item + ")", data);
            }
        }
        finally {
            if (data != null) {
                try {
                    data.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doListSetsTest() throws Exception {
        ResponseData data = null;
        try {
            data = this.m_responder.listSets(null);
            if (this.m_print) {
                this.printResult("listSets(null)", data);
            }
            String token = data.getResumptionToken();
            while (token != null) {
                try {
                    data.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                data = this.m_responder.listSets(token);
                if (this.m_print) {
                    this.printResult("listSets(" + token + ")", data);
                }
                data = this.m_responder.listSets(token);
                if (this.m_print) {
                    this.printResult("listSets(" + token + ")", data);
                }
                token = data.getResumptionToken();
            }
        }
        finally {
            if (data != null) {
                try {
                    data.release();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void doListRecordsTest(String from, String until, String prefix, String set) throws Exception {
        this.doListRecordsOrIdentifiersTest(from, until, prefix, set, false);
    }

    private void doListIdentifiersTest(String from, String until, String prefix, String set) throws Exception {
        this.doListRecordsOrIdentifiersTest(from, until, prefix, set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doListRecordsOrIdentifiersTest(String from, String until, String prefix, String set, boolean identifiers) throws Exception {
        ResponseData data = null;
        String which = null;
        try {
            if (identifiers) {
                which = "Identifiers";
                data = this.m_responder.listIdentifiers(from, until, prefix, set, null);
            } else {
                which = "Records";
                data = this.m_responder.listRecords(from, until, prefix, set, null);
            }
            if (this.m_print) {
                this.printResult("list" + which + "(" + from + ", " + until + ", " + prefix + ", " + set + ", null)", data);
            }
            String token = data.getResumptionToken();
            while (token != null) {
                try {
                    data.release();
                }
                catch (Exception e) {
                    // empty catch block
                }
                data = identifiers ? this.m_responder.listIdentifiers(null, null, null, null, token) : this.m_responder.listRecords(null, null, null, null, token);
                if (this.m_print) {
                    this.printResult("list" + which + "(null, null, null, null, " + token + ")", data);
                }
                token = data.getResumptionToken();
            }
        }
        catch (ProtocolException e) {
            System.out.println("For from = " + from + ", until = " + until + ", prefix = " + prefix + ", set = " + set + ", List" + which + " got protocol exception: " + e.getMessage());
        }
        finally {
            if (data != null) {
                try {
                    data.release();
                }
                catch (Exception e) {}
            }
        }
    }

    private void printResult(String call, ResponseData data) {
        StringWriter writer = new StringWriter();
        data.write(new PrintWriter((Writer)writer, true));
        System.out.println("Result of " + call);
        System.out.println(writer.toString());
    }

    public void tearDown() {
        this.m_responder.close();
    }

    public ResponderTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ResponderTest.class);
    }
}

