/*
 * Decompiled with CFR 0.152.
 */
package proai.util;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import proai.SetInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetSpec {
    public static boolean hasParents(String spec) {
        return spec != null && spec.contains(":");
    }

    public static String parentOf(String spec) {
        int boundary = spec.lastIndexOf(58);
        if (boundary > 0) {
            return spec.substring(0, boundary);
        }
        return null;
    }

    public static boolean isValid(String spec) {
        return spec.matches("([A-Za-z0-9_!'$\\(\\)\\+\\-\\.\\*])+(:[A-Za-z0-9_!'$\\(\\)\\+\\-\\.\\*]+)*");
    }

    public static Set<String> allSetsFor(String spec) {
        String parent;
        HashSet<String> ancestors = new HashSet<String>();
        ancestors.add(spec);
        if (SetSpec.hasParents(spec) && (parent = SetSpec.parentOf(spec)) != null) {
            ancestors.add(parent);
            ancestors.addAll(SetSpec.allSetsFor(parent));
        }
        return ancestors;
    }

    public static SetInfo defaultInfoFor(final String setSpec) {
        return new SetInfo(){

            public void write(PrintWriter w) {
                w.println("<set>");
                w.println("  <setSpec>" + setSpec + "</setSpec>");
                w.println("  <setName>" + setSpec + "</setName>");
                w.println("</set>");
            }

            public String getSetSpec() {
                return setSpec;
            }
        };
    }
}

