/*
 * Decompiled with CFR 0.152.
 */
package proai.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class StreamUtil {
    public static final int STREAM_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(InputStream inStream, OutputStream outStream) throws IOException {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = inStream.read(buf)) > 0) {
                outStream.write(buf, 0, len);
            }
        }
        finally {
            inStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(InputStream in, String encoding) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));
            StringBuffer out = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                out.append(line + "\n");
                line = reader.readLine();
            }
            String string = out.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static String xmlEncode(String in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '<') {
                out.append("&gt;");
                continue;
            }
            if (c == '>') {
                out.append("&lt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c == '\"') {
                out.append("&quot;");
                continue;
            }
            if (c == '\'') {
                out.append("&apos;");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static Date nowUTC() {
        return StreamUtil.convertLocalDateToUTCDate(new Date());
    }

    public static String nowUTCString() {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            return formatter.format(StreamUtil.nowUTC());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date convertLocalDateToUTCDate(Date localDate) {
        Calendar cal = Calendar.getInstance();
        int tzOffset = cal.get(15);
        TimeZone tz = cal.getTimeZone();
        if (tz.inDaylightTime(localDate)) {
            tzOffset += cal.get(16);
        }
        Date UTCDate = new Date();
        UTCDate.setTime(localDate.getTime() - (long)tzOffset);
        return UTCDate;
    }
}

