/*
 * Decompiled with CFR 0.152.
 */
package proai.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import proai.util.ColumnSpec;
import proai.util.TableSpecDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSpec {
    private String m_name;
    private List<ColumnSpec> m_columnSpecs;
    private String m_primaryColumnName;
    private String m_type;

    public TableSpec(String name, List<ColumnSpec> columnSpecs, String primaryColumnName) {
        this.m_name = name;
        this.m_columnSpecs = columnSpecs;
        this.m_primaryColumnName = primaryColumnName;
    }

    public TableSpec(String name, List<ColumnSpec> columnSpecs, String primaryColumnName, String type) {
        this.m_name = name;
        this.m_columnSpecs = columnSpecs;
        this.m_primaryColumnName = primaryColumnName;
        this.m_type = type;
    }

    public static List<TableSpec> getTableSpecs(InputStream in) throws IOException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser parser = spf.newSAXParser();
            TableSpecDeserializer tsd = new TableSpecDeserializer();
            parser.parse(in, (DefaultHandler)tsd);
            return tsd.getTableSpecs();
        }
        catch (Exception e) {
            throw new IOException("Error parsing XML: " + e.getMessage());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getPrimaryColumnName() {
        return this.m_primaryColumnName;
    }

    public String getType() {
        return this.m_type;
    }

    public Iterator<ColumnSpec> columnSpecIterator() {
        return this.m_columnSpecs.iterator();
    }
}

