/*
 * Decompiled with CFR 0.152.
 */
package org.trippi;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.jrdf.graph.AbstractBlankNode;
import org.jrdf.graph.AbstractLiteral;
import org.jrdf.graph.AbstractTriple;
import org.jrdf.graph.AbstractURIReference;
import org.jrdf.graph.BlankNode;
import org.jrdf.graph.GraphElementFactory;
import org.jrdf.graph.GraphElementFactoryException;
import org.jrdf.graph.Literal;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;

public class RDFUtil
implements GraphElementFactory,
Serializable {
    private Map m_blankMap = null;

    public static String toString(Node node) {
        if (node == null) {
            return "null";
        }
        if (node instanceof URIReference) {
            URIReference n = (URIReference)node;
            return "<" + n.getURI().toString() + ">";
        }
        if (node instanceof BlankNode) {
            return "_node" + node.hashCode();
        }
        Literal n = (Literal)node;
        StringBuffer out = new StringBuffer();
        out.append("\"" + RDFUtil.escapeLiteral(n.getLexicalForm()) + "\"");
        if (n.getLanguage() != null && n.getLanguage().length() > 0) {
            out.append("@" + n.getLanguage());
        } else if (n.getDatatypeURI() != null) {
            out.append("^^" + n.getDatatypeURI().toString());
        }
        return out.toString();
    }

    public static String toString(Triple triple) {
        return RDFUtil.toString((Node)triple.getSubject()) + " " + RDFUtil.toString((Node)triple.getPredicate()) + " " + RDFUtil.toString((Node)triple.getObject());
    }

    public Node parse(String n) throws GraphElementFactoryException, URISyntaxException {
        if (this.m_blankMap == null) {
            this.m_blankMap = new HashMap();
        }
        if (n.length() > 0) {
            char c = n.charAt(0);
            if (c == '<' && n.length() > 4) {
                return this.createResource(new URI(RDFUtil.stripFirstAndLast(n)));
            }
            if ((c == '\"' || c == '\'') && n.length() > 1) {
                int i = n.lastIndexOf(c);
                if (i == n.length() - 1) {
                    return this.createLiteral(RDFUtil.unescapeLiteral(RDFUtil.stripFirstAndLast(n)));
                }
                String uriString = n.substring(1, i);
                String qualifier = n.substring(i + 1);
                if (qualifier.startsWith("@")) {
                    return this.createLiteral(uriString, qualifier.substring(1));
                }
                if (qualifier.startsWith("^^")) {
                    return this.createLiteral(uriString, new URI(qualifier.substring(2)));
                }
                throw new GraphElementFactoryException("Malformed literal: " + n);
            }
            if (c == '_') {
                Node blankNode = (Node)this.m_blankMap.get(n);
                if (blankNode == null) {
                    blankNode = this.createResource();
                    this.m_blankMap.put(n, blankNode);
                }
                return blankNode;
            }
        }
        throw new GraphElementFactoryException("Could not parse as Node: " + n);
    }

    private static String stripFirstAndLast(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 1; i < s.length() - 1; ++i) {
            out.append(s.charAt(i));
        }
        return out.toString();
    }

    private static String escapeLiteral(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                out.append("\\\"");
                continue;
            }
            if (c == '\\') {
                out.append("\\\\");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static String unescapeLiteral(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                char d = s.charAt(++i);
                out.append(d);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public BlankNode createResource(int hashCode) {
        return new FreeBlankNode(hashCode);
    }

    public Literal createLiteral(String lexicalValue) throws GraphElementFactoryException {
        return new FreeLiteral(lexicalValue);
    }

    public Literal createLiteral(String lexicalValue, String languageType) throws GraphElementFactoryException {
        return new FreeLiteral(lexicalValue, languageType);
    }

    public Literal createLiteral(String lexicalValue, URI datatypeURI) throws GraphElementFactoryException {
        return new FreeLiteral(lexicalValue, datatypeURI);
    }

    public BlankNode createResource() throws GraphElementFactoryException {
        return new FreeBlankNode(new Object());
    }

    public URIReference createResource(URI uri) throws GraphElementFactoryException {
        return new FreeURIReference(uri);
    }

    public URIReference createResource(URI uri, boolean validate) throws GraphElementFactoryException {
        return new FreeURIReference(uri, validate);
    }

    public Triple createTriple(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws GraphElementFactoryException {
        return new FreeTriple(subject, predicate, object);
    }

    public class FreeTriple
    extends AbstractTriple {
        public FreeTriple(SubjectNode subjectNode, PredicateNode predicateNode, ObjectNode objectNode) {
            this.subjectNode = subjectNode;
            this.predicateNode = predicateNode;
            this.objectNode = objectNode;
        }
    }

    public class FreeURIReference
    extends AbstractURIReference {
        public FreeURIReference(URI uri) {
            super(uri);
        }

        public FreeURIReference(URI uri, boolean validate) {
            super(uri, validate);
        }
    }

    public class FreeLiteral
    extends AbstractLiteral {
        public FreeLiteral(String lexicalForm) {
            this.lexicalForm = lexicalForm;
        }

        public FreeLiteral(String lexicalForm, String language) {
            this.lexicalForm = lexicalForm;
            this.language = language;
        }

        public FreeLiteral(String lexicalForm, URI datatypeURI) {
            this.lexicalForm = lexicalForm;
            this.datatypeURI = datatypeURI;
        }
    }

    public class FreeBlankNode
    extends AbstractBlankNode {
        private int m_hashCode;
        private Object m_object;

        public FreeBlankNode(int hashCode) {
            this.m_hashCode = hashCode;
        }

        public FreeBlankNode(Object object) {
            this.m_object = object;
            this.m_hashCode = object.hashCode();
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }
}

